/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import java.util.Collection;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.RestrictionDoneDegreeModule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentResultType;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;

public class RestrictionDoneDegreeModuleExecutor
extends CurricularRuleExecutor {
    @Override
    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        RestrictionDoneDegreeModule rule = (RestrictionDoneDegreeModule)((Object)curricularRule);
        ExecutionSemester executionSemester = enrolmentContext.getExecutionPeriod();
        if (!this.canApplyRule(enrolmentContext, (ICurricularRule)((Object)rule))) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        CurricularCourse curricularCourse = rule.getPrecedenceDegreeModule();
        if (this.isEnrolling(enrolmentContext, (DegreeModule)((Object)curricularCourse)) || this.isEnroled(enrolmentContext, curricularCourse, executionSemester)) {
            return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.RestrictionDoneDegreeModuleExecutor.cannot.enrol.simultaneously.to.degreeModule.and.precedenceDegreeModule", rule.getDegreeModuleToApplyRule().getName(), rule.getPrecedenceDegreeModule().getName());
        }
        if (this.isApproved(enrolmentContext, curricularCourse)) {
            return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        if (this.isEnroled(enrolmentContext, (DegreeModule)((Object)rule.getDegreeModuleToApplyRule()))) {
            return this.createImpossibleRuleResult(rule, sourceDegreeModuleToEvaluate);
        }
        return this.createFalseRuleResult(rule, sourceDegreeModuleToEvaluate);
    }

    @Override
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        RestrictionDoneDegreeModule rule = (RestrictionDoneDegreeModule)((Object)curricularRule);
        ExecutionSemester executionSemester = enrolmentContext.getExecutionPeriod();
        if (!this.canApplyRule(enrolmentContext, (ICurricularRule)((Object)rule))) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        CurricularCourse curricularCourse = rule.getPrecedenceDegreeModule();
        if (this.isEnrolling(enrolmentContext, (DegreeModule)((Object)curricularCourse)) || this.isEnroled(enrolmentContext, curricularCourse, executionSemester)) {
            return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.RestrictionDoneDegreeModuleExecutor.cannot.enrol.simultaneously.to.degreeModule.and.precedenceDegreeModule", rule.getDegreeModuleToApplyRule().getName(), rule.getPrecedenceDegreeModule().getName());
        }
        if (this.isApproved(enrolmentContext, curricularCourse)) {
            return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        if (this.hasEnrolmentWithEnroledState(enrolmentContext, curricularCourse, executionSemester.getPreviousExecutionPeriod())) {
            return RuleResult.createTrue(EnrolmentResultType.TEMPORARY, sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        if (this.isEnroled(enrolmentContext, rule.getDegreeModuleToApplyRule(), executionSemester)) {
            return this.createImpossibleRuleResult(rule, sourceDegreeModuleToEvaluate);
        }
        return this.createFalseRuleResult(rule, sourceDegreeModuleToEvaluate);
    }

    private RuleResult createFalseRuleResult(RestrictionDoneDegreeModule rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.RestrictionDoneDegreeModuleExecutor.student.is.not.approved.to.precendenceDegreeModule", rule.getDegreeModuleToApplyRule().getName(), rule.getPrecedenceDegreeModule().getName());
    }

    private RuleResult createImpossibleRuleResult(RestrictionDoneDegreeModule rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate) {
        return RuleResult.createImpossible(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.RestrictionDoneDegreeModuleExecutor.student.is.not.approved.to.precendenceDegreeModule", rule.getDegreeModuleToApplyRule().getName(), rule.getPrecedenceDegreeModule().getName());
    }

    @Override
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        RestrictionDoneDegreeModule restrictionDoneDegreeModule = (RestrictionDoneDegreeModule)((Object)curricularRule);
        Collection cycleCourseGroups = restrictionDoneDegreeModule.getPrecedenceDegreeModule().getParentCycleCourseGroups();
        for (CycleCourseGroup cycleCourseGroup : cycleCourseGroups) {
            CycleCurriculumGroup cycleCurriculumGroup = (CycleCurriculumGroup)((Object)enrolmentContext.getStudentCurricularPlan().findCurriculumGroupFor((CourseGroup)((Object)cycleCourseGroup)));
            if (cycleCurriculumGroup == null) continue;
            return true;
        }
        return false;
    }
}

