/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.MaximumNumberOfCreditsForEnrolmentPeriod_Base;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.GenericPair;

public class MaximumNumberOfCreditsForEnrolmentPeriod
extends MaximumNumberOfCreditsForEnrolmentPeriod_Base {
    public static final double MAXIMUM_NUMBER_OF_CREDITS = 40.5;
    public static final double MAXIMUM_NUMBER_OF_CREDITS_PARTIAL_TIME = 20.25;
    private static final double ACCUMULATED_FACTOR = 1.0;

    public MaximumNumberOfCreditsForEnrolmentPeriod(DegreeModule degreeModuleToApplyRule, ExecutionSemester begin, ExecutionSemester end) {
        this.checkDegreeModule(degreeModuleToApplyRule);
        this.init(degreeModuleToApplyRule, null, begin, end, CurricularRuleType.MAXIMUM_NUMBER_OF_CREDITS_FOR_ENROLMENT_PERIOD);
    }

    public MaximumNumberOfCreditsForEnrolmentPeriod(DegreeModule degreeModuleToApplyRule, ExecutionSemester begin) {
        this(degreeModuleToApplyRule, begin, null);
    }

    private void checkDegreeModule(DegreeModule degreeModule) {
        if (!degreeModule.isRoot()) {
            throw new DomainException("error.curricularRules.MaximumNumberOfCreditsForEnrolmentPeriod.should.be.applied.to.root.degreeModule", new String[0]);
        }
    }

    protected void checkParameters(DegreeModule degreeModuleToApplyRule, ExecutionSemester begin) {
        if (degreeModuleToApplyRule == null || begin == null) {
            throw new DomainException("curricular.rule.invalid.parameters", new String[0]);
        }
    }

    public boolean isVisible() {
        return false;
    }

    protected void removeOwnParameters() {
    }

    public List<GenericPair<Object, Boolean>> getLabel() {
        ArrayList<GenericPair<Object, Boolean>> result = new ArrayList<GenericPair<Object, Boolean>>(3);
        result.add(new GenericPair<String, Boolean>("label.maximumNumberOfCreditsForEnrolmentPeriod", true));
        result.add(new GenericPair<String, Boolean>(": ", false));
        result.add(new GenericPair<Double, Boolean>(40.5, false));
        return result;
    }

    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return VerifyRuleExecutor.NULL_VERIFY_EXECUTOR;
    }

    public static Double getAccumulatedEcts(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return curricularCourse.getEctsCredits(executionSemester.getSemester(), executionSemester) * 1.0;
    }

    public static double getMaximumNumberOfCredits(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        Registration registration = studentCurricularPlan.getRegistration();
        return registration.isPartialRegime(executionYear) ? 20.25 : 40.5;
    }
}

