/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess;

import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyExternalPersonDetails_Base;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyPersonalDetails;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.person.PersonBean;
import org.joda.time.YearMonthDay;

public class IndividualCandidacyExternalPersonDetails
extends IndividualCandidacyExternalPersonDetails_Base {
    public IndividualCandidacyExternalPersonDetails(IndividualCandidacy candidacy, IndividualCandidacyProcessBean bean) {
        this.setCandidacy(candidacy);
        this.setInternalized(Boolean.FALSE);
        PersonBean personBean = bean.getPersonBean();
        this.edit(personBean);
    }

    public boolean isInternal() {
        return false;
    }

    public void edit(PersonBean personBean) {
        this.setNationality(personBean.getNationality());
        this.setDateOfBirthYearMonthDay(personBean.getDateOfBirth());
        this.setDocumentIdNumber(personBean.getDocumentIdNumber());
        this.setExpirationDateOfDocumentIdYearMonthDay(personBean.getDocumentIdExpirationDate());
        this.setGender(personBean.getGender());
        this.setIdDocumentType(personBean.getIdDocumentType());
        this.setGivenNames(personBean.getGivenNames());
        this.setFamilyNames(personBean.getFamilyNames());
        this.setSocialSecurityNumber(personBean.getSocialSecurityNumber());
        this.setAddress(personBean.getAddress());
        this.setArea(personBean.getArea());
        this.setAreaCode(personBean.getAreaCode());
        this.setTelephoneContact(personBean.getPhone());
        this.setEmail(personBean.getEmail());
        this.setCountryOfResidence(personBean.getCountryOfResidence());
    }

    public void ensurePersonInternalization() {
        if (this.getPerson() == null) {
            Person person = Person.readByDocumentIdNumberAndIdDocumentType(this.getDocumentIdNumber(), this.getIdDocumentType());
            if (person != null) {
                this.setPerson(person);
            } else {
                this.setPerson(new Person((IndividualCandidacyPersonalDetails)((Object)this)));
            }
        }
        this.setInternalized(Boolean.TRUE);
    }

    public Student getStudent() {
        return this.getPerson() != null ? this.getPerson().getStudent() : null;
    }

    public Country getCountry() {
        return this.getNationality();
    }

    public void setCountry(Country country) {
        this.setNationality(country);
    }

    public String getSocialSecurityNumber() {
        return this.getFiscalCode();
    }

    public void setSocialSecurityNumber(String number) {
        this.setFiscalCode(number);
    }

    public PhysicalAddress getDefaultPhysicalAddress() {
        return null;
    }

    public Boolean hasAnyRole() {
        return false;
    }

    public void editPublic(PersonBean personBean) {
        this.edit(personBean);
    }

    public String getEidentifier() {
        return null;
    }

    public String getName() {
        return Stream.of(this.getGivenNames(), this.getFamilyNames()).filter(Objects::nonNull).collect(Collectors.joining(" "));
    }

    @Deprecated
    public Date getDateOfBirth() {
        YearMonthDay ymd = this.getDateOfBirthYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setDateOfBirth(Date date) {
        if (date == null) {
            this.setDateOfBirthYearMonthDay(null);
        } else {
            this.setDateOfBirthYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    @Deprecated
    public Date getEmissionDateOfDocumentId() {
        YearMonthDay ymd = this.getEmissionDateOfDocumentIdYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setEmissionDateOfDocumentId(Date date) {
        if (date == null) {
            this.setEmissionDateOfDocumentIdYearMonthDay(null);
        } else {
            this.setEmissionDateOfDocumentIdYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    @Deprecated
    public Date getExpirationDateOfDocumentId() {
        YearMonthDay ymd = this.getExpirationDateOfDocumentIdYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setExpirationDateOfDocumentId(Date date) {
        if (date == null) {
            this.setExpirationDateOfDocumentIdYearMonthDay(null);
        } else {
            this.setExpirationDateOfDocumentIdYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }
}

