/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy.workflow.form;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.organizationalStructure.AcademicalInstitutionType;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitName;
import org.fenixedu.academic.domain.raides.DegreeDesignation;
import org.fenixedu.academic.domain.util.workflow.Form;
import org.fenixedu.academic.util.LabelFormatter;
import org.joda.time.LocalDate;

public class OriginInformationForm
extends Form {
    private static final long serialVersionUID = 1L;
    private SchoolLevelType schoolLevel;
    private String otherSchoolLevel;
    private String conclusionGrade;
    private String degreeDesignation;
    private Integer conclusionYear;
    private Integer birthYear;
    private Unit institution;
    private String institutionName;
    private DegreeDesignation raidesDegreeDesignation;
    private Country countryWhereFinishedPreviousCompleteDegree;
    private AcademicalInstitutionType highSchoolType;

    private OriginInformationForm() {
        this.setCountryWhereFinishedPreviousCompleteDegree(Country.readDefault());
    }

    public SchoolLevelType getSchoolLevel() {
        return this.schoolLevel;
    }

    public void setSchoolLevel(SchoolLevelType schoolLevel) {
        this.schoolLevel = schoolLevel;
    }

    public String getOtherSchoolLevel() {
        return this.otherSchoolLevel;
    }

    public void setOtherSchoolLevel(String otherSchoolLevel) {
        this.otherSchoolLevel = otherSchoolLevel;
    }

    public String getConclusionGrade() {
        return this.conclusionGrade;
    }

    public void setConclusionGrade(String conclusionGrade) {
        this.conclusionGrade = conclusionGrade;
    }

    public Integer getConclusionYear() {
        return this.conclusionYear;
    }

    public void setConclusionYear(Integer conclusionYear) {
        this.conclusionYear = conclusionYear;
    }

    public Integer getBirthYear() {
        return this.birthYear;
    }

    public void setBirthYear(Integer birthYear) {
        this.birthYear = birthYear;
    }

    public String getDegreeDesignation() {
        if (this.getSchoolLevel() != null) {
            return this.getSchoolLevel().isHigherEducation() && this.getRaidesDegreeDesignation() != null ? this.getRaidesDegreeDesignation().getDescription() : this.degreeDesignation;
        }
        return this.degreeDesignation;
    }

    public void setDegreeDesignation(String degreeDesignation) {
        this.degreeDesignation = degreeDesignation;
    }

    public String getInstitutionName() {
        return this.institutionName;
    }

    public void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    public UnitName getInstitutionUnitName() {
        return this.institution == null ? null : this.institution.getUnitName();
    }

    public void setInstitutionUnitName(UnitName institutionUnitName) {
        this.institution = institutionUnitName == null ? null : institutionUnitName.getUnit();
    }

    public Country getCountryWhereFinishedPreviousCompleteDegree() {
        return this.countryWhereFinishedPreviousCompleteDegree;
    }

    public void setCountryWhereFinishedPreviousCompleteDegree(Country countryWhereFinishedPreviousCompleteDegree) {
        this.countryWhereFinishedPreviousCompleteDegree = countryWhereFinishedPreviousCompleteDegree;
    }

    public Unit getInstitution() {
        return this.institution;
    }

    public void setInstitution(Unit unit) {
        this.institution = unit;
    }

    public AcademicalInstitutionType getHighSchoolType() {
        if (this.getSchoolLevel() != null && this.getSchoolLevel().isHighSchoolOrEquivalent()) {
            return this.highSchoolType;
        }
        return null;
    }

    public void setHighSchoolType(AcademicalInstitutionType highSchoolType) {
        this.highSchoolType = highSchoolType;
    }

    public void setRaidesDegreeDesignation(DegreeDesignation raidesDegreeDesignation) {
        this.raidesDegreeDesignation = raidesDegreeDesignation;
    }

    public DegreeDesignation getRaidesDegreeDesignation() {
        return this.raidesDegreeDesignation;
    }

    private static String roundUpGrade(String grade) {
        return String.valueOf(Math.round(Float.valueOf(grade).floatValue()));
    }

    @Override
    public List<LabelFormatter> validate() {
        if (this.schoolLevel == SchoolLevelType.OTHER && StringUtils.isEmpty((String)this.otherSchoolLevel)) {
            return Collections.singletonList(new LabelFormatter().appendLabel("error.candidacy.workflow.OriginInformationForm.otherSchoolLevel.must.be.filled", "resources.CandidateResources"));
        }
        LocalDate now = new LocalDate();
        if (now.getYear() < this.conclusionYear) {
            return Collections.singletonList(new LabelFormatter().appendLabel("error.personalInformation.year.after.current", "resources.CandidateResources"));
        }
        if (this.conclusionYear < this.getBirthYear()) {
            return Collections.singletonList(new LabelFormatter().appendLabel("error.personalInformation.year.before.birthday", "resources.CandidateResources"));
        }
        return Collections.emptyList();
    }

    @Override
    public String getSchemaName() {
        if (this.getSchoolLevel() != null) {
            if (this.getInstitution() != null) {
                if (this.getSchoolLevel().isHigherEducation() && StringUtils.isEmpty((String)this.getInstitution().getCode())) {
                    this.setInstitution(null);
                    this.setInstitutionName(null);
                    this.setInstitutionUnitName(null);
                    this.setRaidesDegreeDesignation(null);
                }
                if (this.getSchoolLevel().isHighSchoolOrEquivalent() && !StringUtils.isEmpty((String)this.getInstitution().getCode())) {
                    this.setInstitution(null);
                    this.setInstitutionName(null);
                    this.setInstitutionUnitName(null);
                    this.setRaidesDegreeDesignation(null);
                }
            } else {
                this.setInstitution(null);
                this.setInstitutionName(null);
                this.setInstitutionUnitName(null);
            }
            if (this.getSchoolLevel().isHigherEducation() && this.getInstitution() != null) {
                return super.getSchemaName() + ".higherEducation";
            }
            if (this.getSchoolLevel().isHigherEducation() && this.getInstitution() == null) {
                return super.getSchemaName() + ".higherEducationNoInstitution";
            }
            if (this.getSchoolLevel().isHighSchoolOrEquivalent()) {
                return super.getSchemaName() + ".highSchoolOrEquivalent";
            }
        }
        return super.getSchemaName();
    }

    @Override
    public String getFormName() {
        return "label.candidacy.workflow.originInformationForm";
    }

    public static OriginInformationForm createFrom(StudentCandidacy studentCandidacy) {
        OriginInformationForm form = new OriginInformationForm();
        form.setBirthYear(studentCandidacy.getPerson().getDateOfBirthYearMonthDay().getYear());
        form.setHighSchoolType(studentCandidacy.getHighSchoolType());
        if (studentCandidacy.getPrecedentDegreeInformation() != null) {
            form.setConclusionGrade(OriginInformationForm.roundUpGrade(studentCandidacy.getPrecedentDegreeInformation().getConclusionGrade()));
            form.setDegreeDesignation(studentCandidacy.getPrecedentDegreeInformation().getDegreeDesignation());
            form.setInstitution(studentCandidacy.getPrecedentDegreeInformation().getInstitution());
        }
        return form;
    }
}

