/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.EntryPhase;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.candidacy.AdmittedCandidacySituation;
import org.fenixedu.academic.domain.candidacy.Candidacy;
import org.fenixedu.academic.domain.candidacy.CandidacyOperationType;
import org.fenixedu.academic.domain.candidacy.CandidacySituation;
import org.fenixedu.academic.domain.candidacy.IMDCandidacy_Base;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacy.RegisteredCandidacySituation;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.candidacy.workflow.FillPersonalDataOperation;
import org.fenixedu.academic.domain.candidacy.workflow.PrintAllDocumentsOperation;
import org.fenixedu.academic.domain.candidacy.workflow.PrintRegistrationDeclarationOperation;
import org.fenixedu.academic.domain.candidacy.workflow.PrintScheduleOperation;
import org.fenixedu.academic.domain.candidacy.workflow.PrintSystemAccessDataOperation;
import org.fenixedu.academic.domain.candidacy.workflow.RegistrationOperation;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.util.workflow.Operation;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class IMDCandidacy
extends IMDCandidacy_Base {
    public IMDCandidacy(Person person, ExecutionDegree executionDegree) {
        this.init(person, executionDegree);
    }

    public IMDCandidacy(Person person, ExecutionDegree executionDegree, Person creator, Double entryGrade, String contigent, IngressionType ingressionType, EntryPhase entryPhase) {
        this(person, executionDegree, creator, entryGrade, contigent, ingressionType, entryPhase, null);
    }

    public IMDCandidacy(Person person, ExecutionDegree executionDegree, Person creator, Double entryGrade, String contigent, IngressionType ingressionType, EntryPhase entryPhase, Integer placingOption) {
        this.init(person, executionDegree, creator, entryGrade, contigent, ingressionType, entryPhase, placingOption);
    }

    public String getDescription() {
        return BundleUtil.getString((String)"resources.CandidateResources", (String)"label.imdCandidacy", (String[])new String[0]) + " - " + this.getExecutionDegree().getDegreeCurricularPlan().getName() + " - " + this.getExecutionDegree().getExecutionYear().getYear();
    }

    public Set<Operation> getOperations(CandidacySituation candidacySituation) {
        HashSet<Operation> operations = new HashSet<Operation>();
        switch (candidacySituation.getCandidacySituationType()) {
            case STAND_BY: {
                operations.add(new FillPersonalDataOperation(Collections.singleton(RoleType.CANDIDATE), (StudentCandidacy)((Object)this)));
                break;
            }
            case ADMITTED: {
                operations.add(new RegistrationOperation(Collections.singleton(RoleType.CANDIDATE), (Candidacy)((Object)this)));
                break;
            }
            case REGISTERED: {
                operations.add(new PrintScheduleOperation(Collections.singleton(RoleType.STUDENT), (Candidacy)((Object)this)));
                operations.add(new PrintRegistrationDeclarationOperation(Collections.singleton(RoleType.STUDENT), (Candidacy)((Object)this)));
                operations.add(new PrintSystemAccessDataOperation(Collections.singleton(RoleType.STUDENT), (Candidacy)((Object)this)));
                operations.add(new PrintAllDocumentsOperation(RoleType.STUDENT, (Candidacy)((Object)this)));
            }
        }
        return operations;
    }

    protected void moveToNextState(CandidacyOperationType operationType, Person person) {
        switch (this.getActiveCandidacySituation().getCandidacySituationType()) {
            case STAND_BY: {
                if (operationType != CandidacyOperationType.FILL_PERSONAL_DATA) break;
                new AdmittedCandidacySituation((Candidacy)((Object)this), person);
                break;
            }
            case ADMITTED: {
                if (operationType != CandidacyOperationType.REGISTRATION) break;
                new RegisteredCandidacySituation((Candidacy)((Object)this), person);
            }
        }
    }

    public String getDefaultState() {
        return null;
    }

    public Map<String, Set<String>> getStateMapping() {
        return null;
    }
}

