/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.serviceRequests;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.PhotocopyRequestEvent;
import org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.PhotocopyRequestPR_Base;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class PhotocopyRequestPR
extends PhotocopyRequestPR_Base {
    protected PhotocopyRequestPR() {
    }

    public PhotocopyRequestPR(ServiceAgreementTemplate serviceAgreementTemplate, DateTime startDate, DateTime endDate, Money baseAmount, Money amountPerPage) {
        this();
        super.init(EntryType.PHOTOCOPY_REQUEST_FEE, EventType.PHOTOCOPY_REQUEST, startDate, endDate, serviceAgreementTemplate, baseAmount, amountPerPage);
    }

    public PhotocopyRequestPR edit(Money baseAmount, Money amountPerUnit) {
        this.deactivate();
        return new PhotocopyRequestPR(this.getServiceAgreementTemplate(), new DateTime().minus(1000L), null, baseAmount, amountPerUnit);
    }

    protected Money getAmountForPages(Event event) {
        PhotocopyRequestEvent requestEvent = (PhotocopyRequestEvent)((Object)event);
        int extraPages = requestEvent.getNumberOfPages() - 1;
        return this.getAmountPerPage().multiply(BigDecimal.valueOf(extraPages < 0 ? 0L : (long)extraPages));
    }

    protected boolean isUrgent(Event event) {
        return ((PhotocopyRequestEvent)((Object)event)).isUrgentRequest();
    }
}

