/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.paymentPlanRules;

import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.paymentPlanRules.PaymentPlanRule;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;

public class FirstTimeInstitutionStudentsPaymentPlanRule
implements PaymentPlanRule {
    FirstTimeInstitutionStudentsPaymentPlanRule() {
    }

    @Override
    public boolean isEvaluatedInNotSpecificPaymentRules() {
        return true;
    }

    @Override
    public boolean isAppliableFor(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        if (studentCurricularPlan.getRegistration().getStartExecutionYear() != executionYear) {
            return false;
        }
        Student student = studentCurricularPlan.getRegistration().getStudent();
        return this.hasOnlyOneValidRegistration(student, studentCurricularPlan.getRegistration());
    }

    private boolean hasOnlyOneValidRegistration(Student student, Registration current) {
        if (student.getRegistrationsSet().size() > 1) {
            for (Registration registration : student.getRegistrationsSet()) {
                if (registration == current || registration.getActiveStateType() == RegistrationStateType.CANCELED) continue;
                return false;
            }
        }
        return true;
    }
}

