/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.paymentCodes;

import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.Installment;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.paymentCodes.InstallmentPaymentCode_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.YearMonthDay;

@Deprecated
public class InstallmentPaymentCode
extends InstallmentPaymentCode_Base {
    private InstallmentPaymentCode() {
    }

    private InstallmentPaymentCode(PaymentCodeType paymentCodeType, YearMonthDay startDate, YearMonthDay endDate, Event event, Installment installment, Money minAmount, Money maxAmount, Student student) {
        this();
        this.init(paymentCodeType, startDate, endDate, event, installment, minAmount, maxAmount, student);
    }

    public static InstallmentPaymentCode create(PaymentCodeType paymentCodeType, YearMonthDay startDate, YearMonthDay endDate, Event event, Installment installment, Money minAmount, Money maxAmount, Student student) {
        return PaymentCode.canGenerateNewCode(InstallmentPaymentCode.class, paymentCodeType, student.getPerson()) ? new InstallmentPaymentCode(paymentCodeType, startDate, endDate, event, installment, minAmount, maxAmount, student) : InstallmentPaymentCode.findAndReuseExistingCode(paymentCodeType, startDate, endDate, event, minAmount, maxAmount, student, installment);
    }

    protected static InstallmentPaymentCode findAndReuseExistingCode(PaymentCodeType paymentCodeType, YearMonthDay startDate, YearMonthDay endDate, Event event, Money minAmount, Money maxAmount, Student student, Installment installment) {
        for (PaymentCode code : student.getPerson().getPaymentCodesBy(paymentCodeType)) {
            if (!code.isAvailableForReuse() || !InstallmentPaymentCode.getPaymentCodeGenerator((PaymentCodeType)paymentCodeType).isCodeMadeByThisFactory(code)) continue;
            InstallmentPaymentCode accountingEventPaymentCode = (InstallmentPaymentCode)((Object)code);
            accountingEventPaymentCode.reuse(startDate, endDate, minAmount, maxAmount, event);
            return accountingEventPaymentCode;
        }
        return null;
    }

    public void reuse(YearMonthDay startDate, YearMonthDay endDate, Money minAmount, Money maxAmount, Event event, Installment installment) {
        super.reuse(startDate, endDate, minAmount, maxAmount, event);
        super.setInstallment(installment);
    }

    protected void init(PaymentCodeType paymentCodeType, YearMonthDay startDate, YearMonthDay endDate, Event event, Installment installment, Money minAmount, Money maxAmount, Student student) {
        super.init(paymentCodeType, startDate, endDate, event, minAmount, maxAmount, student.getPerson());
        this.checkParameters(installment, student);
        super.setInstallment(installment);
    }

    private void checkParameters(Installment installment, Student student) {
        if (installment == null) {
            throw new DomainException("error.accounting.paymentCodes.InstallmentPaymentCode.installment.cannot.be.null", new String[0]);
        }
        if (student == null) {
            throw new DomainException("error.accounting.paymentCodes.InstallmentPaymentCode.student.cannot.be.null", new String[0]);
        }
    }

    public void setInstallment(Installment installment) {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        super.setInstallment(installment);
    }

    public void delete() {
        super.setInstallment(null);
        super.delete();
    }

    public String getDescription() {
        if (this.getInstallment().getPaymentPlan().hasSingleInstallment()) {
            return BundleUtil.getString((String)"resources.EnumerationResources", (String)PaymentCodeType.TOTAL_GRATUITY.getQualifiedName(), (String[])new String[0]);
        }
        return super.getDescription();
    }

    public boolean isInstallmentPaymentCode() {
        return true;
    }
}

