/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.serviceRequests;

import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.PartialRegistrationRegimeRequestEvent_Base;
import org.fenixedu.academic.domain.accounting.postingRules.PartialRegistrationRegimeRequestPR;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.serviceRequests.PartialRegistrationRegimeRequest;
import org.fenixedu.academic.domain.serviceRequests.RegistrationAcademicServiceRequest;
import org.fenixedu.academic.util.LabelFormatter;

public class PartialRegistrationRegimeRequestEvent
extends PartialRegistrationRegimeRequestEvent_Base {
    private PartialRegistrationRegimeRequestEvent() {
    }

    public PartialRegistrationRegimeRequestEvent(AdministrativeOffice administrativeOffice, Person person, PartialRegistrationRegimeRequest request) {
        this();
        super.init(administrativeOffice, EventType.PARTIAL_REGISTRATION_REGIME_REQUEST, person, (RegistrationAcademicServiceRequest)((Object)request));
    }

    public PartialRegistrationRegimeRequest getAcademicServiceRequest() {
        return (PartialRegistrationRegimeRequest)((Object)super.getAcademicServiceRequest());
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources");
        if (this.getAcademicServiceRequest().getExecutionYear() != null) {
            labelFormatter.appendLabel(" - " + this.getExecutionYear().getYear());
        }
        return labelFormatter;
    }

    public PostingRule getPostingRule() {
        Set activePostingRules = this.getAdministrativeOffice().getServiceAgreementTemplate().getActivePostingRules(this.getExecutionYear().getBeginDateYearMonthDay().toDateTimeAtMidnight());
        return (PostingRule)((Object)CollectionUtils.find((Collection)activePostingRules, (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((PostingRule)((Object)arg0)).getEventType().equals((Object)PartialRegistrationRegimeRequestEvent.this.getEventType()) && ((PartialRegistrationRegimeRequestPR)((Object)arg0)).getExecutionYear().equals(PartialRegistrationRegimeRequestEvent.this.getAcademicServiceRequest().getExecutionYear());
            }
        }));
    }
}

