/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.accessControl.FenixGroup;
import org.fenixedu.academic.domain.accessControl.PersistentTeacherResponsibleOfExecutionCourseGroup;
import org.fenixedu.bennu.core.annotation.GroupArgument;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.joda.time.DateTime;

@GroupOperator(value="teacherResponsibleOfExecutionCourse")
public class TeacherResponsibleOfExecutionCourseGroup
extends FenixGroup {
    private static final long serialVersionUID = -8474941837282629610L;
    @GroupArgument
    private ExecutionCourse executionCourse;

    private TeacherResponsibleOfExecutionCourseGroup() {
    }

    private TeacherResponsibleOfExecutionCourseGroup(ExecutionCourse executionCourse) {
        this();
        this.executionCourse = executionCourse;
    }

    public static TeacherResponsibleOfExecutionCourseGroup get(ExecutionCourse executionCourse) {
        return new TeacherResponsibleOfExecutionCourseGroup(executionCourse);
    }

    @Override
    public String[] getPresentationNameKeyArgs() {
        return new String[]{this.executionCourse.getName() + " (" + this.executionCourse.getSigla() + ") " + this.executionCourse.getAcademicInterval().getPathName()};
    }

    public Set<User> getMembers() {
        HashSet<User> users = new HashSet<User>();
        for (Professorship professorship : this.executionCourse.responsibleFors()) {
            users.add(professorship.getPerson().getUser());
        }
        return users;
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user) {
        if (user == null) {
            return false;
        }
        return !Sets.intersection((Set)user.getPerson().getProfessorshipsSet(), new HashSet<Professorship>(this.executionCourse.responsibleFors())).isEmpty();
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentTeacherResponsibleOfExecutionCourseGroup.getInstance(this.executionCourse);
    }

    public boolean equals(Object object) {
        if (object instanceof TeacherResponsibleOfExecutionCourseGroup) {
            return Objects.equal((Object)((Object)this.executionCourse), (Object)((Object)((TeacherResponsibleOfExecutionCourseGroup)((Object)object)).executionCourse));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.executionCourse});
    }
}

