/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.accessControl.AcademicAuthorizationGroup;
import org.fenixedu.academic.domain.accessControl.PersistentAcademicOperationGroup_Base;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.bennu.core.groups.Group;

public class PersistentAcademicOperationGroup
extends PersistentAcademicOperationGroup_Base {
    protected PersistentAcademicOperationGroup(AcademicOperationType operation, Set<AcademicProgram> programs, Set<AdministrativeOffice> offices, AcademicOperationType.Scope scope) {
        this.setOperation(operation);
        if (programs != null) {
            this.getProgramSet().addAll(programs);
        }
        if (offices != null) {
            this.getOfficeSet().addAll(offices);
        }
        this.setScope(scope);
    }

    public Group toGroup() {
        return AcademicAuthorizationGroup.get(this.getOperation(), this.getProgramSet(), this.getOfficeSet(), this.getScope());
    }

    protected void gc() {
        this.getProgramSet().clear();
        this.getOfficeSet().clear();
        super.gc();
    }

    public static PersistentAcademicOperationGroup getInstance(AcademicOperationType operation, AcademicOperationType.Scope scope) {
        return PersistentAcademicOperationGroup.getInstance(operation, null, null, scope);
    }

    public static PersistentAcademicOperationGroup getInstance(AcademicOperationType operation, Set<AcademicProgram> programs, Set<AdministrativeOffice> offices, AcademicOperationType.Scope scope) {
        return (PersistentAcademicOperationGroup)PersistentAcademicOperationGroup.singleton(() -> PersistentAcademicOperationGroup.select(operation, programs, offices, scope), () -> new PersistentAcademicOperationGroup(operation, programs, offices, scope));
    }

    private static Optional<PersistentAcademicOperationGroup> select(AcademicOperationType operation, Set<AcademicProgram> programs, Set<AdministrativeOffice> offices, AcademicOperationType.Scope scope) {
        return PersistentAcademicOperationGroup.filter(PersistentAcademicOperationGroup.class).filter(group -> Objects.equals(group.getOperation(), operation) && PersistentAcademicOperationGroup.collectionEquals(group.getProgramSet(), programs) && PersistentAcademicOperationGroup.collectionEquals(group.getOfficeSet(), offices) && Objects.equals((Object)group.getScope(), (Object)scope)).findAny();
    }

    private static boolean collectionEquals(Set<?> one, Set<?> another) {
        if (one == null) {
            one = Collections.emptySet();
        }
        if (another == null) {
            another = Collections.emptySet();
        }
        return Sets.symmetricDifference(one, another).isEmpty();
    }
}

