/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.GroupStrategy;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

@GroupOperator(value="allCoordinators")
public class AllCoordinatorsGroup
extends GroupStrategy {
    private static final long serialVersionUID = 8879256369998150156L;

    public String getPresentationName() {
        return BundleUtil.getString((String)"resources.GroupNameResources", (String)"label.name.AllCoordinatorsGroup", (String[])new String[0]);
    }

    public Set<User> getMembers() {
        return Stream.concat(Bennu.getInstance().getCoordinatorsSet().stream().map(coordinator -> coordinator.getPerson().getUser()), Bennu.getInstance().getScientificCommissionsSet().stream().map(commission -> commission.getPerson().getUser())).collect(Collectors.toSet());
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user) {
        return user != null && user.getPerson() != null && (!user.getPerson().getCoordinatorsSet().isEmpty() || !user.getPerson().getScientificCommissionsSet().isEmpty());
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }
}

