/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Set;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.accessControl.FenixGroup;
import org.fenixedu.academic.domain.accessControl.PersistentAcademicOperationGroup;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.bennu.core.annotation.GroupArgument;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.joda.time.DateTime;

@GroupOperator(value="academic")
public class AcademicAuthorizationGroup
extends FenixGroup {
    private static final long serialVersionUID = -3178215706386635516L;
    @GroupArgument(value="")
    private AcademicOperationType operation;
    @GroupArgument
    private Set<AcademicProgram> programs;
    @GroupArgument
    private Set<AdministrativeOffice> offices;
    @GroupArgument
    private AcademicOperationType.Scope scope;

    private AcademicAuthorizationGroup() {
    }

    private AcademicAuthorizationGroup(AcademicOperationType operation, Set<AcademicProgram> programs, Set<AdministrativeOffice> offices, AcademicOperationType.Scope scope) {
        this();
        this.operation = operation;
        this.programs = programs;
        this.offices = offices;
        this.scope = scope;
    }

    public static AcademicAuthorizationGroup get() {
        return new AcademicAuthorizationGroup(null, null, null, null);
    }

    public static AcademicAuthorizationGroup get(AcademicOperationType.Scope scope) {
        return new AcademicAuthorizationGroup(null, null, null, scope);
    }

    public static AcademicAuthorizationGroup get(AcademicOperationType operation) {
        return new AcademicAuthorizationGroup(operation, null, null, null);
    }

    public static AcademicAuthorizationGroup get(AcademicOperationType operation, AcademicProgram program) {
        return new AcademicAuthorizationGroup(operation, Collections.singleton(program), null, null);
    }

    public static AcademicAuthorizationGroup get(AcademicOperationType operation, Set<AcademicProgram> programs, Set<AdministrativeOffice> offices, AcademicOperationType.Scope scope) {
        return new AcademicAuthorizationGroup(operation, programs, offices, scope);
    }

    @Override
    public String[] getPresentationNameKeyArgs() {
        return new String[]{this.operation.getLocalizedName()};
    }

    public Set<User> getMembers() {
        if (this.scope != null) {
            return AcademicAccessRule.getMembers(r -> this.scope.contains(r.getOperation()));
        }
        return AcademicAccessRule.getMembers(this.operation, this.programs, this.offices);
    }

    public Set<User> getMembers(DateTime when) {
        if (this.scope != null) {
            return AcademicAccessRule.getMembers(r -> this.scope.contains(r.getOperation()), when);
        }
        return AcademicAccessRule.getMembers(this.operation, this.programs, this.offices, when);
    }

    public boolean isMember(User user) {
        if (this.scope != null) {
            return AcademicAccessRule.isMember(user, r -> this.scope.contains(r.getOperation()));
        }
        return AcademicAccessRule.isMember(user, this.operation, this.programs, this.offices);
    }

    public boolean isMember(User user, DateTime when) {
        if (this.scope != null) {
            return AcademicAccessRule.isMember(user, r -> this.scope.contains(r.getOperation()), when);
        }
        return AcademicAccessRule.isMember(user, this.operation, this.programs, this.offices, when);
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentAcademicOperationGroup.getInstance(this.operation, this.programs, this.offices, this.scope);
    }

    public boolean equals(Object object) {
        if (object instanceof AcademicAuthorizationGroup) {
            AcademicAuthorizationGroup other = (AcademicAuthorizationGroup)((Object)object);
            return Objects.equal((Object)this.operation, (Object)other.operation) && Objects.equal(this.programs, other.programs) && Objects.equal(this.offices, other.offices) && Objects.equal((Object)((Object)this.scope), (Object)((Object)other.scope));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.operation, this.programs, this.offices, this.scope});
    }
}

