/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import jvstm.cps.ConsistencyPredicate;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CourseLoad;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.academic.domain.GroupsAndShiftsManagementLog;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.Shift$callable$removeAttendFromShift;
import org.fenixedu.academic.domain.ShiftEnrolment;
import org.fenixedu.academic.domain.ShiftProfessorship;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.Shift_Base;
import org.fenixedu.academic.domain.StudentGroup;
import org.fenixedu.academic.domain.Summary;
import org.fenixedu.academic.domain.candidacy.degree.ShiftDistributionEntry;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.util.email.ExecutionCourseSender;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.ReplyTo;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.ResourceAllocationRolePredicates;
import org.fenixedu.academic.util.DiaSemana;
import org.fenixedu.academic.util.WeekDay;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.UserGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class Shift
extends Shift_Base {
    public static final Comparator<Shift> SHIFT_COMPARATOR_BY_NAME;
    public static final Comparator<Shift> SHIFT_COMPARATOR_BY_TYPE_AND_ORDERED_LESSONS;
    public static final Advice advice$removeAttendFromShift;

    public Shift(ExecutionCourse executionCourse, Collection<ShiftType> types, Integer lotacao) {
        this.setRootDomainObject(Bennu.getInstance());
        this.shiftTypeManagement(types, executionCourse);
        this.setLotacao(lotacao);
        executionCourse.setShiftNames();
        if (this.getCourseLoadsSet().isEmpty()) {
            throw new DomainException("error.Shift.empty.courseLoads", new String[0]);
        }
    }

    public void edit(List<ShiftType> newTypes, Integer newCapacity, ExecutionCourse newExecutionCourse, String newName, String comment) {
        AccessControl.check(this, ResourceAllocationRolePredicates.checkPermissionsToManageShifts);
        ExecutionCourse beforeExecutionCourse = this.getExecutionCourse();
        Shift otherShiftWithSameNewName = newExecutionCourse.findShiftByName(newName);
        if (otherShiftWithSameNewName != null && otherShiftWithSameNewName != this) {
            throw new DomainException("error.Shift.with.this.name.already.exists", new String[0]);
        }
        if (newCapacity != null && this.getStudentsSet().size() > newCapacity) {
            throw new DomainException("errors.exception.invalid.finalAvailability", new String[0]);
        }
        this.setLotacao(newCapacity);
        this.shiftTypeManagement(newTypes, newExecutionCourse);
        beforeExecutionCourse.setShiftNames();
        if (!beforeExecutionCourse.equals((Object)newExecutionCourse)) {
            newExecutionCourse.setShiftNames();
        }
        if (this.getCourseLoadsSet().isEmpty()) {
            throw new DomainException("error.Shift.empty.courseLoads", new String[0]);
        }
        this.setComment(comment);
    }

    public Set<StudentGroup> getAssociatedStudentGroupsSet() {
        HashSet<StudentGroup> result = new HashSet<StudentGroup>();
        for (StudentGroup sg : super.getAssociatedStudentGroupsSet()) {
            if (!sg.getValid().booleanValue()) continue;
            result.add(sg);
        }
        return Collections.unmodifiableSet(result);
    }

    public void delete() {
        AccessControl.check(this, ResourceAllocationRolePredicates.checkPermissionsToManageShifts);
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        ExecutionCourse executionCourse = this.getExecutionCourse();
        while (!this.getAssociatedLessonsSet().isEmpty()) {
            ((Lesson)((Object)this.getAssociatedLessonsSet().iterator().next())).delete();
        }
        while (!this.getAssociatedShiftProfessorshipSet().isEmpty()) {
            ((ShiftProfessorship)((Object)this.getAssociatedShiftProfessorshipSet().iterator().next())).delete();
        }
        while (!this.getShiftDistributionEntriesSet().isEmpty()) {
            ((ShiftDistributionEntry)((Object)this.getShiftDistributionEntriesSet().iterator().next())).delete();
        }
        this.getAssociatedClassesSet().clear();
        this.getCourseLoadsSet().clear();
        if (this.getShiftGroupingProperties() != null) {
            this.getShiftGroupingProperties().delete();
        }
        this.setRootDomainObject(null);
        super.deleteDomainObject();
        executionCourse.setShiftNames();
    }

    @ConsistencyPredicate
    protected boolean checkRequiredParameters() {
        return this.getLotacao() != null && !StringUtils.isEmpty((String)this.getNome());
    }

    @Deprecated
    public ExecutionCourse getDisciplinaExecucao() {
        return this.getExecutionCourse();
    }

    public ExecutionCourse getExecutionCourse() {
        CourseLoad courseLoad = (CourseLoad)((Object)this.getCourseLoadsSet().iterator().next());
        if (courseLoad != null) {
            return courseLoad.getExecutionCourse();
        }
        return null;
    }

    public ExecutionSemester getExecutionPeriod() {
        return this.getExecutionCourse().getExecutionPeriod();
    }

    private void shiftTypeManagement(Collection<ShiftType> types, ExecutionCourse executionCourse) {
        if (executionCourse != null) {
            this.getCourseLoadsSet().clear();
            for (ShiftType shiftType : types) {
                CourseLoad courseLoad = executionCourse.getCourseLoadByShiftType(shiftType);
                if (courseLoad == null) continue;
                this.addCourseLoads(courseLoad);
            }
        }
    }

    public List<ShiftType> getTypes() {
        ArrayList<ShiftType> result = new ArrayList<ShiftType>();
        for (CourseLoad courseLoad : this.getCourseLoadsSet()) {
            result.add(courseLoad.getType());
        }
        return result;
    }

    public SortedSet<ShiftType> getSortedTypes() {
        TreeSet<ShiftType> result = new TreeSet<ShiftType>();
        for (CourseLoad courseLoad : this.getCourseLoadsSet()) {
            result.add(courseLoad.getType());
        }
        return result;
    }

    public boolean containsType(ShiftType shiftType) {
        if (shiftType != null) {
            for (CourseLoad courseLoad : this.getCourseLoadsSet()) {
                if (!courseLoad.getType().equals((Object)shiftType)) continue;
                return true;
            }
        }
        return false;
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getAssociatedStudentGroupsSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ResourceAllocationManagerResources", (String)"error.deleteShift.with.studentGroups", (String[])new String[]{this.getNome()}));
        }
        if (!this.getStudentsSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ResourceAllocationManagerResources", (String)"error.deleteShift.with.students", (String[])new String[]{this.getNome()}));
        }
        if (!this.getAssociatedSummariesSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ResourceAllocationManagerResources", (String)"error.deleteShift.with.summaries", (String[])new String[]{this.getNome()}));
        }
    }

    public BigDecimal getTotalHours() {
        Set lessons = this.getAssociatedLessonsSet();
        BigDecimal lessonTotalHours = BigDecimal.ZERO;
        for (Lesson lesson : lessons) {
            lessonTotalHours = lessonTotalHours.add(lesson.getTotalHours());
        }
        return lessonTotalHours;
    }

    public Duration getTotalDuration() {
        Duration duration = Duration.ZERO;
        Set lessons = this.getAssociatedLessonsSet();
        for (Lesson lesson : lessons) {
            duration = duration.plus((ReadableDuration)lesson.getTotalDuration());
        }
        return duration;
    }

    public BigDecimal getMaxLessonDuration() {
        BigDecimal maxHours = BigDecimal.ZERO;
        for (Lesson lesson : this.getAssociatedLessonsSet()) {
            BigDecimal lessonHours = lesson.getUnitHours();
            if (maxHours.compareTo(lessonHours) != -1) continue;
            maxHours = lessonHours;
        }
        return maxHours;
    }

    public BigDecimal getUnitHours() {
        BigDecimal hours = BigDecimal.ZERO;
        Set lessons = this.getAssociatedLessonsSet();
        for (Lesson lesson : lessons) {
            hours = hours.add(lesson.getUnitHours());
        }
        return hours;
    }

    public double getHoursOnSaturdaysOrNightHours(int nightHour) {
        double hours = 0.0;
        Set lessons = this.getAssociatedLessonsSet();
        for (Lesson lesson : lessons) {
            if (lesson.getDiaSemana().equals(new DiaSemana(7))) {
                hours += lesson.getUnitHours().doubleValue();
                continue;
            }
            hours += lesson.hoursAfter(nightHour);
        }
        return hours;
    }

    public int getNumberOfLessonInstances() {
        Set lessons = this.getAssociatedLessonsSet();
        int totalLessonsDates = 0;
        for (Lesson lesson : lessons) {
            totalLessonsDates += lesson.getFinalNumberOfLessonInstances();
        }
        return totalLessonsDates;
    }

    public BigDecimal getCourseLoadWeeklyAverage() {
        BigDecimal weeklyHours = BigDecimal.ZERO;
        for (CourseLoad courseLoad : this.getCourseLoadsSet()) {
            weeklyHours = weeklyHours.add(courseLoad.getWeeklyHours());
        }
        return weeklyHours;
    }

    public BigDecimal getCourseLoadTotalHours() {
        BigDecimal weeklyHours = BigDecimal.ZERO;
        for (CourseLoad courseLoad : this.getCourseLoadsSet()) {
            weeklyHours = weeklyHours.add(courseLoad.getTotalQuantity());
        }
        return weeklyHours;
    }

    public void associateSchoolClass(SchoolClass schoolClass) {
        if (schoolClass == null) {
            throw new NullPointerException();
        }
        if (!this.getAssociatedClassesSet().contains((Object)schoolClass)) {
            this.getAssociatedClassesSet().add(schoolClass);
        }
        if (!schoolClass.getAssociatedShiftsSet().contains((Object)this)) {
            schoolClass.getAssociatedShiftsSet().add(this);
        }
    }

    public SortedSet<Lesson> getLessonsOrderedByWeekDayAndStartTime() {
        TreeSet<Lesson> lessons = new TreeSet<Lesson>(Lesson.LESSON_COMPARATOR_BY_WEEKDAY_AND_STARTTIME);
        lessons.addAll(this.getAssociatedLessonsSet());
        return lessons;
    }

    public String getLessonsStringComparator() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Lesson lesson : this.getLessonsOrderedByWeekDayAndStartTime()) {
            stringBuilder.append(lesson.getDiaSemana().getDiaSemana().toString());
            stringBuilder.append(lesson.getBeginHourMinuteSecond().toString());
        }
        return stringBuilder.toString();
    }

    public Integer getShiftTypesIntegerComparator() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ShiftType shiftType : this.getSortedTypes()) {
            stringBuilder.append(shiftType.ordinal() + 1);
        }
        return Integer.valueOf(stringBuilder.toString());
    }

    public boolean reserveForStudent(Registration registration) {
        boolean result;
        boolean bl = result = this.getLotacao() > this.getStudentsSet().size();
        if (result || this.isResourceAllocationManager()) {
            GroupsAndShiftsManagementLog.createLog(this.getExecutionCourse(), "resources.MessagingResources", "log.executionCourse.groupAndShifts.shifts.attends.added", registration.getNumber().toString(), this.getNome(), this.getExecutionCourse().getNome(), this.getExecutionCourse().getDegreePresentationString());
            this.addStudents(registration);
        }
        return result;
    }

    private boolean isResourceAllocationManager() {
        Person person = AccessControl.getPerson();
        return person != null && RoleType.RESOURCE_ALLOCATION_MANAGER.isMember(person.getUser());
    }

    public SortedSet<ShiftEnrolment> getShiftEnrolmentsOrderedByDate() {
        TreeSet<ShiftEnrolment> shiftEnrolments = new TreeSet<ShiftEnrolment>(ShiftEnrolment.COMPARATOR_BY_DATE);
        shiftEnrolments.addAll(this.getShiftEnrolmentsSet());
        return shiftEnrolments;
    }

    public String getClassesPrettyPrint() {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (SchoolClass schoolClass : this.getAssociatedClassesSet()) {
            builder.append(schoolClass.getNome());
            if (++index >= this.getAssociatedClassesSet().size()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public String getShiftTypesPrettyPrint() {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        SortedSet<ShiftType> sortedTypes = this.getSortedTypes();
        for (ShiftType shiftType : sortedTypes) {
            builder.append(BundleUtil.getString((String)"resources.EnumerationResources", (String)shiftType.getName(), (String[])new String[0]));
            if (++index >= sortedTypes.size()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public String getShiftTypesCapitalizedPrettyPrint() {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        SortedSet<ShiftType> sortedTypes = this.getSortedTypes();
        for (ShiftType shiftType : sortedTypes) {
            builder.append(shiftType.getFullNameTipoAula());
            if (++index >= sortedTypes.size()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public String getShiftTypesCodePrettyPrint() {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        SortedSet<ShiftType> sortedTypes = this.getSortedTypes();
        for (ShiftType shiftType : sortedTypes) {
            builder.append(shiftType.getSiglaTipoAula());
            if (++index >= sortedTypes.size()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public List<Summary> getExtraSummaries() {
        ArrayList<Summary> result = new ArrayList<Summary>();
        Set summaries = this.getAssociatedSummariesSet();
        for (Summary summary : summaries) {
            if (!summary.isExtraSummary()) continue;
            result.add(summary);
        }
        return result;
    }

    private boolean hasShiftEnrolment(Registration registration) {
        for (ShiftEnrolment shiftEnrolment : this.getShiftEnrolmentsSet()) {
            if (!shiftEnrolment.hasRegistration(registration)) continue;
            return true;
        }
        return false;
    }

    public void unEnrolStudent(Registration registration) {
        ShiftEnrolment shiftEnrolment = this.findShiftEnrolment(registration);
        if (shiftEnrolment != null) {
            shiftEnrolment.delete();
        }
    }

    private ShiftEnrolment findShiftEnrolment(Registration registration) {
        for (ShiftEnrolment shiftEnrolment : this.getShiftEnrolmentsSet()) {
            if (shiftEnrolment.getRegistration() != registration) continue;
            return shiftEnrolment;
        }
        return null;
    }

    public int getCapacityBasedOnSmallestRoom() {
        int capacity = this.getAssociatedLessonsSet().stream().filter(Lesson::hasSala).mapToInt(lesson -> lesson.getSala().getAllocatableCapacity()).min().orElse(0);
        return capacity + capacity / 10;
    }

    public boolean hasShiftType(ShiftType shiftType) {
        for (CourseLoad courseLoad : this.getCourseLoadsSet()) {
            if (courseLoad.getType() != shiftType) continue;
            return true;
        }
        return false;
    }

    public boolean hasSchoolClassForDegreeType(DegreeType degreeType) {
        for (SchoolClass schoolClass : this.getAssociatedClassesSet()) {
            if (schoolClass.getExecutionDegree().getDegreeType() != degreeType) continue;
            return true;
        }
        return false;
    }

    public void removeAttendFromShift(Registration registration, ExecutionCourse executionCourse) {
        Object object = advice$removeAttendFromShift.perform((Callable)new Shift$callable$removeAttendFromShift(this, registration, executionCourse));
    }

    static /* synthetic */ void advised$removeAttendFromShift(Shift this_, Registration registration, ExecutionCourse executionCourse) {
        GroupsAndShiftsManagementLog.createLog(this_.getExecutionCourse(), "resources.MessagingResources", "log.executionCourse.groupAndShifts.shifts.attends.removed", registration.getNumber().toString(), this_.getNome(), this_.getExecutionCourse().getNome(), this_.getExecutionCourse().getDegreePresentationString());
        registration.removeShifts(this_);
        ExecutionCourseSender sender = ExecutionCourseSender.newInstance(executionCourse);
        List<Recipient> recipients = Collections.singletonList(new Recipient(UserGroup.of((User[])new User[]{registration.getPerson().getUser()})));
        String subject = BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.shift.remove.subject", (String[])new String[0]);
        String body = BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.shift.remove.body", (String[])new String[]{this_.getNome()});
        new Message((Sender)((Object)sender), (Collection<? extends ReplyTo>)sender.getConcreteReplyTos(), recipients, subject, body, "");
    }

    public boolean hasAnyStudentsInAssociatedStudentGroups() {
        for (StudentGroup studentGroup : this.getAssociatedStudentGroupsSet()) {
            if (studentGroup.getAttendsSet().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public String getPresentationName() {
        StringBuilder stringBuilder = new StringBuilder(this.getNome());
        if (!this.getAssociatedLessonsSet().isEmpty()) {
            stringBuilder.append(" ( ");
            Iterator iterator = this.getAssociatedLessonsSet().iterator();
            while (iterator.hasNext()) {
                Lesson lesson = (Lesson)((Object)iterator.next());
                stringBuilder.append(WeekDay.getWeekDay(lesson.getDiaSemana()).getLabelShort());
                stringBuilder.append(" ");
                stringBuilder.append(lesson.getBeginHourMinuteSecond().toString("HH:mm"));
                stringBuilder.append(" - ");
                stringBuilder.append(lesson.getEndHourMinuteSecond().toString("HH:mm"));
                if (lesson.hasSala()) {
                    stringBuilder.append(" - ");
                    stringBuilder.append(lesson.getSala().getName());
                }
                if (!iterator.hasNext()) continue;
                stringBuilder.append(" ; ");
            }
            stringBuilder.append(" ) ");
        }
        return stringBuilder.toString();
    }

    public String getLessonPresentationString() {
        StringBuilder stringBuilder = new StringBuilder(this.getNome());
        if (!this.getAssociatedLessonsSet().isEmpty()) {
            Iterator iterator = this.getAssociatedLessonsSet().iterator();
            while (iterator.hasNext()) {
                Lesson lesson = (Lesson)((Object)iterator.next());
                stringBuilder.append(" ");
                stringBuilder.append(WeekDay.getWeekDay(lesson.getDiaSemana()).getLabelShort());
                stringBuilder.append(" ");
                stringBuilder.append(lesson.getBeginHourMinuteSecond().toString("HH:mm"));
                stringBuilder.append(" - ");
                stringBuilder.append(lesson.getEndHourMinuteSecond().toString("HH:mm"));
                if (lesson.hasSala()) {
                    stringBuilder.append(" - ");
                    stringBuilder.append(lesson.getSala().getName());
                }
                if (!iterator.hasNext()) continue;
                stringBuilder.append(" ; ");
            }
        }
        return stringBuilder.toString();
    }

    public List<StudentGroup> getAssociatedStudentGroups(Grouping grouping) {
        ArrayList<StudentGroup> result = new ArrayList<StudentGroup>();
        for (StudentGroup studentGroup : this.getAssociatedStudentGroupsSet()) {
            if (studentGroup.getGrouping() != grouping) continue;
            result.add(studentGroup);
        }
        return result;
    }

    public boolean isTotalShiftLoadExceeded() {
        BigDecimal totalHours = this.getTotalHours();
        for (CourseLoad courseLoad : this.getCourseLoadsSet()) {
            if (totalHours.compareTo(courseLoad.getTotalQuantity()) != 1) continue;
            return true;
        }
        return false;
    }

    static {
        advice$removeAttendFromShift = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        SHIFT_COMPARATOR_BY_NAME = new Comparator<Shift>(){

            @Override
            public int compare(Shift o1, Shift o2) {
                return Collator.getInstance().compare(o1.getNome(), o2.getNome());
            }
        };
        SHIFT_COMPARATOR_BY_TYPE_AND_ORDERED_LESSONS = new Comparator<Shift>(){

            @Override
            public int compare(Shift o1, Shift o2) {
                int ce = o1.getExecutionCourse().getNome().compareTo(o2.getExecutionCourse().getNome());
                if (ce != 0) {
                    return ce;
                }
                int cs = o1.getShiftTypesIntegerComparator().compareTo(o2.getShiftTypesIntegerComparator());
                if (cs != 0) {
                    return cs;
                }
                int cl = o1.getLessonsStringComparator().compareTo(o2.getLessonsStringComparator());
                return cl == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)o1, (DomainObject)o2) : cl;
            }
        };
        Registration.getRelationShiftStudent().addListener((RelationListener)new ShiftStudentListener());
    }

    private static class ShiftStudentListener
    extends RelationAdapter<Registration, Shift> {
        private ShiftStudentListener() {
        }

        public void afterAdd(Registration registration, Shift shift) {
            if (!shift.hasShiftEnrolment(registration)) {
                new ShiftEnrolment(shift, registration);
            }
        }

        public void afterRemove(Registration registration, Shift shift) {
            shift.unEnrolStudent(registration);
        }
    }
}

