/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.fenixWebFramework.rendererExtensions.util.IPresentableEnum;

public enum SchoolLevelType implements IPresentableEnum
{
    UNKNOWN(false, false, false),
    DONT_KNOW_HOW_TO_READ_OR_WRITE(false, true, false),
    KNOWS_HOW_TO_READ_WITHOUT_OLD_FOURTH_YEAR(false, true, false),
    FIRST_CYCLE_BASIC_SCHOOL(true, true, false){

        @Override
        public boolean isSchoolLevelBasicCycle() {
            return true;
        }
    }
    ,
    SECOND_CYCLE_BASIC_SCHOOL(true, true, false){

        @Override
        public boolean isSchoolLevelBasicCycle() {
            return true;
        }
    }
    ,
    THIRD_CYCLE_BASIC_SCHOOL(true, true, false){

        @Override
        public boolean isSchoolLevelBasicCycle() {
            return true;
        }
    }
    ,
    HIGH_SCHOOL_OR_EQUIVALENT(true, true, false){

        @Override
        public boolean isHighSchoolOrEquivalent() {
            return true;
        }
    }
    ,
    TECHNICAL_SPECIALIZATION(true, true, false){

        @Override
        public boolean isHigherEducation() {
            return true;
        }

        @Override
        public List<String> getEquivalentDegreeClassifications() {
            return Lists.newArrayList((Object[])new String[]{"C", "C0"});
        }
    }
    ,
    MEDIUM_EDUCATION(false, true, false),
    BACHELOR_DEGREE(true, true, true){

        @Override
        public boolean isHigherEducation() {
            return true;
        }

        @Override
        public List<String> getEquivalentDegreeClassifications() {
            return Lists.newArrayList((Object[])new String[]{"A", "B", "BC", "DB", "EB", "MD"});
        }
    }
    ,
    BACHELOR_DEGREE_PRE_BOLOGNA(true, true, true){

        @Override
        public boolean isHigherEducation() {
            return true;
        }

        @Override
        public List<String> getEquivalentDegreeClassifications() {
            return Lists.newArrayList((Object[])new String[]{"BL", "LB", "PB"});
        }
    }
    ,
    DEGREE(true, true, false){

        @Override
        public boolean isHigherEducation() {
            return true;
        }

        @Override
        public List<String> getEquivalentDegreeClassifications() {
            return Lists.newArrayList((Object[])new String[]{"L1", "PM", "LI"});
        }
    }
    ,
    DEGREE_PRE_BOLOGNA(true, true, false){

        @Override
        public boolean isHigherEducation() {
            return true;
        }

        @Override
        public List<String> getEquivalentDegreeClassifications() {
            return Lists.newArrayList((Object[])new String[]{"DD", "DL", "EL", "L", "LT", "P"});
        }
    }
    ,
    DEGREE_TERMINAL_PART(true, true, false){

        @Override
        public boolean isHigherEducation() {
            return true;
        }

        @Override
        public List<String> getEquivalentDegreeClassifications() {
            return Lists.newArrayList((Object[])new String[]{"LT"});
        }
    }
    ,
    MASTER_DEGREE(true, true, true){

        @Override
        public boolean isHigherEducation() {
            return true;
        }

        @Override
        public List<String> getEquivalentDegreeClassifications() {
            return Lists.newArrayList((Object[])new String[]{"M2"});
        }
    }
    ,
    MASTER_DEGREE_INTEGRATED(true, false, false){

        @Override
        public boolean isHigherEducation() {
            return true;
        }

        @Override
        public List<String> getEquivalentDegreeClassifications() {
            return Lists.newArrayList((Object[])new String[]{"MI", "MT"});
        }
    }
    ,
    MASTER_DEGREE_PRE_BOLOGNA(true, false, false){

        @Override
        public boolean isHigherEducation() {
            return true;
        }

        @Override
        public List<String> getEquivalentDegreeClassifications() {
            return Lists.newArrayList((Object[])new String[]{"M"});
        }
    }
    ,
    DOCTORATE_DEGREE(true, true, true){

        @Override
        public boolean isPhDDegree() {
            return true;
        }

        @Override
        public boolean isHigherEducation() {
            return true;
        }

        @Override
        public List<String> getEquivalentDegreeClassifications() {
            return Lists.newArrayList((Object[])new String[]{"D3"});
        }
    }
    ,
    DOCTORATE_DEGREE_PRE_BOLOGNA(true, false, false){

        @Override
        public boolean isPhDDegree() {
            return true;
        }

        @Override
        public boolean isHigherEducation() {
            return true;
        }

        @Override
        public List<String> getEquivalentDegreeClassifications() {
            return Lists.newArrayList((Object[])new String[]{"D"});
        }
    }
    ,
    OTHER(true, false, true){

        @Override
        public boolean isOther() {
            return true;
        }
    }
    ,
    OTHER_SITUATION(false, true, false);

    private boolean forStudent;
    private boolean forStudentHousehold;
    private boolean forMobilityStudent;

    private SchoolLevelType(boolean forStudent, boolean forStudentHousehold, boolean forMobilityStudent) {
        this.forStudent = forStudent;
        this.forStudentHousehold = forStudentHousehold;
        this.forMobilityStudent = forMobilityStudent;
    }

    public boolean isOther() {
        return false;
    }

    public boolean isPhDDegree() {
        return false;
    }

    public boolean isSchoolLevelBasicCycle() {
        return false;
    }

    public boolean isHighSchoolOrEquivalent() {
        return false;
    }

    public boolean isHigherEducation() {
        return false;
    }

    public List<String> getEquivalentDegreeClassifications() {
        return new ArrayList<String>();
    }

    public String getName() {
        return this.name();
    }

    public String getQualifiedName() {
        return SchoolLevelType.class.getSimpleName() + "." + this.name();
    }

    public String getFullyQualifiedName() {
        return SchoolLevelType.class.getName() + "." + this.name();
    }

    public boolean isForStudent() {
        return this.forStudent;
    }

    public boolean isForStudentHousehold() {
        return this.forStudentHousehold;
    }

    public boolean isForMobilityStudent() {
        return this.forMobilityStudent;
    }

    public static List<SchoolLevelType> getTypesForStudent() {
        ArrayList<SchoolLevelType> result = new ArrayList<SchoolLevelType>();
        for (SchoolLevelType each : SchoolLevelType.values()) {
            if (!each.isForStudent()) continue;
            result.add(each);
        }
        return result;
    }

    public static List<SchoolLevelType> getTypesForMobilityStudent() {
        ArrayList<SchoolLevelType> result = new ArrayList<SchoolLevelType>();
        for (SchoolLevelType each : SchoolLevelType.values()) {
            if (!each.isForMobilityStudent()) continue;
            result.add(each);
        }
        return result;
    }

    public static List<SchoolLevelType> getTypesForStudentHousehold() {
        ArrayList<SchoolLevelType> result = new ArrayList<SchoolLevelType>();
        for (SchoolLevelType each : SchoolLevelType.values()) {
            if (!each.isForStudentHousehold()) continue;
            result.add(each);
        }
        return result;
    }

    public String getLocalizedName() {
        return BundleUtil.getString((String)"resources.EnumerationResources", (String)this.getQualifiedName(), (String[])new String[0]);
    }
}

