/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.math.BigDecimal;
import java.util.Collection;
import org.fenixedu.academic.domain.DocumentType;
import org.fenixedu.academic.domain.GraduationType;
import org.fenixedu.academic.domain.Guide;
import org.fenixedu.academic.domain.GuideEntry_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.reimbursementGuide.ReimbursementGuideEntry;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class GuideEntry
extends GuideEntry_Base {
    public GuideEntry() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public GuideEntry(GraduationType graduationType, DocumentType documentType, String description, Integer quantity, BigDecimal price, Guide guide) {
        this();
        this.setDescription(description);
        this.setGuide(guide);
        this.setDocumentType(documentType);
        this.setGraduationType(graduationType);
        this.setPriceBigDecimal(price);
        this.setQuantity(quantity);
    }

    public void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        if (this.getPaymentTransaction() != null) {
            this.getPaymentTransaction().delete();
        }
        Guide guide = this.getGuide();
        this.setGuide(null);
        guide.updateTotalValue();
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getReimbursementGuideEntriesSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"guide.entry.cannot.be.deleted", (String[])new String[0]));
        }
    }

    @Deprecated
    public Double getPrice() {
        return this.getPriceBigDecimal().doubleValue();
    }

    @Deprecated
    public void setPrice(Double price) {
        this.setPriceBigDecimal(BigDecimal.valueOf(price));
    }

    public BigDecimal getValueWithAdjustment() {
        BigDecimal reimbursedValue = BigDecimal.ZERO;
        for (ReimbursementGuideEntry reimbursementGuideEntry : this.getReimbursementGuideEntriesSet()) {
            if (!reimbursementGuideEntry.getReimbursementGuide().isPayed()) continue;
            reimbursedValue = reimbursedValue.add(reimbursementGuideEntry.getValueBigDecimal());
        }
        return this.getPriceBigDecimal().subtract(reimbursedValue);
    }
}

