/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationConfiguration$callable$initialize;
import org.fenixedu.academic.domain.EvaluationConfiguration_Base;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.curriculum.EnrollmentState;
import org.fenixedu.academic.domain.curriculum.EnrolmentEvaluationContext;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EvaluationConfiguration
extends EvaluationConfiguration_Base {
    private static Comparator<EnrolmentEvaluation> ENROLMENT_EVALUATION_ORDER;
    public static final Advice advice$initialize;

    private EvaluationConfiguration() {
        this.setRoot(Bennu.getInstance());
    }

    public static EvaluationConfiguration getInstance() {
        if (Bennu.getInstance().getEvaluationConfiguration() == null) {
            return EvaluationConfiguration.initialize();
        }
        return Bennu.getInstance().getEvaluationConfiguration();
    }

    private static EvaluationConfiguration initialize() {
        return (EvaluationConfiguration)((Object)advice$initialize.perform((Callable)new EvaluationConfiguration$callable$initialize()));
    }

    static /* synthetic */ EvaluationConfiguration advised$initialize() {
        if (Bennu.getInstance().getEvaluationConfiguration() == null) {
            return new EvaluationConfiguration();
        }
        return Bennu.getInstance().getEvaluationConfiguration();
    }

    public static void setEnrolmentEvaluationOrder(Comparator<EnrolmentEvaluation> order) {
        ENROLMENT_EVALUATION_ORDER = order;
    }

    public Optional<EnrolmentEvaluation> getFinalEnrolmentEvaluation(Enrolment enrolment) {
        Predicate<EnrolmentEvaluation> isFinal = EnrolmentEvaluation::isFinal;
        return enrolment.getEvaluationsSet().stream().filter(isFinal).max(ENROLMENT_EVALUATION_ORDER);
    }

    public Optional<EnrolmentEvaluation> getFinalEnrolmentEvaluation(Enrolment enrolment, EvaluationSeason season) {
        Predicate<EnrolmentEvaluation> isFinal = EnrolmentEvaluation::isFinal;
        Predicate<EnrolmentEvaluation> isSeason = e -> e.getEvaluationSeason().equals(season);
        return enrolment.getEvaluationsSet().stream().filter(isFinal.and(isSeason)).max(ENROLMENT_EVALUATION_ORDER);
    }

    public Optional<EnrolmentEvaluation> getEnrolmentEvaluationForConclusionDate(Enrolment enrolment) {
        Predicate<EnrolmentEvaluation> isFinal = EnrolmentEvaluation::isFinal;
        Predicate<EnrolmentEvaluation> isImprovement = e -> e.getEvaluationSeason().isImprovement();
        Predicate<EnrolmentEvaluation> hasExam = e -> e.getExamDateYearMonthDay() != null;
        return enrolment.getEvaluationsSet().stream().filter(isFinal.and(isImprovement.negate()).and(hasExam)).max(ENROLMENT_EVALUATION_ORDER);
    }

    public Optional<EnrolmentEvaluation> getCurrentEnrolmentEvaluation(Enrolment enrolment, EvaluationSeason season) {
        Predicate<EnrolmentEvaluation> isSeason = e -> e.getEvaluationSeason().equals(season);
        return enrolment.getEvaluationsSet().stream().filter(isSeason).max(EnrolmentEvaluation.COMPARATORY_BY_WHEN);
    }

    static {
        advice$initialize = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        ENROLMENT_EVALUATION_ORDER = new EnrolmentComparator();
    }

    public static class EnrolmentComparator
    implements Comparator<EnrolmentEvaluation> {
        @Override
        public int compare(EnrolmentEvaluation o1, EnrolmentEvaluation o2) {
            if (o1.getEnrolment().getStudentCurricularPlan().getDegreeType().isPreBolonhaMasterDegree()) {
                return this.compareMyWhenAlteredDateToAnotherWhenAlteredDate(o1.getWhen(), o2.getWhen());
            }
            if (this.isInCurriculumValidationContextAndIsFinal(o1) && !this.isInCurriculumValidationContextAndIsFinal(o2)) {
                return 1;
            }
            if (!this.isInCurriculumValidationContextAndIsFinal(o1) && this.isInCurriculumValidationContextAndIsFinal(o2)) {
                return -1;
            }
            if (this.isInCurriculumValidationContextAndIsFinal(o1) && this.isInCurriculumValidationContextAndIsFinal(o2)) {
                return this.compareMyWhenAlteredDateToAnotherWhenAlteredDate(o1.getWhen(), o2.getWhen());
            }
            if (o1.getEvaluationSeason().equals(o2.getEvaluationSeason())) {
                if (o1.isRectification() && o2.isRectification() || o1.isRectified() && o2.isRectified()) {
                    return this.compareMyWhenAlteredDateToAnotherWhenAlteredDate(o1.getWhen(), o2.getWhen());
                }
                if (o1.isRectification()) {
                    return 1;
                }
                if (o2.isRectification()) {
                    return -1;
                }
                return this.compareByGrade(o1, o1.getGrade(), o2.getGrade());
            }
            return this.compareByGrade(o1, o1.getGrade(), o2.getGrade());
        }

        private int compareByGrade(EnrolmentEvaluation enrolmentEvaluation, Grade grade, Grade otherGrade) {
            EnrollmentState gradeEnrolmentState = enrolmentEvaluation.getEnrollmentStateByGrade();
            EnrollmentState otherGradeEnrolmentState = otherGrade.getEnrolmentState();
            if (gradeEnrolmentState == EnrollmentState.APROVED && otherGradeEnrolmentState == EnrollmentState.APROVED) {
                return grade.compareTo(otherGrade);
            }
            return this.compareByGradeState(gradeEnrolmentState, otherGradeEnrolmentState);
        }

        private int compareByGradeState(EnrollmentState gradeEnrolmentState, EnrollmentState otherGradeEnrolmentState) {
            if (gradeEnrolmentState == EnrollmentState.APROVED) {
                return 1;
            }
            if (otherGradeEnrolmentState == EnrollmentState.APROVED) {
                return -1;
            }
            if (gradeEnrolmentState == EnrollmentState.NOT_APROVED && otherGradeEnrolmentState == EnrollmentState.NOT_EVALUATED) {
                return 1;
            }
            if (gradeEnrolmentState == EnrollmentState.NOT_EVALUATED && otherGradeEnrolmentState == EnrollmentState.NOT_APROVED) {
                return -1;
            }
            return 0;
        }

        private int compareMyWhenAlteredDateToAnotherWhenAlteredDate(Date when1, Date whenAltered) {
            if (when1 == null) {
                return -1;
            }
            if (whenAltered == null) {
                return 1;
            }
            return when1.compareTo(whenAltered);
        }

        public boolean isInCurriculumValidationContextAndIsFinal(EnrolmentEvaluation enrolmentEvaluation) {
            return enrolmentEvaluation.getContext() != null && enrolmentEvaluation.getContext().equals((Object)EnrolmentEvaluationContext.CURRICULUM_VALIDATION_EVALUATION) && enrolmentEvaluation.isFinal();
        }
    }
}

