/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util.report;

import java.util.Collection;
import java.util.Map;

public interface ReportPrinter {
    public ReportResult printReports(ReportDescription ... var1) throws Exception;

    default public ReportResult printReport(final String key, final Map<String, Object> parameters, final Collection<?> dataSource) throws Exception {
        return this.printReports(new ReportDescription(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public Map<String, Object> getParameters() {
                return parameters;
            }

            @Override
            public Collection<?> getDataSource() {
                return dataSource;
            }
        });
    }

    public static class ReportResult {
        private final byte[] data;
        private final String contentType;
        private final String fileExtension;

        public ReportResult(byte[] data, String contentType, String fileExtension) {
            this.data = data;
            this.contentType = contentType;
            this.fileExtension = fileExtension;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getFileExtension() {
            return this.fileExtension;
        }
    }

    public static interface ReportDescription {
        public String getKey();

        public Map<String, Object> getParameters();

        public Collection<?> getDataSource();
    }
}

