/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;

@Deprecated
public class MultiLanguageString
implements Serializable,
Comparable<MultiLanguageString> {
    public static final Locale en = new Locale.Builder().setLanguage("en").setRegion("UK").build();
    public static final Locale pt = new Locale.Builder().setLanguage("pt").setRegion("PT").build();
    private final LocalizedString localized;

    public MultiLanguageString() {
        this.localized = new LocalizedString();
    }

    public MultiLanguageString(String content) {
        this.localized = new LocalizedString(I18N.getLocale(), content);
    }

    public MultiLanguageString(Locale locale, String content) {
        if (locale == null) {
            throw new IllegalArgumentException("locale cannot be null");
        }
        this.localized = new LocalizedString(locale, content);
    }

    private MultiLanguageString(LocalizedString localized) {
        this.localized = localized;
    }

    public MultiLanguageString with(Locale locale, String content) {
        return new MultiLanguageString(this.localized.with(locale, content));
    }

    public MultiLanguageString without(Locale locale) {
        if (locale != null) {
            return new MultiLanguageString(this.localized.without(locale));
        }
        return this;
    }

    public Collection<String> getAllContents() {
        HashSet<String> contents = new HashSet<String>();
        for (Locale locale : this.localized.getLocales()) {
            contents.add(this.localized.getContent(locale));
        }
        return contents;
    }

    public Collection<Locale> getAllLocales() {
        return this.localized.getLocales();
    }

    public Locale getContentLocale() {
        Locale locale = I18N.getLocale();
        if (this.hasLocale(locale)) {
            return locale;
        }
        Locale defaultLocale = Locale.getDefault();
        if (this.hasLocale(defaultLocale)) {
            return defaultLocale;
        }
        return this.localized.getLocales().isEmpty() ? null : (Locale)this.localized.getLocales().iterator().next();
    }

    public String getContent() {
        return this.localized.getContent();
    }

    public String getContent(Locale locale) {
        return this.localized.getContent(locale);
    }

    public String getPreferedContent() {
        return this.hasLocale(Locale.getDefault()) ? this.getContent(Locale.getDefault()) : this.getContent();
    }

    public boolean hasContent() {
        return !this.isEmpty();
    }

    public boolean hasContent(Locale locale) {
        return !StringUtils.isEmpty((String)this.getContent(locale));
    }

    public boolean hasLocale(Locale locale) {
        return this.localized.getLocales().contains(locale);
    }

    public String exportAsString() {
        return this.localized.json().toString();
    }

    public MultiLanguageString append(MultiLanguageString string) {
        return new MultiLanguageString(this.localized.append(string.toLocalizedString()));
    }

    public MultiLanguageString append(String string) {
        return new MultiLanguageString(this.localized.append(string));
    }

    public boolean isEmpty() {
        return this.localized.isEmpty();
    }

    public static MultiLanguageString importFromString(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("{")) {
            JsonParser parser = new JsonParser();
            return new MultiLanguageString(LocalizedString.fromJson((JsonElement)parser.parse(string)));
        }
        LocalizedString.Builder builder = new LocalizedString.Builder();
        String nullContent = "";
        int i = 0;
        while (i < string.length()) {
            int length = 0;
            int collonPosition = string.indexOf(58, i + 2);
            if (!StringUtils.isNumeric((String)string.substring(i + 2, collonPosition))) {
                length = Integer.parseInt(string.substring(i + 4, collonPosition));
                nullContent = string.substring(collonPosition + 1, collonPosition + 1 + length);
            } else {
                length = Integer.parseInt(string.substring(i + 2, collonPosition));
                String language = string.substring(i, i + 2);
                String content = string.substring(collonPosition + 1, collonPosition + 1 + length);
                builder.with(new Locale.Builder().setLanguage(language).build(), content);
            }
            i = collonPosition + 1 + length;
        }
        LocalizedString localized = builder.build();
        if (localized.isEmpty()) {
            localized = localized.with(Locale.getDefault(), nullContent);
        }
        return new MultiLanguageString(localized);
    }

    public String toString() {
        String content = this.getContent();
        return content == null ? "" : content;
    }

    @Override
    public int compareTo(MultiLanguageString mls) {
        return this.localized.compareTo(mls.localized);
    }

    public boolean equalInAnyLanguage(Object obj) {
        block3: {
            block2: {
                if (!(obj instanceof MultiLanguageString)) break block2;
                MultiLanguageString multiLanguageString = (MultiLanguageString)obj;
                HashSet<Locale> locales = new HashSet<Locale>();
                locales.addAll(this.getAllLocales());
                locales.addAll(multiLanguageString.getAllLocales());
                for (Locale locale : locales) {
                    if (this.getContent(locale) == null || !this.getContent(locale).equalsIgnoreCase(multiLanguageString.getContent(locale))) continue;
                    return true;
                }
                break block3;
            }
            if (!(obj instanceof String)) break block3;
            for (String string : this.getAllContents()) {
                if (!string.equals(obj)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MultiLanguageString) {
            MultiLanguageString multiLanguageString = (MultiLanguageString)obj;
            return this.localized.equals((Object)multiLanguageString.localized);
        }
        return false;
    }

    public int hashCode() {
        return this.localized.hashCode();
    }

    public LocalizedString toLocalizedString() {
        return this.localized;
    }

    public static MultiLanguageString fromLocalizedString(LocalizedString localized) {
        return new MultiLanguageString(localized);
    }
}

