/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import org.fenixedu.academic.util.FenixUtil;
import org.fenixedu.commons.i18n.I18N;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

public class DiaSemana
extends FenixUtil {
    public static final int DOMINGO = 1;
    public static final int SEGUNDA_FEIRA = 2;
    public static final int TERCA_FEIRA = 3;
    public static final int QUARTA_FEIRA = 4;
    public static final int QUINTA_FEIRA = 5;
    public static final int SEXTA_FEIRA = 6;
    public static final int SABADO = 7;
    private final Integer diaSemana;

    public DiaSemana(int diaSemana) {
        this.diaSemana = new Integer(diaSemana);
    }

    public DiaSemana(Integer diaSemana) {
        this.diaSemana = diaSemana;
    }

    public Integer getDiaSemana() {
        return this.diaSemana;
    }

    public String getDiaSemanaString() {
        return this.toString();
    }

    public boolean equals(Object obj) {
        boolean resultado = false;
        if (obj instanceof DiaSemana) {
            DiaSemana diaSemana = (DiaSemana)obj;
            resultado = this.getDiaSemana().intValue() == diaSemana.getDiaSemana().intValue();
        }
        return resultado;
    }

    public String toString() {
        int diaSemana = this.diaSemana;
        switch (diaSemana) {
            case 2: {
                return new DateTime().withDayOfWeek(1).dayOfWeek().getAsShortText(I18N.getLocale());
            }
            case 3: {
                return new DateTime().withDayOfWeek(2).dayOfWeek().getAsShortText(I18N.getLocale());
            }
            case 4: {
                return new DateTime().withDayOfWeek(3).dayOfWeek().getAsShortText(I18N.getLocale());
            }
            case 5: {
                return new DateTime().withDayOfWeek(4).dayOfWeek().getAsShortText(I18N.getLocale());
            }
            case 6: {
                return new DateTime().withDayOfWeek(5).dayOfWeek().getAsShortText(I18N.getLocale());
            }
            case 7: {
                return new DateTime().withDayOfWeek(6).dayOfWeek().getAsShortText(I18N.getLocale());
            }
            case 1: {
                return new DateTime().withDayOfWeek(7).dayOfWeek().getAsShortText(I18N.getLocale());
            }
        }
        return "Error: Invalid week day";
    }

    public int getDiaSemanaInDayOfWeekJodaFormat() {
        return this.getDiaSemana() == 1 ? 7 : this.getDiaSemana() - 1;
    }

    public static int getDiaSemana(YearMonthDay date) {
        DateTime dateTime = date.toDateTimeAtMidnight();
        return dateTime.getDayOfWeek() == 7 ? 1 : dateTime.getDayOfWeek() + 1;
    }

    public static DiaSemana fromJodaWeekDay(int jodaWeekDay) {
        int i = jodaWeekDay == 7 ? 1 : jodaWeekDay + 1;
        return new DiaSemana(i);
    }
}

