/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.Mark;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.student.StudentApplication;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;

@StrutsFunctionality(app=StudentApplication.StudentViewApp.class, descriptionKey="link.student.statistics", path="statistics", titleKey="link.title.statistics")
@Mapping(module="student", path="/showStudentStatistics", scope="request", parameter="method")
@Forwards(value={@Forward(name="showStudentStatisticsHome", path="/student/statistics/home.jsp"), @Forward(name="showExecutionCourseStatistics", path="/student/statistics/executionCourse.jsp")})
public class ShowStudentStatisticsDispatchAction
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward showStudentStatisticsHome(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Student student = this.getLoggedPerson(request).getStudent();
        if (student != null) {
            HashSet<Enrolment> approvedEnrolments = new HashSet<Enrolment>();
            for (Registration registration : this.getValidRegistrations(student)) {
                approvedEnrolments.addAll(registration.getApprovedEnrolments());
            }
            request.setAttribute("progress", (Object)this.computeStudentProgress(student));
            request.setAttribute("curricularCoursesOvertime", (Object)this.computeCurricularCoursesOvertimeStatistics(approvedEnrolments));
        }
        return mapping.findForward("showStudentStatisticsHome");
    }

    public ActionForward showExecutionCourseStatistics(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Student student = this.getLoggedPerson(request).getStudent();
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)this.getDomainObject(request, "executionCourseId"));
        if (student != null && executionCourse != null) {
            request.setAttribute("executionCourse", (Object)executionCourse);
            request.setAttribute("executionCourseStatistics", (Object)this.computeStudentExecutionCourseStatistics(student, executionCourse));
            request.setAttribute("curricularCourseOvertimeStatistics", (Object)this.computeCurricularCourseOvertimeStatistics(student.getAttends(executionCourse).getEnrolment().getCurricularCourse()));
        }
        return mapping.findForward("showExecutionCourseStatistics");
    }

    private List<Registration> getValidRegistrations(Student student) {
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (Registration registration : student.getRegistrationsSet()) {
            if (registration.isCanceled()) continue;
            result.add(registration);
        }
        return result;
    }

    private JsonObject computeCurricularCoursesOvertimeStatistics(Collection<Enrolment> approvedEnrolments) {
        JsonObject curricularCoursesOvertime = new JsonObject();
        int lowestStartYear = Integer.MAX_VALUE;
        int highestStartYear = Integer.MIN_VALUE;
        JsonArray curricularCoursesJsonArray = new JsonArray();
        for (Enrolment enrolment : approvedEnrolments) {
            CurricularCourse curricularCourse = enrolment.getCurricularCourse();
            JsonObject curricularCourseJsonObject = new JsonObject();
            curricularCourseJsonObject.addProperty("name", curricularCourse.getNameI18N().getContent());
            JsonArray entriesArray = new JsonArray();
            HashMap<Integer, CurricularCourseYearStatistics> entries = new HashMap<Integer, CurricularCourseYearStatistics>();
            for (ExecutionCourse executionCourse : curricularCourse.getAssociatedExecutionCoursesSet()) {
                AcademicInterval academicInterval;
                int startYear;
                CurricularCourseYearStatistics curricularCourseYearStatistics = this.computeExecutionCourseJsonArray(executionCourse, (CurricularCourseYearStatistics)entries.get(startYear = (academicInterval = executionCourse.getAcademicInterval()).getStart().getYear()));
                if (curricularCourseYearStatistics == null) continue;
                entries.put(startYear, curricularCourseYearStatistics);
                if (lowestStartYear > startYear) {
                    lowestStartYear = startYear;
                }
                if (highestStartYear >= startYear) continue;
                highestStartYear = startYear;
            }
            Iterator<Object> iterator = entries.keySet().iterator();
            while (iterator.hasNext()) {
                int year = (Integer)iterator.next();
                JsonArray jsonArray = new JsonArray();
                jsonArray.add((JsonElement)new JsonPrimitive((Number)year));
                jsonArray.add((JsonElement)new JsonPrimitive((Number)((CurricularCourseYearStatistics)entries.get(year)).getApproved()));
                jsonArray.add((JsonElement)new JsonPrimitive((Number)((CurricularCourseYearStatistics)entries.get(year)).getFlunked()));
                jsonArray.add((JsonElement)new JsonPrimitive((Number)((CurricularCourseYearStatistics)entries.get(year)).getNotEvaluated()));
                entriesArray.add((JsonElement)jsonArray);
            }
            curricularCourseJsonObject.add("years", (JsonElement)entriesArray);
            curricularCoursesJsonArray.add((JsonElement)curricularCourseJsonObject);
        }
        curricularCoursesOvertime.addProperty("start-year", (Number)lowestStartYear);
        curricularCoursesOvertime.addProperty("end-year", (Number)highestStartYear);
        curricularCoursesOvertime.add("entries", (JsonElement)curricularCoursesJsonArray);
        return curricularCoursesOvertime;
    }

    private CurricularCourseYearStatistics computeExecutionCourseJsonArray(ExecutionCourse executionCourse, CurricularCourseYearStatistics curricularCourseYearStatistics) {
        int approvedStudents = 0;
        int flunkedStudents = 0;
        int notEvaluatedStudents = 0;
        for (Attends attends : executionCourse.getAttendsSet()) {
            if (attends.getEnrolment() == null) continue;
            Enrolment enrolment = attends.getEnrolment();
            if (enrolment.isApproved()) {
                ++approvedStudents;
                continue;
            }
            if (enrolment.isFlunked()) {
                ++flunkedStudents;
                continue;
            }
            ++notEvaluatedStudents;
        }
        if (approvedStudents + flunkedStudents + notEvaluatedStudents == 0) {
            return null;
        }
        if (curricularCourseYearStatistics == null) {
            return new CurricularCourseYearStatistics(approvedStudents, flunkedStudents, notEvaluatedStudents);
        }
        curricularCourseYearStatistics.inc(approvedStudents, flunkedStudents, notEvaluatedStudents);
        return curricularCourseYearStatistics;
    }

    private JsonObject computeStudentInfo(Student student) {
        JsonObject studentInfoJsonObject = new JsonObject();
        studentInfoJsonObject.addProperty("id", (Number)student.getNumber());
        studentInfoJsonObject.addProperty("name", student.getName());
        return studentInfoJsonObject;
    }

    private JsonElement computeStudentExecutionCourseStatistics(Student student, ExecutionCourse executionCourse) {
        JsonObject executionCourseJsonObject = new JsonObject();
        executionCourseJsonObject.addProperty("acronym", executionCourse.getSigla());
        executionCourseJsonObject.addProperty("name", executionCourse.getNameI18N().getContent());
        executionCourseJsonObject.add("student", (JsonElement)this.computeStudentInfo(student));
        JsonArray evaluationsArray = this.computeExecutionCourseEvaluations(student, executionCourse);
        evaluationsArray.add((JsonElement)this.computeFinalGrades(executionCourse));
        executionCourseJsonObject.add("evaluations", (JsonElement)evaluationsArray);
        return executionCourseJsonObject;
    }

    private JsonArray computeExecutionCourseEvaluations(Student student, ExecutionCourse executionCourse) {
        JsonArray evaluationsArray = new JsonArray();
        for (WrittenEvaluation writtenEvaluation : executionCourse.getAssociatedWrittenEvaluations()) {
            JsonObject writtenEvaluationJsonObject = this.computeWrittenEvaluation(writtenEvaluation);
            if (writtenEvaluationJsonObject == null) continue;
            evaluationsArray.add((JsonElement)writtenEvaluationJsonObject);
        }
        return evaluationsArray;
    }

    private JsonObject computeWrittenEvaluation(WrittenEvaluation writtenEvaluation) {
        if (writtenEvaluation.getMarksSet().size() > 0) {
            JsonObject writtenEvaluationJsonObject = new JsonObject();
            writtenEvaluationJsonObject.addProperty("name", writtenEvaluation.getPresentationName());
            writtenEvaluationJsonObject.addProperty("grade-scale", writtenEvaluation.getGradeScale().name());
            this.populateMinAndMaxGrade(writtenEvaluation.getGradeScale(), writtenEvaluationJsonObject);
            writtenEvaluationJsonObject.add("grades", (JsonElement)this.computeWrittenEvaluationGrades(writtenEvaluation));
            return writtenEvaluationJsonObject;
        }
        return null;
    }

    private void populateMinAndMaxGrade(GradeScale scale, JsonObject evaluationJsonObject) {
        String minGrade = "0";
        String minRequiredGrade = "10";
        String maxGrade = "20";
        switch (scale) {
            case TYPE5: {
                minGrade = "0";
                minRequiredGrade = "3";
                maxGrade = "5";
                break;
            }
            case TYPEAP: {
                minGrade = "RE";
                minRequiredGrade = "AP";
                maxGrade = "AP";
                break;
            }
        }
        evaluationJsonObject.addProperty("minRequiredGrade", minRequiredGrade);
        evaluationJsonObject.addProperty("minGrade", minGrade);
        evaluationJsonObject.addProperty("maxGrade", maxGrade);
    }

    private JsonArray computeWrittenEvaluationGrades(WrittenEvaluation writtenEvaluation) {
        JsonArray gradesArray = new JsonArray();
        for (Mark mark : writtenEvaluation.getMarksSet()) {
            gradesArray.add(this.computeMark(mark));
        }
        return gradesArray;
    }

    private JsonElement computeMark(Mark mark) {
        Student student = mark.getAttend().getRegistration().getStudent();
        JsonObject markJsonObject = new JsonObject();
        markJsonObject.addProperty("id", (Number)student.getNumber());
        markJsonObject.addProperty("name", student.getName());
        markJsonObject.addProperty("grade", mark.getMark());
        return markJsonObject;
    }

    private JsonElement computeCurricularCourseOvertimeStatistics(CurricularCourse curricularCourse) {
        JsonObject jsonObject = new JsonObject();
        JsonArray entries = new JsonArray();
        for (ExecutionCourse executionCourse : curricularCourse.getAssociatedExecutionCoursesSet()) {
            JsonElement executionCourseStatistics;
            if (!executionCourse.getExecutionPeriod().isBefore(ExecutionSemester.readActualExecutionSemester()) || executionCourse.getEnrolmentCount() <= 0 || (executionCourseStatistics = this.computeExecutionCourseStatistics(executionCourse)) == null) continue;
            entries.add(executionCourseStatistics);
        }
        jsonObject.add("entries", (JsonElement)entries);
        JsonArray domainJsonArray = new JsonArray();
        domainJsonArray.add((JsonElement)new JsonPrimitive("positive-grades"));
        domainJsonArray.add((JsonElement)new JsonPrimitive("negative-grades"));
        domainJsonArray.add((JsonElement)new JsonPrimitive("not-evaluated-grades"));
        jsonObject.add("domain", (JsonElement)domainJsonArray);
        return jsonObject;
    }

    private JsonElement computeExecutionCourseStatistics(ExecutionCourse executionCourse) {
        JsonObject executionCourseJsonObject = new JsonObject();
        executionCourseJsonObject.addProperty("text", this.getShortExecutionSemesterName(executionCourse.getExecutionPeriod()));
        executionCourseJsonObject.addProperty("description", executionCourse.getNameI18N().getContent());
        int positiveGrades = 0;
        int negativeGrades = 0;
        int notEvaluatedGrades = 0;
        for (Enrolment enrolment : executionCourse.getActiveEnrollments()) {
            if (enrolment.isNotEvaluated()) {
                ++notEvaluatedGrades;
                continue;
            }
            if (enrolment.isFlunked()) {
                ++negativeGrades;
                continue;
            }
            ++positiveGrades;
        }
        if (positiveGrades + negativeGrades + notEvaluatedGrades == 0) {
            return null;
        }
        executionCourseJsonObject.addProperty("positive-grades", (Number)positiveGrades);
        executionCourseJsonObject.addProperty("negative-grades", (Number)negativeGrades);
        executionCourseJsonObject.addProperty("not-evaluated-grades", (Number)notEvaluatedGrades);
        return executionCourseJsonObject;
    }

    private String getShortExecutionSemesterName(ExecutionSemester executionSemester) {
        return executionSemester.getExecutionYear().getName().substring(2, 4) + "/" + executionSemester.getExecutionYear().getName().substring(7, 9) + " (S" + executionSemester.getSemester() + ")";
    }

    private JsonObject computeFinalGrades(ExecutionCourse executionCourse) {
        List<Enrolment> enrolments = executionCourse.getActiveEnrollments();
        if (enrolments.isEmpty()) {
            return null;
        }
        JsonObject enrolmentsJsonObject = new JsonObject();
        enrolmentsJsonObject.addProperty("name", BundleUtil.getString((String)"resources.StudentResources", (String)"label.student.statistics.marksheet", (String[])new String[0]));
        GradeScale gradeScale = enrolments.get(0).getGradeScale();
        enrolmentsJsonObject.addProperty("grade-scale", gradeScale.name());
        this.populateMinAndMaxGrade(gradeScale, enrolmentsJsonObject);
        JsonArray gradesArray = new JsonArray();
        for (Enrolment enrolment : enrolments) {
            JsonObject enrolmentJsonObject = new JsonObject();
            enrolmentJsonObject.addProperty("id", (Number)enrolment.getRegistration().getStudent().getNumber());
            enrolmentJsonObject.addProperty("name", enrolment.getRegistration().getStudent().getName());
            enrolmentJsonObject.addProperty("grade", enrolment.isNotEvaluated() ? "NE" : (enrolment.isFlunked() ? "RE" : enrolment.getGradeValue()));
            gradesArray.add((JsonElement)enrolmentJsonObject);
        }
        enrolmentsJsonObject.add("grades", (JsonElement)gradesArray);
        return enrolmentsJsonObject;
    }

    private JsonElement computeStudentProgress(Student student) {
        JsonArray jsonArray = new JsonArray();
        for (Registration registration : student.getRegistrationsSet()) {
            if (!registration.isActive() && !registration.isConcluded()) continue;
            jsonArray.add(this.computeRegistrationProgress(registration));
        }
        return jsonArray;
    }

    private JsonElement computeRegistrationProgress(Registration registration) {
        JsonObject registrationProgressJsonObject = new JsonObject();
        registrationProgressJsonObject.addProperty("year", (Number)registration.getStartDate().getYear());
        registrationProgressJsonObject.addProperty("degree", registration.getDegreeCurricularPlanName());
        registrationProgressJsonObject.addProperty("required-credits", (Number)registration.getDegree().getEctsCredits());
        registrationProgressJsonObject.addProperty("credits", (Number)registration.getEctsCredits());
        if (registration.isConcluded()) {
            registrationProgressJsonObject.addProperty("status", "concluded");
        } else if (registration.isActive()) {
            registrationProgressJsonObject.addProperty("status", "active");
        }
        return registrationProgressJsonObject;
    }

    public static class CurricularCourseYearStatistics {
        private int approved;
        private int flunked;
        private int notEvaluated;

        public CurricularCourseYearStatistics() {
            this(0, 0, 0);
        }

        public CurricularCourseYearStatistics(int approved, int flunked, int notEvaluated) {
            this.approved = approved;
            this.flunked = flunked;
            this.notEvaluated = notEvaluated;
        }

        public void inc(int approved, int flunked, int notEvaluated) {
            this.approved += approved;
            this.flunked += flunked;
            this.notEvaluated += notEvaluated;
        }

        public int getApproved() {
            return this.approved;
        }

        public int getFlunked() {
            return this.flunked;
        }

        public int getNotEvaluated() {
            return this.notEvaluated;
        }
    }
}

