/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.scientificCouncil;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformationChangeRequest;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.service.services.bolonhaManager.CompetenceCourseManagementAccessControl;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.scientificCouncil.ScientificCouncilApplication;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=ScientificCouncilApplication.ScientificBolonhaProcessApp.class, path="manage-versions", titleKey="navigation.competenceCourseVersionManagement")
@Mapping(module="scientificCouncil", path="/competenceCourses/manageVersions")
@Forwards(value={@Forward(name="manageVersions", path="/scientificCouncil/bolonha/manageVersions.jsp"), @Forward(name="listRequests", path="/scientificCouncil/bolonha/listVersions.jsp"), @Forward(name="viewVersionDetails", path="/scientificCouncil/bolonha/viewVersionDetails.jsp")})
public class ManageCompetenceCourseInformationChangeRequests
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("departments", (Object)Bennu.getInstance().getDepartmentsSet());
        return mapping.findForward("manageVersions");
    }

    public ActionForward displayRequest(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        String departmentID = request.getParameter("departmentID");
        Department department = (Department)FenixFramework.getDomainObject((String)departmentID);
        this.putChangeRequestInRequest(request, department);
        return mapping.findForward("listRequests");
    }

    public ActionForward viewVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CompetenceCourseInformationChangeRequest changeRequest = this.getChangeRequest(request);
        if (changeRequest != null && this.isAllowedToViewChangeRequest(this.getLoggedPerson(request), changeRequest)) {
            request.setAttribute("changeRequest", (Object)changeRequest);
        }
        return mapping.findForward("viewVersionDetails");
    }

    public ActionForward approveRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CompetenceCourseInformationChangeRequest changeRequest = this.getChangeRequest(request);
        if (changeRequest != null && this.isAllowedToViewChangeRequest(this.getLoggedPerson(request), changeRequest)) {
            try {
                changeRequest.approve(this.getLoggedPerson(request));
            }
            catch (DomainException e) {
                this.addActionMessage(request, e.getMessage());
            }
        }
        return this.displayRequest(mapping, form, request, response);
    }

    public ActionForward rejectRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        CompetenceCourseInformationChangeRequest changeRequest = this.getChangeRequest(request);
        if (changeRequest != null && this.isAllowedToViewChangeRequest(this.getLoggedPerson(request), changeRequest)) {
            try {
                changeRequest.reject(this.getLoggedPerson(request));
            }
            catch (DomainException e) {
                this.addActionMessage(request, e.getMessage());
            }
        }
        return this.displayRequest(mapping, form, request, response);
    }

    private CompetenceCourseInformationChangeRequest getChangeRequest(HttpServletRequest request) {
        String competenceCourseInformationChangeRequestId = request.getParameter("changeRequestID");
        CompetenceCourseInformationChangeRequest changeRequest = (CompetenceCourseInformationChangeRequest)FenixFramework.getDomainObject((String)competenceCourseInformationChangeRequestId);
        return changeRequest;
    }

    private CompetenceCourse getCompetenceCourse(HttpServletRequest request) {
        String competenceCourseID = request.getParameter("competenceCourseID");
        CompetenceCourse course = (CompetenceCourse)FenixFramework.getDomainObject((String)competenceCourseID);
        return course;
    }

    private void putChangeRequestInRequest(HttpServletRequest request, Department department) {
        ArrayList requests = new ArrayList();
        for (CompetenceCourse courses : department.getDepartmentUnit().getCompetenceCourses()) {
            requests.addAll(courses.getCompetenceCourseInformationChangeRequestsSet());
        }
        request.setAttribute("changeRequests", requests);
    }

    private boolean isAllowedToViewChangeRequest(Person loggedPerson, CompetenceCourseInformationChangeRequest changeRequest) {
        return CompetenceCourseManagementAccessControl.isLoggedPersonAllowedToApproveChangeRequestsPredicate(changeRequest);
    }
}

