/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.publico.spaces;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.dto.spaceManager.FindSpacesBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.publico.PublicApplication;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.spaces.domain.BlueprintFile;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.services.SpaceBlueprintsDWGProcessor;
import org.joda.time.DateTime;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=PublicApplication.class, path="find-spaces", titleKey="title.search.spaces")
@Mapping(module="publico", path="/findSpaces")
@Forwards(value={@Forward(name="listFoundSpaces", path="/publico/spaces/findSpaces.jsp"), @Forward(name="viewSelectedSpace", path="/publico/spaces/viewSelectedSpace.jsp")})
public class FindSpacesDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepareSearchSpaces(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FindSpacesBean bean = new FindSpacesBean();
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("listFoundSpaces");
    }

    public ActionForward prepareSearchSpacesPostBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FindSpacesBean bean = (FindSpacesBean)this.getRenderedObject("beanWithLabelToSearchID");
        request.setAttribute("bean", (Object)bean);
        RenderUtils.invalidateViewState((String)"beanWithLabelToSearchID");
        return mapping.findForward("listFoundSpaces");
    }

    public ActionForward search(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FindSpacesBean bean = (FindSpacesBean)this.getRenderedObject("beanWithLabelToSearchID");
        if (bean != null) {
            String labelToSearch = bean.getLabelToSearch();
            Space campus = bean.getCampus();
            Space building = bean.getBuilding();
            if (campus != null && building == null && (labelToSearch == null || StringUtils.isEmpty((String)labelToSearch.trim()))) {
                this.addActionMessage(request, "error.findSpaces.empty.building");
                request.setAttribute("bean", (Object)bean);
                return mapping.findForward("listFoundSpaces");
            }
            if (campus == null && (labelToSearch == null || StringUtils.isEmpty((String)labelToSearch.trim()))) {
                this.addActionMessage(request, "error.findSpaces.empty.labelToSearch");
                request.setAttribute("bean", (Object)bean);
                return mapping.findForward("listFoundSpaces");
            }
            ArrayList<FindSpacesBean> result = new ArrayList<FindSpacesBean>();
            Set<Space> resultSpaces = SpaceUtils.findSpaces(labelToSearch, campus, building, bean.getSearchType());
            for (Space space : resultSpaces) {
                result.add(new FindSpacesBean(space, bean.getSearchType(), AcademicInterval.readDefaultAcademicInterval(AcademicPeriod.SEMESTER)));
            }
            request.setAttribute("foundSpaces", result);
        }
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("listFoundSpaces");
    }

    public ActionForward searchWithExtraOptions(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FindSpacesBean bean = (FindSpacesBean)this.getRenderedObject("beanWithLabelToSearchID");
        bean.setExtraOptions(true);
        request.setAttribute("bean", (Object)bean);
        RenderUtils.invalidateViewState((String)"beanWithLabelToSearchID");
        return mapping.findForward("listFoundSpaces");
    }

    public ActionForward searchWithoutExtraOptions(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FindSpacesBean bean = (FindSpacesBean)this.getRenderedObject("beanWithLabelToSearchID");
        bean.setExtraOptions(false);
        bean.setCampus(null);
        bean.setBuilding(null);
        request.setAttribute("bean", (Object)bean);
        RenderUtils.invalidateViewState((String)"beanWithLabelToSearchID");
        return mapping.findForward("listFoundSpaces");
    }

    public ActionForward viewSpace(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Space space = this.getSpaceFromParameter(request);
        if (space != null) {
            this.setBlueprintTextRectangles(request, space);
            List containedSpaces = space.getChildren().stream().sorted(SpaceUtils.COMPARATOR_BY_PRESENTATION_NAME).collect(Collectors.toList());
            request.setAttribute("containedSpaces", containedSpaces);
            request.setAttribute("selectedSpace", (Object)new FindSpacesBean(space, AcademicInterval.readDefaultAcademicInterval(AcademicPeriod.SEMESTER)));
        }
        return mapping.findForward("viewSelectedSpace");
    }

    private Boolean isToViewBlueprintNumbers(HttpServletRequest request) {
        String viewBlueprintNumbersString = request.getParameterMap().containsKey("viewBlueprintNumbers") ? request.getParameter("viewBlueprintNumbers") : (String)request.getAttribute("viewBlueprintNumbers");
        return viewBlueprintNumbersString != null ? Boolean.valueOf(viewBlueprintNumbersString) : null;
    }

    private Boolean isToViewOriginalSpaceBlueprint(HttpServletRequest request) {
        String viewOriginalSpaceBlueprintString = request.getParameterMap().containsKey("viewOriginalSpaceBlueprint") ? request.getParameter("viewOriginalSpaceBlueprint") : (String)request.getAttribute("viewOriginalSpaceBlueprint");
        return viewOriginalSpaceBlueprintString != null ? Boolean.valueOf(viewOriginalSpaceBlueprintString) : null;
    }

    private Boolean isToViewSpaceIdentifications(HttpServletRequest request) {
        String viewSpaceIdentificationsString = request.getParameterMap().containsKey("viewSpaceIdentifications") ? request.getParameter("viewSpaceIdentifications") : (String)request.getAttribute("viewSpaceIdentifications");
        return viewSpaceIdentificationsString != null ? Boolean.valueOf(viewSpaceIdentificationsString) : null;
    }

    private Boolean isToViewDoorNumbers(HttpServletRequest request) {
        String viewDoorNumbersString = request.getParameterMap().containsKey("viewDoorNumbers") ? request.getParameter("viewDoorNumbers") : (String)request.getAttribute("viewDoorNumbers");
        return viewDoorNumbersString != null ? Boolean.valueOf(viewDoorNumbersString) : null;
    }

    private BigDecimal getScalePercentage(HttpServletRequest request) {
        String scalePercentageString = request.getParameterMap().containsKey("scalePercentage") ? request.getParameter("scalePercentage") : (String)request.getAttribute("scalePercentage");
        return scalePercentageString != null ? BigDecimal.valueOf(Double.valueOf(scalePercentageString)) : null;
    }

    public ActionForward viewSpaceBlueprint(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean isToViewOriginalSpaceBlueprint = this.isToViewOriginalSpaceBlueprint(request);
        Boolean viewBlueprintNumbers = this.isToViewBlueprintNumbers(request);
        Boolean isToViewIdentifications = this.isToViewSpaceIdentifications(request);
        Boolean isToViewDoorNumbers = this.isToViewDoorNumbers(request);
        BigDecimal scalePercentage = this.getScalePercentage(request);
        DateTime now = new DateTime();
        Space space = (Space)this.getDomainObject(request, "spaceId");
        if (space == null) {
            response.sendError(404);
            return null;
        }
        response.setContentType("text/plain");
        response.setHeader("Content-disposition", "attachment; filename=blueprint.jpeg");
        ServletOutputStream writer = response.getOutputStream();
        SpaceBlueprintsDWGProcessor.writeBlueprint((Space)space, (DateTime)now, (Boolean)isToViewOriginalSpaceBlueprint, (Boolean)viewBlueprintNumbers, (Boolean)isToViewIdentifications, (Boolean)isToViewDoorNumbers, (BigDecimal)scalePercentage, (OutputStream)writer);
        return null;
    }

    private Space getSpaceFromParameter(HttpServletRequest request) {
        Object obj = this.getDomainObject(request, "spaceID");
        return FenixFramework.isDomainObjectValid(obj) && obj instanceof Space ? (Space)obj : null;
    }

    private Space getSuroundingSpaceMostRecentBlueprint(Space space) {
        Optional blueprintFile = space.getBlueprintFile();
        if (blueprintFile.isPresent()) {
            return space;
        }
        if (space.getParent() != null) {
            return this.getSuroundingSpaceMostRecentBlueprint(space.getParent());
        }
        return null;
    }

    private void setBlueprintTextRectangles(HttpServletRequest request, Space space) throws IOException {
        DateTime now = new DateTime();
        Space spaceWithBlueprint = this.getSuroundingSpaceMostRecentBlueprint(space);
        BlueprintFile mostRecentBlueprint = (BlueprintFile)spaceWithBlueprint.getBlueprintFile().get();
        if (mostRecentBlueprint != null) {
            try {
                byte[] blueprintBytes = mostRecentBlueprint.getContent();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(blueprintBytes);
                BlueprintFile.BlueprintTextRectangles blueprintTextRectangles = SpaceBlueprintsDWGProcessor.getBlueprintTextRectangles((InputStream)inputStream, (Space)spaceWithBlueprint, (DateTime)now, (Boolean)false, (Boolean)false, (Boolean)true, (Boolean)false, null);
                request.setAttribute("mostRecentBlueprint", (Object)mostRecentBlueprint);
                request.setAttribute("blueprintTextRectangles", (Object)blueprintTextRectangles);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.sendError(404);
        return null;
    }
}

