/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.publicRelationsOffice;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Alumni;
import org.fenixedu.academic.domain.Formation;
import org.fenixedu.academic.domain.Qualification;
import org.fenixedu.academic.domain.QueueJob;
import org.fenixedu.academic.domain.alumni.AlumniReportFile;
import org.fenixedu.academic.domain.alumni.AlumniReportFileBean;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.util.email.EmailBean;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.dto.alumni.AlumniInfoNotUpdatedBean;
import org.fenixedu.academic.dto.alumni.AlumniMailSendToBean;
import org.fenixedu.academic.dto.alumni.AlumniSearchBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.publicRelationsOffice.PublicRelationsApplication;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=PublicRelationsApplication.PublicRelationsAlumniApp.class, path="search", titleKey="link.search.alumni")
@Mapping(path="/alumni", module="publicRelations")
@Forwards(value={@Forward(name="alumni.showAlumniStatistics", path="/gep/alumni/alumniStatistics.jsp"), @Forward(name="alumni.showAlumniDetails", path="/gep/alumni/alumniDetails.jsp")})
public class AlumniInformationAction
extends FenixDispatchAction {
    private static final String GABINETE_ESTUDOS_PLANEAMENTO = "Gabinete de Estudos e Planeamento";
    private static final String NOT_AVAILABLE = "n/a";

    public ActionForward showAlumniStatistics(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        TreeMap<Long, Integer> registrationsByDay = new TreeMap<Long, Integer>();
        int totalAlumniCount = Bennu.getInstance().getAlumnisSet().size();
        int newAlumniCount = 0;
        int registeredAlumniCount = 0;
        for (Alumni alumni : Bennu.getInstance().getAlumnisSet()) {
            DateTime whenRegistered;
            if (alumni.hasStartedPublicRegistry()) {
                ++newAlumniCount;
            }
            if (alumni.hasFinishedPublicRegistry()) {
                ++registeredAlumniCount;
            }
            if ((whenRegistered = alumni.getRegisteredWhen()) == null) continue;
            long time = whenRegistered.toDateMidnight().getMillis();
            Integer count = (Integer)registrationsByDay.get(time);
            registrationsByDay.put(time, count == null ? 1 : count + 1);
        }
        int jobCount = Bennu.getInstance().getJobsSet().size();
        int formationCount = 0;
        for (Qualification q : Bennu.getInstance().getQualificationsSet()) {
            if (!((Object)((Object)q)).getClass().equals(Formation.class)) continue;
            ++formationCount;
        }
        request.setAttribute("chartData", (Object)this.createJsonArray(registrationsByDay));
        request.setAttribute("statistics1", (Object)RoleType.ALUMNI.actualGroup().getMembers().size());
        request.setAttribute("statistics2", (Object)totalAlumniCount);
        request.setAttribute("statistics3", (Object)newAlumniCount);
        request.setAttribute("statistics4", (Object)registeredAlumniCount);
        request.setAttribute("statistics5", (Object)jobCount);
        request.setAttribute("statistics6", (Object)formationCount);
        request.setAttribute("doneJobs", AlumniReportFile.readDoneJobs());
        request.setAttribute("undoneJobs", AlumniReportFile.readUndoneJobs());
        request.setAttribute("canRequestReport", (Object)AlumniReportFile.canRequestReport());
        return mapping.findForward("alumni.showAlumniStatistics");
    }

    private String createJsonArray(Map<Long, Integer> registrationsByDay) {
        JsonArray data = new JsonArray();
        for (Map.Entry<Long, Integer> entry : registrationsByDay.entrySet()) {
            JsonArray dataEntry = new JsonArray();
            dataEntry.add((JsonElement)new JsonPrimitive((Number)entry.getKey()));
            dataEntry.add((JsonElement)new JsonPrimitive((Number)entry.getValue()));
            data.add((JsonElement)dataEntry);
        }
        return data.toString();
    }

    public ActionForward prepareAddRecipients(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("createRecipient", (Object)new AlumniMailSendToBean());
        request.setAttribute("notUpdatedInfoRecipient", (Object)new AlumniInfoNotUpdatedBean());
        return mapping.findForward("addRecipients");
    }

    public ActionForward prepareRemoveRecipients(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EmailBean emailBean = new EmailBean();
        Set<Sender> availableSenders = Sender.getAvailableSenders();
        for (Sender sender : availableSenders) {
            if (!sender.getFromName().equals(GABINETE_ESTUDOS_PLANEAMENTO)) continue;
            emailBean.setSender(sender);
            break;
        }
        request.setAttribute("emailBean", (Object)emailBean);
        return mapping.findForward("removeRecipients");
    }

    public ActionForward manageRecipients(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Set<Sender> availableSenders = Sender.getAvailableSenders();
        Sender gepSender = this.getGEPSender(availableSenders);
        ArrayList recipients = new ArrayList();
        recipients.addAll(gepSender.getRecipientsSet());
        Collections.sort(recipients, new BeanComparator("toName"));
        Collections.reverse(recipients);
        request.setAttribute("recipients", recipients);
        return mapping.findForward("manageRecipients");
    }

    private Sender getGEPSender(Set<Sender> availableSenders) {
        Sender gepSender = null;
        for (Sender sender : availableSenders) {
            if (!sender.getFromName().equals(GABINETE_ESTUDOS_PLANEAMENTO)) continue;
            gepSender = sender;
            break;
        }
        return gepSender;
    }

    public ActionForward selectDegreeType(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("notUpdatedInfoRecipient", (Object)new AlumniInfoNotUpdatedBean());
        request.setAttribute("createRecipient", this.getRenderedObject("createRecipient"));
        RenderUtils.invalidateViewState();
        return mapping.findForward("addRecipients");
    }

    public ActionForward addRecipients(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AlumniMailSendToBean alumniMailSendToBean = (AlumniMailSendToBean)this.getRenderedObject("createRecipient");
        Sender gepSender = this.getGEPSender(Sender.getAvailableSenders());
        alumniMailSendToBean.createRecipientGroup(gepSender);
        return this.manageRecipients(mapping, actionForm, request, response);
    }

    public ActionForward addNotUpdatedInfoRecipients(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AlumniInfoNotUpdatedBean alumniInfoNotUpdatedBean = (AlumniInfoNotUpdatedBean)this.getRenderedObject("notUpdatedInfoRecipient");
        if (!(alumniInfoNotUpdatedBean.getFormationInfo().booleanValue() || alumniInfoNotUpdatedBean.getProfessionalInfo().booleanValue() || alumniInfoNotUpdatedBean.getPersonalDataInfo().booleanValue())) {
            RenderUtils.invalidateViewState();
            this.addActionMessage(request, "label.alumni.choose.formationOrProfessionalOrPersonal");
            request.setAttribute("notUpdatedInfoRecipient", (Object)alumniInfoNotUpdatedBean);
            request.setAttribute("createRecipient", (Object)new AlumniMailSendToBean());
            return mapping.findForward("addRecipients");
        }
        Sender gepSender = this.getGEPSender(Sender.getAvailableSenders());
        alumniInfoNotUpdatedBean.createRecipientGroup(gepSender);
        return this.manageRecipients(mapping, actionForm, request, response);
    }

    public ActionForward removeRecipients(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        EmailBean emailBean = (EmailBean)this.getRenderedObject("emailBean");
        emailBean.setRecipients(null);
        return this.manageRecipients(mapping, actionForm, request, response);
    }

    public ActionForward generateRegisteredAlumniPartialReport(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        AlumniReportFileBean.launchJob(false, true);
        return this.showAlumniStatistics(mapping, actionForm, request, response);
    }

    public ActionForward generateRegisteredAlumniFullReport(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        AlumniReportFileBean.launchJob(true, true);
        return this.showAlumniStatistics(mapping, actionForm, request, response);
    }

    public ActionForward generateAllAlumni(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        AlumniReportFileBean.launchJob(true, false);
        return this.showAlumniStatistics(mapping, actionForm, request, response);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        QueueJob job = (QueueJob)((Object)this.getDomainObject(request, "jobId"));
        job.cancel();
        return this.showAlumniStatistics(mapping, actionForm, request, response);
    }

    @EntryPoint
    public ActionForward searchAlumni(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IViewState viewState = RenderUtils.getViewState((String)"searchAlumniBean");
        AlumniSearchBean searchBean = viewState != null ? (AlumniSearchBean)viewState.getMetaObject().getObject() : new AlumniSearchBean();
        List<Registration> registrations = Alumni.readRegistrations(searchBean);
        searchBean.setAlumni(new ArrayList<Registration>(registrations));
        ArrayList<AlumniSearchResultItemBean> alumniSearchResultItems = new ArrayList<AlumniSearchResultItemBean>();
        for (Registration registration : registrations) {
            alumniSearchResultItems.add(new AlumniSearchResultItemBean(registration));
        }
        RenderUtils.invalidateViewState();
        request.setAttribute("searchAlumniBean", (Object)searchBean);
        request.setAttribute("alumniResultItems", alumniSearchResultItems);
        return mapping.findForward("alumni.showAlumniDetails");
    }

    public ActionForward searchAlumniError(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("searchAlumniBean", this.getFromRequest(request, "searchAlumniBean"));
        return mapping.findForward("alumni.showAlumniDetails");
    }

    public static class AlumniSearchResultItemBean
    implements Serializable {
        private final Registration registration;

        public AlumniSearchResultItemBean(Registration registration) {
            this.registration = registration;
        }

        public String getName() {
            return this.registration.getPerson().getName();
        }

        public String getDegree() {
            return this.registration.getDegree().getPresentationName();
        }

        public String getStartYear() {
            return this.registration.getStartExecutionYear().getYear();
        }

        public YearMonthDay getConclusionDateForBolonha() {
            return this.registration.getConclusionDateForBolonha();
        }

        public Boolean getActiveAlumni() {
            return this.registration.getStudent().getActiveAlumni();
        }

        public String getEmail() {
            if (this.registration.getPerson().getDefaultEmailAddress() == null) {
                return AlumniInformationAction.NOT_AVAILABLE;
            }
            return this.registration.getPerson().getDefaultEmailAddress().getValue();
        }

        public String getMobilePhone() {
            if (this.registration.getPerson().getDefaultMobilePhone() == null) {
                return AlumniInformationAction.NOT_AVAILABLE;
            }
            return this.registration.getPerson().getDefaultMobilePhone().getNumber();
        }
    }

    @StrutsFunctionality(app=PublicRelationsApplication.PublicRelationsAlumniApp.class, path="statistics", titleKey="title.statistics")
    @Mapping(path="/alumniStatistics", module="publicRelations")
    public static class AlumniStatisticsAction
    extends AlumniInformationAction {
        @Override
        @EntryPoint
        public ActionForward showAlumniStatistics(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
            return super.showAlumniStatistics(mapping, actionForm, request, response);
        }
    }
}

