/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager.accounting.reports;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.QueueJob;
import org.fenixedu.academic.domain.accounting.report.GratuityReportBean;
import org.fenixedu.academic.domain.accounting.report.GratuityReportQueueJob;
import org.fenixedu.academic.domain.accounting.report.GratuityReportQueueJobLaunchService;
import org.fenixedu.academic.domain.accounting.report.events.EventReportQueueJob;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.manager.ManagerApplications;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=ManagerApplications.ManagerPaymentsApp.class, path="gratuity-reports", titleKey="title.gratuity.reports")
@Mapping(path="/gratuityReports", module="manager")
@Forwards(value={@Forward(name="prepare-generate-report", path="/manager/accounting/reports/gratuity/prepareGenerateReport.jsp"), @Forward(name="list-reports", path="/manager/accounting/reports/gratuity/listReports.jsp")})
public class GratuityReportsDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward listReports(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        GratuityReportBean bean = this.getGratuityReportBean();
        if (bean == null) {
            bean = new GratuityReportBean(ExecutionYear.readCurrentExecutionYear());
        }
        RenderUtils.invalidateViewState((String)"gratuity.report.bean");
        request.setAttribute("gratuityReportBean", (Object)bean);
        request.setAttribute("generatedReports", GratuityReportQueueJob.retrieveAllGeneratedReports(bean.getExecutionYear()));
        request.setAttribute("eventReports", EventReportQueueJob.retrieveAllGeneratedReports());
        request.setAttribute("notGeneratedReports", GratuityReportQueueJob.retrieveNotGeneratedReports(bean.getExecutionYear()));
        request.setAttribute("canRequestReportGeneration", (Object)GratuityReportQueueJob.canRequestReportGeneration());
        return mapping.findForward("list-reports");
    }

    private GratuityReportBean getGratuityReportBean() {
        return (GratuityReportBean)this.getRenderedObject("gratuity.report.bean");
    }

    public ActionForward prepareGenerateReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        GratuityReportBean bean = new GratuityReportBean(ExecutionYear.readCurrentExecutionYear());
        request.setAttribute("gratuityReportBean", (Object)bean);
        return mapping.findForward("prepare-generate-report");
    }

    public ActionForward prepareGenerateReportInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        GratuityReportBean bean = this.getGratuityReportBean();
        request.setAttribute("gratuityReportBean", (Object)bean);
        RenderUtils.invalidateViewState((String)"gratuity.report.bean");
        return mapping.findForward("prepare-generate-report");
    }

    public ActionForward generateReportPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        GratuityReportBean bean = this.getGratuityReportBean();
        request.setAttribute("gratuityReportBean", (Object)bean);
        RenderUtils.invalidateViewState((String)"gratuity.report.bean");
        return mapping.findForward("prepare-generate-report");
    }

    public ActionForward generateReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        GratuityReportBean bean = this.getGratuityReportBean();
        GratuityReportQueueJobLaunchService.launchJob(bean);
        return this.listReports(mapping, form, request, response);
    }

    public ActionForward cancelQueueJob(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        QueueJob job = (QueueJob)((Object)this.getDomainObject(request, "queueJobId"));
        job.cancel();
        return this.listReports(mapping, form, request, response);
    }
}

