/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeInfo;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeCoordinatorIndex;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeSiteManagementDispatchAction$CreateCurrentDegreeInfo$callable$run;
import org.fenixedu.academic.ui.struts.action.coordinator.DegreeSiteManagementDispatchAction$callable$updateDegreeCurricularPlanDescription;
import org.fenixedu.academic.ui.struts.action.utils.RequestUtils;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Mapping(module="coordinator", path="/degreeSiteManagement", input="/degreeSiteManagement.do?method=subMenu&page=0", formBean="degreeInfoForm", functionality=DegreeCoordinatorIndex.class)
@Forwards(value={@Forward(name="editOK", path="/coordinator/degreeSite/editOK.jsp"), @Forward(name="viewHistoric", path="/coordinator/degreeSite/viewHistoric.jsp"), @Forward(name="viewInformation", path="/coordinator/degreeSite/viewDegreeInfo.jsp"), @Forward(name="viewDescriptionCurricularPlan", path="/coordinator/degreeSite/viewDescriptionCurricularPlan.jsp")})
public class DegreeSiteManagementDispatchAction
extends FenixDispatchAction {
    public static final Advice advice$updateDegreeCurricularPlanDescription = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DegreeCoordinatorIndex.setCoordinatorContext(request);
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        if (degreeCurricularPlan != null) {
            request.setAttribute("degreeCurricularPlan", (Object)degreeCurricularPlan);
        }
        request.setAttribute("siteUrl", (Object)degreeCurricularPlan.getDegree().getSiteUrl());
        request.setAttribute("siteActionName", (Object)"/degreeSiteManagement.do");
        request.setAttribute("siteContextParam", (Object)"degreeCurricularPlanID");
        request.setAttribute("siteContextParamValue", (Object)degreeCurricularPlan.getExternalId());
        ActionForward forward = super.execute(mapping, actionForm, request, response);
        request.setAttribute("coordinator$actual$page", (Object)forward.getPath());
        return new ActionForward("/degreeSite/siteFrame.jsp");
    }

    public DegreeCurricularPlan getDegreeCurricularPlan(HttpServletRequest request) {
        String parameter = request.getParameter("degreeCurricularPlanID");
        if (parameter == null) {
            return null;
        }
        try {
            return (DegreeCurricularPlan)FenixFramework.getDomainObject((String)parameter);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Unit getUnit(HttpServletRequest request) {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        if (degreeCurricularPlan == null) {
            return null;
        }
        return degreeCurricularPlan.getDegree().getUnit();
    }

    public ActionForward viewInformation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        RequestUtils.getAndSetStringToRequest(request, "info");
        String degreeCurricularPlanID = RequestUtils.getAndSetStringToRequest(request, "degreeCurricularPlanID");
        DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanID);
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        DegreeInfo currentDegreeInfo = currentExecutionYear.getDegreeInfo(degreeCurricularPlan.getDegree());
        if (currentDegreeInfo == null && currentExecutionYear.hasNextExecutionYear()) {
            currentDegreeInfo = currentExecutionYear.getNextExecutionYear().getDegreeInfo(degreeCurricularPlan.getDegree());
        }
        if (currentDegreeInfo == null) {
            if (!Authenticate.getUser().getPerson().isCoordinatorFor(degreeCurricularPlan, currentExecutionYear) && !Authenticate.getUser().getPerson().isCoordinatorFor(degreeCurricularPlan, currentExecutionYear.getNextExecutionYear())) {
                this.addErrorMessage(request, "notAuthorized", "error.exception.notAuthorized2", new Object[0]);
                return new ActionForward(mapping.getInput());
            }
            currentDegreeInfo = CreateCurrentDegreeInfo.run(degreeCurricularPlan.getDegree());
        }
        request.setAttribute("currentDegreeInfo", (Object)currentDegreeInfo);
        return mapping.findForward("viewInformation");
    }

    public ActionForward editDegreeInformation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        RequestUtils.getAndSetStringToRequest(request, "info");
        RequestUtils.getAndSetStringToRequest(request, "degreeCurricularPlanID");
        return mapping.findForward("editOK");
    }

    public ActionForward viewDescriptionCurricularPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String degreeCurricularPlanID = RequestUtils.getAndSetStringToRequest(request, "degreeCurricularPlanID");
        DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanID);
        if (degreeCurricularPlan == null) {
            this.addErrorMessage(request, "noDegreeCurricularPlan", "error.coordinator.chosenDegree", new Object[0]);
            return new ActionForward(mapping.getInput());
        }
        request.setAttribute("degreeCurricularPlan", (Object)degreeCurricularPlan);
        LocalizedString.Builder builder = new LocalizedString.Builder();
        CoreConfiguration.supportedLocales().forEach(l -> {
            if (l.getLanguage().equals("en")) {
                builder.with(l, degreeCurricularPlan.getDescriptionEn());
            } else {
                builder.with(l, degreeCurricularPlan.getDescription());
            }
        });
        LocalizedString degreeCurricularPlanLS = builder.build();
        request.setAttribute("degreeCurricularPlanDescription", (Object)degreeCurricularPlanLS);
        return mapping.findForward("viewDescriptionCurricularPlan");
    }

    public ActionForward editDescriptionDegreeCurricularPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        String degreeCurricularPlanDescription = request.getParameter("degreeCurricularPlanDescription");
        LocalizedString localizedDescription = LocalizedString.fromJson((JsonElement)new JsonParser().parse(degreeCurricularPlanDescription));
        String degreeCurricularPlanDescriptionDef = "";
        String degreeCurricularPlanDescriptionEn = "";
        for (Locale l : CoreConfiguration.supportedLocales()) {
            if (l.getLanguage().equals("en")) {
                degreeCurricularPlanDescriptionEn = localizedDescription.getContent(l);
                continue;
            }
            degreeCurricularPlanDescriptionDef = localizedDescription.getContent(l);
        }
        this.updateDegreeCurricularPlanDescription(degreeCurricularPlanDescriptionDef, degreeCurricularPlan, degreeCurricularPlanDescriptionEn);
        RequestUtils.getAndSetStringToRequest(request, "degreeCurricularPlanID");
        return mapping.findForward("editOK");
    }

    private void updateDegreeCurricularPlanDescription(String string, DegreeCurricularPlan degreeCurricularPlan, String string2) {
        Object object = advice$updateDegreeCurricularPlanDescription.perform((Callable)new DegreeSiteManagementDispatchAction$callable$updateDegreeCurricularPlanDescription(this, string, degreeCurricularPlan, string2));
    }

    static /* synthetic */ void advised$updateDegreeCurricularPlanDescription(DegreeSiteManagementDispatchAction this_, String degreeCurricularPlanDescriptionPt, DegreeCurricularPlan degreeCurricularPlan, String degreeCurricularPlanDescriptionEn) {
        degreeCurricularPlan.setDescription(degreeCurricularPlanDescriptionPt);
        degreeCurricularPlan.setDescriptionEn(degreeCurricularPlanDescriptionEn);
    }

    public ActionForward viewHistoric(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String degreeCurricularPlanID = RequestUtils.getAndSetStringToRequest(request, "degreeCurricularPlanID");
        DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)FenixFramework.getDomainObject((String)degreeCurricularPlanID);
        if (!degreeCurricularPlan.getExecutionDegreesSet().isEmpty()) {
            User userView = Authenticate.getUser();
            request.setAttribute("executionDegrees", userView.getPerson().getCoordinatedExecutionDegrees(degreeCurricularPlan));
        }
        return mapping.findForward("viewHistoric");
    }

    public static class CreateCurrentDegreeInfo {
        public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

        public static DegreeInfo run(Degree degree) {
            return (DegreeInfo)((Object)advice$run.perform((Callable)new DegreeSiteManagementDispatchAction$CreateCurrentDegreeInfo$callable$run(degree)));
        }

        static /* synthetic */ DegreeInfo advised$run(Degree degree) {
            return degree.createCurrentDegreeInfo();
        }
    }
}

