/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.candidacy.erasmus;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityApplicationProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityProgram;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.period.MobilityApplicationPeriod;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.candidacy.CandidacyProcessDA;
import org.fenixedu.academic.ui.struts.action.candidacy.erasmus.ErasmusCandidacyProcessDA$callable$preLoadLastProcessConfigurations;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminCandidaciesApp.class, path="mobility", titleKey="label.application.mobility", accessGroup="(academic(MANAGE_CANDIDACY_PROCESSES) | academic(MANAGE_INDIVIDUAL_CANDIDACIES))")
@Mapping(path="/caseHandlingMobilityApplicationProcess", module="academicAdministration", formBeanClass=ErasmusCandidacyProcessForm.class)
@Forwards(value={@Forward(name="intro", path="/candidacy/erasmus/mainCandidacyProcess.jsp"), @Forward(name="prepare-create-new-process", path="/candidacy/createCandidacyPeriod.jsp"), @Forward(name="prepare-edit-candidacy-period", path="/candidacy/editCandidacyPeriod.jsp"), @Forward(name="view-child-process-with-missing.required-documents", path="/candidacy/erasmus/viewChildProcessesWithMissingRequiredDocuments.jsp"), @Forward(name="view-child-process-with-missing.shifts", path="/candidacy/erasmus/viewChildProcessesWithMissingShifts.jsp")})
public class ErasmusCandidacyProcessDA
extends CandidacyProcessDA {
    public static final Advice advice$preLoadLastProcessConfigurations = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @Override
    public ActionForward prepareCreateNewProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyProcessBean", (Object)new MobilityApplicationProcessBean((ExecutionInterval)((Object)ExecutionYear.readCurrentExecutionYear())));
        return mapping.findForward("prepare-create-new-process");
    }

    @Override
    public ActionForward prepareExecuteEditCandidacyPeriod(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        MobilityApplicationProcess process2;
        MobilityApplicationProcess map = process2 = this.getProcess(request);
        MobilityApplicationProcessBean bean = new MobilityApplicationProcessBean((CandidacyProcess)((Object)process2));
        bean.setForSemester(process2.getForSemester());
        request.setAttribute("candidacyProcessBean", (Object)bean);
        if (!map.getChildProcessesSet().isEmpty()) {
            request.setAttribute("preLoadLevel", (Object)"Error");
        } else if (!map.getCoordinatorsSet().isEmpty() || map.getCandidacyPeriod().getMobilityQuotasSet().size() > 0 || map.getCandidacyPeriod().getEmailTemplatesSet().size() > 0) {
            request.setAttribute("preLoadLevel", (Object)"Warn");
        } else {
            request.setAttribute("preLoadLevel", (Object)"Ok");
        }
        return mapping.findForward("prepare-edit-candidacy-period");
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setChooseDegreeBean(request);
        this.setChooseMobilityProgramBean(request);
        request.setAttribute("chooseDegreeBeanSchemaName", (Object)"ErasmusChooseDegreeBean.selectDegree");
        request.setAttribute("chooseMobilityProgramBeanSchemaName", (Object)"MobilityChooseProgramBean.selectMobilityProgram");
        return super.execute(mapping, actionForm, request, response);
    }

    public ActionForward preLoadLastConfigurations(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        String processEid = request.getParameter("processEid");
        MobilityApplicationProcess process2 = (MobilityApplicationProcess)FenixFramework.getDomainObject((String)processEid);
        this.preLoadLastProcessConfigurations(process2);
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    private void preLoadLastProcessConfigurations(MobilityApplicationProcess mobilityApplicationProcess) {
        Object object = advice$preLoadLastProcessConfigurations.perform((Callable)new ErasmusCandidacyProcessDA$callable$preLoadLastProcessConfigurations(this, mobilityApplicationProcess));
    }

    static /* synthetic */ void advised$preLoadLastProcessConfigurations(ErasmusCandidacyProcessDA this_, MobilityApplicationProcess process2) {
        process2.resetConfigurations();
        process2.preLoadLastConfigurations();
    }

    protected void setChooseMobilityProgramBean(HttpServletRequest request) {
        CandidacyProcessDA.ChooseMobilityProgramBean chooseMobilityProgramBean = (CandidacyProcessDA.ChooseMobilityProgramBean)this.getObjectFromViewState("choose.mobility.program.bean");
        if (chooseMobilityProgramBean == null) {
            chooseMobilityProgramBean = new CandidacyProcessDA.ChooseMobilityProgramBean((CandidacyProcess)((Object)this.getProcess(request)));
            String mobilityProgramEid = request.getParameter("mobilityProgramEid");
            if (mobilityProgramEid != null && !mobilityProgramEid.isEmpty()) {
                MobilityProgram mobilityProgram = (MobilityProgram)FenixFramework.getDomainObject((String)mobilityProgramEid);
                chooseMobilityProgramBean.setMobilityProgram(mobilityProgram);
            }
        }
        request.setAttribute("chooseMobilityProgramBean", (Object)chooseMobilityProgramBean);
    }

    protected CandidacyProcessDA.ChooseMobilityProgramBean getChooseMobilityProgramBean(HttpServletRequest request) {
        return (CandidacyProcessDA.ChooseMobilityProgramBean)request.getAttribute("chooseMobilityProgramBean");
    }

    protected void setChooseDegreeBean(HttpServletRequest request) {
        CandidacyProcessDA.ChooseDegreeBean chooseDegreeBean = (CandidacyProcessDA.ChooseDegreeBean)this.getObjectFromViewState("choose.degree.bean");
        if (chooseDegreeBean == null) {
            chooseDegreeBean = new CandidacyProcessDA.ChooseDegreeBean((CandidacyProcess)((Object)this.getProcess(request)));
            String degreeEid = request.getParameter("degreeEid");
            if (degreeEid != null && !degreeEid.isEmpty()) {
                Degree degree = (Degree)FenixFramework.getDomainObject((String)degreeEid);
                chooseDegreeBean.setDegree(degree);
            }
        }
        request.setAttribute("chooseDegreeBean", (Object)chooseDegreeBean);
    }

    protected CandidacyProcessDA.ChooseDegreeBean getChooseDegreeBean(HttpServletRequest request) {
        return (CandidacyProcessDA.ChooseDegreeBean)request.getAttribute("chooseDegreeBean");
    }

    @Override
    protected Spreadsheet buildIndividualCandidacyReport(Spreadsheet spreadsheet, IndividualCandidacyProcess individualCandidacyProcess) {
        return null;
    }

    @Override
    protected List<CandidacyProcessDA.CandidacyDegreeBean> createCandidacyDegreeBeans(HttpServletRequest request) {
        return null;
    }

    @Override
    protected Class getCandidacyPeriodType() {
        return MobilityApplicationPeriod.class;
    }

    @Override
    protected Class getChildProcessType() {
        return MobilityIndividualApplicationProcess.class;
    }

    @Override
    protected void setStartInformation(ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        if (!this.hasExecutionInterval(request)) {
            ExecutionInterval executionInterval;
            List<MobilityApplicationProcess> candidacyProcesses;
            List<ExecutionInterval> executionIntervals = this.getExecutionIntervalsWithCandidacyPeriod();
            if (executionIntervals.size() == 1 && (candidacyProcesses = this.getCandidacyProcesses(executionInterval = executionIntervals.iterator().next())).size() == 1) {
                this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)candidacyProcesses.iterator().next()));
                this.setCandidacyProcessInformation(actionForm, this.getProcess(request));
                request.setAttribute("candidacyProcesses", candidacyProcesses);
                return;
            }
            request.setAttribute("canCreateProcess", this.canCreateProcess(this.getProcessType().getName()));
            request.setAttribute("executionIntervals", executionIntervals);
        } else {
            ExecutionInterval executionInterval = this.getExecutionInterval(request);
            MobilityApplicationProcess candidacyProcess = this.getCandidacyProcess(request, executionInterval);
            if (candidacyProcess != null) {
                this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)candidacyProcess));
                this.setCandidacyProcessInformation(actionForm, this.getProcess(request));
            } else {
                List<MobilityApplicationProcess> candidacyProcesses = this.getCandidacyProcesses(executionInterval);
                if (candidacyProcesses.size() == 1) {
                    this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)candidacyProcesses.iterator().next()));
                    this.setCandidacyProcessInformation(actionForm, this.getProcess(request));
                    request.setAttribute("candidacyProcesses", candidacyProcesses);
                    return;
                }
                request.setAttribute("canCreateProcess", this.canCreateProcess(this.getProcessType().getName()));
                request.setAttribute("executionIntervals", this.getExecutionIntervalsWithCandidacyPeriod());
            }
            request.setAttribute("candidacyProcesses", this.getCandidacyProcesses(executionInterval));
        }
    }

    protected List<MobilityApplicationProcess> getCandidacyProcesses(ExecutionInterval executionInterval) {
        ArrayList<MobilityApplicationProcess> result = new ArrayList<MobilityApplicationProcess>();
        for (MobilityApplicationPeriod period : executionInterval.getMobilityApplicationPeriods()) {
            result.add(period.getMobilityApplicationProcess());
        }
        return result;
    }

    protected List<ExecutionInterval> getExecutionIntervalsWithCandidacyPeriod() {
        return ExecutionInterval.readExecutionIntervalsWithCandidacyPeriod(this.getCandidacyPeriodType());
    }

    protected MobilityApplicationProcess getCandidacyProcess(HttpServletRequest request, ExecutionInterval executionInterval) {
        String selectedProcessId = this.getStringFromRequest(request, "selectedProcessId");
        if (selectedProcessId != null) {
            for (MobilityApplicationPeriod applicationPeriod : executionInterval.getMobilityApplicationPeriods()) {
                if (!applicationPeriod.getMobilityApplicationProcess().getExternalId().equals(selectedProcessId)) continue;
                return applicationPeriod.getMobilityApplicationProcess();
            }
        }
        return null;
    }

    @Override
    protected Class getProcessType() {
        return MobilityApplicationProcess.class;
    }

    protected void setCandidacyProcessInformation(ActionForm actionForm, MobilityApplicationProcess process2) {
        ErasmusCandidacyProcessForm form = (ErasmusCandidacyProcessForm)actionForm;
        form.setSelectedProcessId(process2.getExternalId());
        form.setExecutionIntervalId(process2.getCandidacyExecutionInterval().getExternalId());
    }

    protected MobilityApplicationProcess getProcess(HttpServletRequest request) {
        return (MobilityApplicationProcess)((Object)super.getProcess(request));
    }

    @Override
    protected Predicate<IndividualCandidacyProcess> getChildProcessSelectionPredicate(CandidacyProcess process2, HttpServletRequest request) {
        final Degree selectedDegree = this.getChooseDegreeBean(request).getDegree();
        final MobilityProgram mobilityProgram = this.getChooseMobilityProgramBean(request).getMobilityProgram();
        if (selectedDegree == null) {
            if (mobilityProgram == null) {
                return Predicates.alwaysTrue();
            }
            return new Predicate<IndividualCandidacyProcess>(){

                public boolean apply(IndividualCandidacyProcess process2) {
                    return ((MobilityIndividualApplicationProcess)((Object)process2)).getMobilityProgram().equals(mobilityProgram);
                }
            };
        }
        return new Predicate<IndividualCandidacyProcess>(){

            public boolean apply(IndividualCandidacyProcess process2) {
                MobilityIndividualApplicationProcess mobilityProcess = (MobilityIndividualApplicationProcess)((Object)process2);
                if (mobilityProgram != null && !mobilityProcess.getMobilityProgram().equals(mobilityProgram)) {
                    return false;
                }
                return ((MobilityIndividualApplicationProcess)((Object)process2)).getCandidacy().getSelectedDegree() == selectedDegree;
            }
        };
    }

    @Override
    protected ActionForward introForward(ActionMapping mapping) {
        return mapping.findForward("intro");
    }

    @Override
    public ActionForward listProcessAllowedActivities(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)this.getProcess(request)));
        this.setCandidacyProcessInformation(form, this.getProcess(request));
        request.setAttribute("candidacyProcesses", this.getCandidacyProcesses((ExecutionInterval)((Object)this.getProcess(request).getCandidacyExecutionInterval())));
        return this.introForward(mapping);
    }

    public ActionForward prepareExecuteViewChildProcessWithMissingRequiredDocumentFiles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)this.getProcess(request)));
        this.setCandidacyProcessInformation(form, this.getProcess(request));
        request.setAttribute("candidacyProcesses", this.getCandidacyProcesses((ExecutionInterval)((Object)this.getProcess(request).getCandidacyExecutionInterval())));
        return mapping.findForward("view-child-process-with-missing.required-documents");
    }

    public ActionForward prepareExecuteViewChildProcessWithMissingShifts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)this.getProcess(request)));
        this.setCandidacyProcessInformation(form, this.getProcess(request));
        List<MobilityApplicationProcess> candidacyProcesses = this.getCandidacyProcesses((ExecutionInterval)((Object)this.getProcess(request).getCandidacyExecutionInterval()));
        request.setAttribute("candidacyProcesses", candidacyProcesses);
        return mapping.findForward("view-child-process-with-missing.shifts");
    }

    public static class MobilityApplicationsMobilityProgramsProvider
    implements DataProvider {
        public Converter getConverter() {
            return new DomainObjectKeyConverter();
        }

        public Object provide(Object arg0, Object arg1) {
            TreeSet<MobilityProgram> mobilityPrograms = new TreeSet<MobilityProgram>(MobilityProgram.COMPARATOR_BY_REGISTRATION_AGREEMENT);
            mobilityPrograms.addAll(Bennu.getInstance().getProgramsSet());
            return mobilityPrograms;
        }
    }

    public static class ErasmusCandidacyDegreesProvider
    implements DataProvider {
        public Object provide(Object source, Object currentValue) {
            ArrayList<Degree> degrees = new ArrayList<Degree>(Degree.readAllMatching(DegreeType.oneOf(DegreeType::isIntegratedMasterDegree, DegreeType::isBolonhaMasterDegree)));
            degrees.remove(Degree.readBySigla("MSCIT"));
            Collections.sort(degrees, Degree.COMPARATOR_BY_DEGREE_TYPE_AND_NAME_AND_ID);
            return degrees;
        }

        public Converter getConverter() {
            return null;
        }
    }

    public static class ErasmusCandidacyProcessForm
    extends CandidacyProcessDA.CandidacyProcessForm {
        private String selectedProcessId;
        private String[] selectedProcesses;

        public String getSelectedProcessId() {
            return this.selectedProcessId;
        }

        public void setSelectedProcessId(String selectedProcessId) {
            this.selectedProcessId = selectedProcessId;
        }

        public String[] getSelectedProcesses() {
            return this.selectedProcesses;
        }

        public void setSelectedProcesses(String[] selectedProcesses) {
            this.selectedProcesses = selectedProcesses;
        }
    }
}

