/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.studentEnrolment.bolonha;

import com.google.common.collect.Sets;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsuranceEvent;
import org.fenixedu.academic.domain.accounting.events.AnnualEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.events.insurance.InsuranceEvent;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleValidationType;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.EnrollmentDomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.student.enrollment.bolonha.ChooseEvaluationSeasonBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.SpecialSeasonBolonhaStudentEnrolmentBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.SpecialSeasonChooseEvaluationSeasonBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.studentEnrolment.bolonha.AcademicAdminOfficeBolonhaStudentEnrollmentDA;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(path="/specialSeasonBolonhaStudentEnrollment", module="academicAdministration", formBean="bolonhaStudentEnrollmentForm", functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="chooseEvaluationSeason", path="/academicAdminOffice/student/enrollment/bolonha/chooseEvaluationSeason.jsp"), @Forward(name="showDegreeModulesToEnrol", path="/academicAdminOffice/student/enrollment/bolonha/showDegreeModulesToEnrol.jsp"), @Forward(name="showStudentEnrollmentMenu", path="/academicAdministration/studentEnrolments.do?method=prepareFromStudentEnrollmentWithRules")})
public class AcademicAdminOfficeSpecialSeasonBolonhaStudentEnrolmentDA
extends AcademicAdminOfficeBolonhaStudentEnrollmentDA {
    @Override
    protected CurricularRuleLevel getCurricularRuleLevel(ActionForm form) {
        return CurricularRuleLevel.SPECIAL_SEASON_ENROLMENT;
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("action", (Object)this.getAction());
        return super.execute(mapping, actionForm, request, response);
    }

    public ActionForward prepareChooseEvaluationSeason(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("chooseEvaluationSeasonBean", (Object)new SpecialSeasonChooseEvaluationSeasonBean());
        request.setAttribute("studentCurricularPlan", (Object)this.getStudentCurricularPlan(request));
        request.setAttribute("executionPeriod", (Object)this.getExecutionPeriod(request));
        return mapping.findForward("chooseEvaluationSeason");
    }

    public ActionForward chooseEvaluationSeasonInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ChooseEvaluationSeasonBean chooseEvaluationSeasonBean = (ChooseEvaluationSeasonBean)this.getRenderedObject("chooseEvaluationSeasonBean");
        request.setAttribute("chooseEvaluationSeasonBean", (Object)chooseEvaluationSeasonBean);
        request.setAttribute("studentCurricularPlan", (Object)this.getStudentCurricularPlan(request));
        request.setAttribute("executionPeriod", (Object)this.getExecutionPeriod(request));
        return mapping.findForward("chooseEvaluationSeason");
    }

    @Override
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ChooseEvaluationSeasonBean chooseEvaluationSeasonBean = (ChooseEvaluationSeasonBean)this.getRenderedObject("chooseEvaluationSeasonBean");
        return this.prepareShowDegreeModulesToEnrol(mapping, form, request, response, this.getStudentCurricularPlan(request), this.getExecutionPeriod(request), chooseEvaluationSeasonBean.getEvaluationSeason());
    }

    public ActionForward checkPermission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ChooseEvaluationSeasonBean chooseEvaluationSeasonBean = (ChooseEvaluationSeasonBean)this.getRenderedObject("chooseEvaluationSeasonBean");
        return this.prepareShowDegreeModulesToEnrol(mapping, form, request, response, this.getStudentCurricularPlan(request), this.getExecutionPeriod(request), chooseEvaluationSeasonBean.getEvaluationSeason());
    }

    @Override
    @Deprecated
    protected ActionForward prepareShowDegreeModulesToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester) {
        throw new RuntimeException("not to be used");
    }

    protected ActionForward prepareShowDegreeModulesToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester, EvaluationSeason evaluationSeason) {
        request.setAttribute("bolonhaStudentEnrollmentBean", (Object)new SpecialSeasonBolonhaStudentEnrolmentBean(studentCurricularPlan, executionSemester, evaluationSeason));
        request.setAttribute("evaluationSeason", (Object)evaluationSeason.getName().getContent());
        request.setAttribute("enroledEctsCredits", (Object)AcademicAdminOfficeSpecialSeasonBolonhaStudentEnrolmentDA.getEnroledEctsCredits(studentCurricularPlan, executionSemester));
        request.setAttribute("enroledExtraEctsCredits", (Object)AcademicAdminOfficeSpecialSeasonBolonhaStudentEnrolmentDA.getEnroledSpecialSeasonEctsCredits(studentCurricularPlan, executionSemester));
        request.setAttribute("label.ects.extra", (Object)BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.ects.special.season", (String[])new String[0]));
        this.addDebtsWarningMessagesForExecutionInterval(studentCurricularPlan.getRegistration().getStudent(), executionSemester.getExecutionYear(), request);
        return mapping.findForward("showDegreeModulesToEnrol");
    }

    private static Double getEnroledEctsCredits(StudentCurricularPlan plan, ExecutionSemester semester) {
        return AcademicAdminOfficeSpecialSeasonBolonhaStudentEnrolmentDA.isEnrolmentByYear(plan) ? plan.getRoot().getEnroledEctsCredits(semester.getExecutionYear()) : plan.getRoot().getEnroledEctsCredits(semester);
    }

    private static Double getEnroledSpecialSeasonEctsCredits(StudentCurricularPlan plan, ExecutionSemester semester) {
        Double result = 0.0;
        HashSet toInspect = Sets.newHashSet();
        if (AcademicAdminOfficeSpecialSeasonBolonhaStudentEnrolmentDA.isEnrolmentByYear(plan)) {
            for (ExecutionSemester iter : semester.getExecutionYear().getExecutionPeriodsSet()) {
                toInspect.addAll(plan.getEnroledSpecialSeasons(iter));
            }
        } else {
            toInspect.addAll(plan.getEnroledSpecialSeasons(semester));
        }
        for (EnrolmentEvaluation enrolmentEvaluation : toInspect) {
            Enrolment enrolment = enrolmentEvaluation.getEnrolment();
            result = result + enrolment.getEctsCredits();
        }
        return result;
    }

    private static boolean isEnrolmentByYear(StudentCurricularPlan plan) {
        return plan.getDegreeCurricularPlan().getCurricularRuleValidationType() == CurricularRuleValidationType.YEAR;
    }

    private void addDebtsWarningMessagesForExecutionInterval(Student student, ExecutionYear executionYear, HttpServletRequest request) {
        if (AcademicAdminOfficeSpecialSeasonBolonhaStudentEnrolmentDA.hasAnyAdministrativeOfficeFeeAndInsuranceInDebt(student, executionYear)) {
            this.addActionMessage("warning", request, "registration.has.not.payed.insurance.fees");
        }
        if (AcademicAdminOfficeSpecialSeasonBolonhaStudentEnrolmentDA.hasAnyGratuityDebt(student, executionYear)) {
            this.addActionMessage("warning", request, "registration.has.not.payed.gratuities");
        }
    }

    protected static boolean hasAnyAdministrativeOfficeFeeAndInsuranceInDebt(Student student, ExecutionYear executionYear) {
        for (Event event : student.getPerson().getEventsSet()) {
            AnnualEvent annualEvent;
            if (event instanceof AnnualEvent && (annualEvent = (AnnualEvent)((Object)event)).getExecutionYear().isAfter(executionYear) || !(event instanceof AdministrativeOfficeFeeAndInsuranceEvent) && !(event instanceof InsuranceEvent) || !event.isOpen()) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasAnyGratuityDebt(Student student, ExecutionYear executionYear) {
        for (Registration registration : student.getRegistrationsSet()) {
            for (StudentCurricularPlan studentCurricularPlan : registration.getStudentCurricularPlansSet()) {
                for (GratuityEvent gratuityEvent : studentCurricularPlan.getGratuityEventsSet()) {
                    if (!gratuityEvent.getExecutionYear().isBeforeOrEquals(executionYear) || !gratuityEvent.isInDebt()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected String getAction() {
        return "/specialSeasonBolonhaStudentEnrollment.do";
    }

    @Override
    public ActionForward enrolInDegreeModules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        SpecialSeasonBolonhaStudentEnrolmentBean bolonhaStudentEnrollmentBean = (SpecialSeasonBolonhaStudentEnrolmentBean)this.getBolonhaStudentEnrollmentBeanFromViewState();
        try {
            StudentCurricularPlan studentCurricularPlan = bolonhaStudentEnrollmentBean.getStudentCurricularPlan();
            RuleResult ruleResults = studentCurricularPlan.enrol(bolonhaStudentEnrollmentBean.getExecutionPeriod(), new HashSet<IDegreeModuleToEvaluate>(bolonhaStudentEnrollmentBean.getDegreeModulesToEvaluate()), bolonhaStudentEnrollmentBean.getCurriculumModulesToRemove(), bolonhaStudentEnrollmentBean.getCurricularRuleLevel(), bolonhaStudentEnrollmentBean.getEvaluationSeason());
            if (!bolonhaStudentEnrollmentBean.getDegreeModulesToEvaluate().isEmpty() || !bolonhaStudentEnrollmentBean.getCurriculumModulesToRemove().isEmpty()) {
                this.addActionMessage("success", request, "label.save.success");
            }
            if (ruleResults.isWarning()) {
                this.addRuleResultMessagesToActionMessages("warning", request, ruleResults);
            }
            this.enroledWithSuccess(request, bolonhaStudentEnrollmentBean);
        }
        catch (EnrollmentDomainException ex) {
            this.addRuleResultMessagesToActionMessages("error", request, ex.getFalseResult());
            return this.prepareShowDegreeModulesToEnrol(mapping, form, request, response, bolonhaStudentEnrollmentBean);
        }
        catch (DomainException ex) {
            this.addActionMessage("error", request, ex.getKey(), ex.getArgs());
            return this.prepareShowDegreeModulesToEnrol(mapping, form, request, response, bolonhaStudentEnrollmentBean);
        }
        RenderUtils.invalidateViewState();
        return this.prepareShowDegreeModulesToEnrol(mapping, form, request, response, bolonhaStudentEnrollmentBean.getStudentCurricularPlan(), bolonhaStudentEnrollmentBean.getExecutionPeriod(), bolonhaStudentEnrollmentBean.getEvaluationSeason());
    }
}

