/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.scholarship.utl.report;

import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.scholarship.utl.report.ReportStudentsUTLCandidatesForOneStudent;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.scholarship.utl.report.StudentLine;
import org.fenixedu.academic.util.Money;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportStudentsUTLCandidatesForOneStudentFirstYear
extends ReportStudentsUTLCandidatesForOneStudent {
    private static final Logger logger = LoggerFactory.getLogger(ReportStudentsUTLCandidatesForOneStudentFirstYear.class);

    public ReportStudentsUTLCandidatesForOneStudentFirstYear(ExecutionYear forExecutionYear, Student student) {
        super(forExecutionYear, student);
    }

    @Override
    protected void addValues(HSSFSheet sheet) {
        int i = 2;
        for (StudentLine studentLine : this.getCorrectStudentLines()) {
            try {
                String institutionCode = studentLine.getInstitutionCode();
                String institutionName = studentLine.getInstitutionName();
                String candidacyNumber = studentLine.getCandidacyNumber();
                String studentNumberForPrint = studentLine.getStudentNumberForPrint();
                String studentName = studentLine.getStudentName();
                String documentTypeName = studentLine.getDocumentTypeName();
                String documentNumber = studentLine.getDocumentNumber();
                String degreeCode = studentLine.getDegreeCode();
                String degreeName = studentLine.getDegreeName();
                String degreeTypeName = studentLine.getDegreeTypeName();
                String regime = studentLine.getRegime();
                Integer countNumberOfEnrolmentsYearsSinceRegistrationStart = studentLine.getCountNumberOfEnrolmentsYearsSinceRegistrationStart();
                Integer numberOfDegreeCurricularYears = studentLine.getNumberOfDegreeCurricularYears();
                Double numberOfEnrolledECTS = studentLine.getNumberOfEnrolledECTS();
                Money gratuityAmount = studentLine.getGratuityAmount();
                Integer numberOfMonthsExecutionYear = studentLine.getNumberOfMonthsExecutionYear();
                String firstMonthOfPayment = studentLine.getFirstMonthOfPayment();
                Boolean ownerOfCETQualification = studentLine.getOwnerOfCETQualification();
                boolean degreeQualificationOwner = studentLine.isDegreeQualificationOwner();
                boolean masterQualificationOwner = studentLine.isMasterQualificationOwner();
                boolean phdQualificationOwner = studentLine.isPhdQualificationOwner();
                boolean ownerOfCollegeQualification = studentLine.isOwnerOfCollegeQualification();
                String observations = studentLine.getObservations();
                String nif = studentLine.getNif();
                LocalDate firstEnrolmentOnCurrentExecutionYear = studentLine.getFirstEnrolmentOnCurrentExecutionYear();
                HSSFRow row = sheet.createRow(i);
                this.addCellValue(row, this.onNullEmptyString(institutionCode), 0);
                this.addCellValue(row, this.onNullEmptyString(institutionName), 1);
                this.addCellValue(row, this.onNullEmptyString(candidacyNumber), 2);
                this.addCellValue(row, this.onNullEmptyString(studentNumberForPrint), 3);
                this.addCellValue(row, this.onNullEmptyString(studentName), 4);
                this.addCellValue(row, this.onNullEmptyString(documentTypeName), 5);
                this.addCellValue(row, this.onNullEmptyString(documentNumber), 6);
                this.addCellValue(row, this.onNullEmptyString(degreeCode), 7);
                this.addCellValue(row, this.onNullEmptyString(degreeName), 8);
                this.addCellValue(row, this.onNullEmptyString(degreeTypeName), 9);
                this.addCellValue(row, this.onNullEmptyString(firstEnrolmentOnCurrentExecutionYear), 10);
                this.addCellValue(row, this.onNullEmptyString(gratuityAmount != null ? gratuityAmount.toPlainString().replace('.', ',') : ""), 11);
                this.addCellValue(row, this.onNullEmptyString(numberOfMonthsExecutionYear), 12);
                this.addCellValue(row, this.onNullEmptyString(firstMonthOfPayment), 13);
                this.addCellValue(row, this.onNullEmptyString(ownerOfCETQualification), 14);
                this.addCellValue(row, this.onNullEmptyString(degreeQualificationOwner), 15);
                this.addCellValue(row, this.onNullEmptyString(masterQualificationOwner), 16);
                this.addCellValue(row, this.onNullEmptyString(phdQualificationOwner), 17);
                this.addCellValue(row, this.onNullEmptyString(ownerOfCollegeQualification), 18);
                this.addCellValue(row, this.onNullEmptyString(observations), 19);
                this.addCellValue(row, this.onNullEmptyString(regime), 20);
                this.addCellValue(row, this.onNullEmptyString(numberOfDegreeCurricularYears), 21);
                this.addCellValue(row, this.onNullEmptyString(countNumberOfEnrolmentsYearsSinceRegistrationStart), 22);
                this.addCellValue(row, this.onNullEmptyString(numberOfEnrolledECTS != null ? numberOfEnrolledECTS.toString().replace('.', ',') : ""), 23);
                this.addCellValue(row, this.onNullEmptyString(nif), 24);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            ++i;
        }
    }

    @Override
    protected void addHeaders(HSSFSheet sheet) {
        sheet.createRow(0);
        sheet.createRow(1);
        this.addHeaderCell(sheet, this.getHeaderInBundle("institutionCode"), 0);
        this.addHeaderCell(sheet, this.getHeaderInBundle("institutionName"), 1);
        this.addHeaderCell(sheet, this.getHeaderInBundle("candidacyNumber"), 2);
        this.addHeaderCell(sheet, this.getHeaderInBundle("studentNumberForPrint"), 3);
        this.addHeaderCell(sheet, this.getHeaderInBundle("studentName"), 4);
        this.addHeaderCell(sheet, this.getHeaderInBundle("documentTypeName"), 5);
        this.addHeaderCell(sheet, this.getHeaderInBundle("documentNumber"), 6);
        this.addHeaderCell(sheet, this.getHeaderInBundle("degreeCode"), 7);
        this.addHeaderCell(sheet, this.getHeaderInBundle("degreeName"), 8);
        this.addHeaderCell(sheet, this.getHeaderInBundle("degreeTypeName"), 9);
        this.addHeaderCell(sheet, this.getHeaderInBundle("firstEnrolmentOnCurrentExecutionYear"), 10);
        this.addHeaderCell(sheet, this.getHeaderInBundle("gratuityAmount"), 11);
        this.addHeaderCell(sheet, this.getHeaderInBundle("numberOfMonthsExecutionYear"), 12);
        this.addHeaderCell(sheet, this.getHeaderInBundle("firstMonthOfPayment"), 13);
        this.addHeaderCell(sheet, this.getHeaderInBundle("ownerOfCETQualification"), 14);
        this.addHeaderCell(sheet, this.getHeaderInBundle("degreeQualificationOwner"), 15);
        this.addHeaderCell(sheet, this.getHeaderInBundle("masterQualificationOwner"), 16);
        this.addHeaderCell(sheet, this.getHeaderInBundle("phdQualificationOwner"), 17);
        this.addHeaderCell(sheet, this.getHeaderInBundle("ownerOfCollegeQualification"), 18);
        this.addHeaderCell(sheet, this.getHeaderInBundle("observations"), 19);
        this.addHeaderCell(sheet, this.getHeaderInBundle("regime"), 20);
        this.addHeaderCell(sheet, this.getHeaderInBundle("numberOfDegreeCurricularYears"), 21);
        this.addHeaderCell(sheet, this.getHeaderInBundle("ingression.year.on.cycle.studies.count"), 22);
        this.addHeaderCell(sheet, this.getHeaderInBundle("numberOfEnrolledECTS"), 23);
        this.addHeaderCell(sheet, this.getHeaderInBundle("nif"), 24);
    }
}

