/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.Summary;
import org.fenixedu.academic.dto.SummariesManagementBean;
import org.fenixedu.academic.util.DateFormatUtil;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class SummaryPlainRenderer
extends OutputRenderer {
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            public HtmlComponent createComponent(Object object, Class type) {
                if (object == null) {
                    return new HtmlText();
                }
                Summary summary = (Summary)((Object)object);
                StringBuilder builder = new StringBuilder();
                Lesson lesson = null;
                builder.append(summary.getSummaryDateYearMonthDay().getDayOfMonth()).append("/");
                builder.append(summary.getSummaryDateYearMonthDay().getMonthOfYear()).append("/");
                builder.append(summary.getSummaryDateYearMonthDay().getYear());
                builder.append(" - ").append(RenderUtils.getResourceString((String)"DEFAULT", (String)"label.lesson") + ": ");
                if (summary.isExtraSummary()) {
                    builder.append(RenderUtils.getEnumString((Enum)SummariesManagementBean.SummaryType.EXTRA_SUMMARY, null)).append(" ");
                    builder.append(" (").append(summary.getSummaryHourHourMinuteSecond().getHour());
                    builder.append(":").append(summary.getSummaryHourHourMinuteSecond().getMinuteOfHour()).append(") ");
                } else {
                    lesson = summary.getLesson();
                    if (lesson != null) {
                        builder.append(lesson.getDiaSemana().toString()).append(" (");
                        builder.append(DateFormatUtil.format("HH:mm", lesson.getInicio().getTime()));
                        builder.append("-").append(DateFormatUtil.format("HH:mm", lesson.getFim().getTime()));
                        builder.append(") ");
                    }
                }
                if (lesson != null && lesson.hasSala()) {
                    builder.append(lesson.getSala().getName());
                }
                return new HtmlText(builder.toString());
            }
        };
    }
}

