/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.bolonhaManager.competenceCourses;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.faces.component.UISelectItems;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CompetenceCourseType;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degreeStructure.BibliographicReferences;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformation;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLevel;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLoad;
import org.fenixedu.academic.domain.degreeStructure.CurricularStage;
import org.fenixedu.academic.domain.degreeStructure.RegimeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.CompetenceCourseGroupUnit;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.domain.organizationalStructure.ScientificAreaUnit;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.dto.bolonhaManager.CourseLoad;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.service.services.bolonhaManager.CreateCompetenceCourse;
import org.fenixedu.academic.service.services.bolonhaManager.DeleteCompetenceCourse;
import org.fenixedu.academic.service.services.bolonhaManager.EditCompetenceCourse;
import org.fenixedu.academic.service.services.bolonhaManager.EditCompetenceCourseLoad;
import org.fenixedu.academic.service.services.exceptions.ExistingCompetenceCourseInformationException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.ui.faces.bean.base.FenixBackingBean;
import org.fenixedu.academic.ui.faces.bean.bolonhaManager.competenceCourses.CompetenceCourseManagementBackingBean$callable$addUserToGroup;
import org.fenixedu.academic.ui.faces.bean.bolonhaManager.competenceCourses.CompetenceCourseManagementBackingBean$callable$removeUsersFromGroup;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.groups.NobodyGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CompetenceCourseManagementBackingBean
extends FenixBackingBean {
    private final Integer NO_SELECTION = 0;
    private String selectedDepartmentUnitID = null;
    private String competenceCourseID = null;
    private String executionYearID = null;
    private String executionSemesterID = null;
    private Unit competenceCourseGroupUnit = null;
    private CompetenceCourse competenceCourse = null;
    private String code;
    private String name;
    private String nameEn;
    private String acronym;
    private Boolean basic;
    private boolean setNumberOfPeriods = true;
    private String objectives;
    private String program;
    private String evaluationMethod;
    private String objectivesEn;
    private String programEn;
    private String evaluationMethodEn;
    private String stage;
    private Integer bibliographicReferenceID;
    private String year;
    private String title;
    private String author;
    private String reference;
    private String type;
    private String url;
    private String newGroupMember;
    private String[] selectedGroupMembersToDelete;
    private Boolean groupEditMode;
    private UISelectItems departmentUnitItems;
    private UISelectItems scientificAreaUnitItems;
    private UISelectItems competenceCourseGroupUnitItems;
    private UISelectItems competenceCourseExecutionSemesters;
    private UISelectItems executionSemesterItems;
    private UISelectItems futureExecutionSemesterItems;
    private List<SelectItem> selectedYears = null;
    public static final Advice advice$addUserToGroup = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$removeUsersFromGroup = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public String[] getSelectedGroupMembersToDelete() {
        return this.selectedGroupMembersToDelete;
    }

    public Boolean getGroupEditMode() {
        if (this.groupEditMode == null) {
            String requestParameter = this.getRequestParameter("groupEditMode");
            this.setGroupEditMode("true".equals(requestParameter));
        }
        return this.groupEditMode;
    }

    public void setGroupEditMode(Boolean groupEditMode) {
        this.groupEditMode = groupEditMode;
    }

    public void toggleGroupEditMode() {
        this.setGroupEditMode(this.getGroupEditMode() == false);
    }

    public void setSelectedGroupMembersToDelete(String[] selectedGroupMembersToDelete) {
        this.selectedGroupMembersToDelete = selectedGroupMembersToDelete;
    }

    public String getNewGroupMember() {
        return this.newGroupMember == null ? (this.newGroupMember = this.getAndHoldStringParameter("newGroupMember")) : this.newGroupMember;
    }

    public void setNewGroupMember(String newGroupMember) {
        this.newGroupMember = newGroupMember;
    }

    public String getAction() {
        return this.getAndHoldStringParameter("action");
    }

    public String getCompetenceCoursesToList() {
        return this.getAndHoldStringParameter("competenceCoursesToList");
    }

    public Boolean getCanView() {
        DepartmentUnit selectedDepartmentUnit = this.getSelectedDepartmentUnit();
        if (selectedDepartmentUnit == null) {
            return this.getPersonDepartment() != null && this.getPersonDepartment().getCompetenceCourseMembersGroup() != null ? this.getPersonDepartment().getCompetenceCourseMembersGroup().isMember(this.getUserView()) : false;
        }
        return selectedDepartmentUnit.getDepartment().getCompetenceCourseMembersGroup() != null ? selectedDepartmentUnit.getDepartment().getCompetenceCourseMembersGroup().isMember(this.getUserView()) : false;
    }

    public Department getPersonDepartment() {
        User user = Authenticate.getUser();
        return Bennu.getInstance().getDepartmentsSet().stream().filter(dep -> dep.getCompetenceCourseMembersGroup().isMember(user)).findAny().orElse(null);
    }

    public Department getDepartmentToDisplay() {
        if (this.getSelectedDepartmentUnit() != null) {
            return this.getSelectedDepartmentUnit().getDepartment();
        }
        return this.getPersonDepartment();
    }

    public DepartmentUnit getSelectedDepartmentUnit() {
        if (this.getSelectedDepartmentUnitID() != null) {
            return (DepartmentUnit)FenixFramework.getDomainObject((String)this.getSelectedDepartmentUnitID());
        }
        return null;
    }

    public List<ScientificAreaUnit> getScientificAreaUnits() {
        DepartmentUnit departmentUnit = null;
        if (this.getSelectedDepartmentUnit() != null) {
            departmentUnit = this.getSelectedDepartmentUnit();
        } else if (this.getPersonDepartment() != null) {
            departmentUnit = this.getPersonDepartment().getDepartmentUnit();
        }
        return departmentUnit != null ? departmentUnit.getScientificAreaUnits() : null;
    }

    public List<CompetenceCourse> getDepartmentCompetenceCourses(CurricularStage curricularStage) {
        DepartmentUnit selectedDepartmentUnit = this.getSelectedDepartmentUnit();
        if (selectedDepartmentUnit != null) {
            return selectedDepartmentUnit.getCompetenceCourses(curricularStage);
        }
        return new ArrayList<CompetenceCourse>();
    }

    public List<CompetenceCourse> getDepartmentCompetenceCourses() {
        return this.getDepartmentCompetenceCourses(CurricularStage.valueOf(this.getCompetenceCoursesToList()));
    }

    public List<CompetenceCourse> getDepartmentDraftCompetenceCourses() {
        return this.getDepartmentCompetenceCourses(CurricularStage.DRAFT);
    }

    public List<CompetenceCourse> getDepartmentPublishedCompetenceCourses() {
        return this.getDepartmentCompetenceCourses(CurricularStage.PUBLISHED);
    }

    public List<CompetenceCourse> getDepartmentApprovedCompetenceCourses() {
        return this.getDepartmentCompetenceCourses(CurricularStage.APPROVED);
    }

    public List<String> getGroupMembersLabels() {
        return this.getGroupMembers().stream().map(SelectItem::getLabel).collect(Collectors.toList());
    }

    public List<SelectItem> getGroupMembers() {
        ArrayList<Object> result = new ArrayList<SelectItem>();
        if (this.getSelectedDepartmentUnit() == null || this.getSelectedDepartmentUnit().getDepartment() == null || this.getSelectedDepartmentUnit().getDepartment().getCompetenceCourseMembersGroup() == null) {
            return result;
        }
        Group competenceCoursesManagementGroup = this.getSelectedDepartmentUnit().getDepartment().getCompetenceCourseMembersGroup();
        if (competenceCoursesManagementGroup != null) {
            result = new ArrayList();
            for (User user : competenceCoursesManagementGroup.getMembers()) {
                result.add(new SelectItem((Object)user.getExternalId(), user.getPerson().getName() + " (" + user.getUsername() + ")"));
            }
        }
        return result;
    }

    private boolean isUserMemberOfAnyCurricularPlanGroup(User user) {
        return Degree.readBolonhaDegrees().stream().flatMap(d -> d.getDegreeCurricularPlansSet().stream()).map(dcp -> dcp.getCurricularPlanMembersGroup()).reduce((Group)NobodyGroup.get(), (g1, g2) -> g1.or(g2)).isMember(user);
    }

    private boolean isUserMemberOfAnyDepartmentCompetenceCourseGroup(User user) {
        return Bennu.getInstance().getDepartmentsSet().stream().filter(d -> !d.equals((Object)this.getSelectedDepartmentUnit().getDepartment())).anyMatch(d -> d.getCompetenceCourseMembersGroup().isMember(user));
    }

    private void removeRoleIfNecessary(User user) {
        if (!this.isUserMemberOfAnyCurricularPlanGroup(user) && !this.isUserMemberOfAnyDepartmentCompetenceCourseGroup(user)) {
            RoleType.revoke(RoleType.BOLONHA_MANAGER, user);
        }
    }

    public void addUserToGroup() {
        Object object = advice$addUserToGroup.perform((Callable)new CompetenceCourseManagementBackingBean$callable$addUserToGroup(this));
    }

    static /* synthetic */ void advised$addUserToGroup(CompetenceCourseManagementBackingBean this_) {
        User user;
        if (this_.getNewGroupMember() != null && (user = User.findByUsername((String)this_.getNewGroupMember())) != null) {
            Group group = this_.getSelectedDepartmentUnit().getDepartment().getCompetenceCourseMembersGroup();
            this_.getSelectedDepartmentUnit().getDepartment().setCompetenceCourseMembersGroup(group.grant(user));
            RoleType.grant(RoleType.BOLONHA_MANAGER, user);
        }
    }

    public void removeUsersFromGroup(ActionEvent actionEvent) {
        Object object = advice$removeUsersFromGroup.perform((Callable)new CompetenceCourseManagementBackingBean$callable$removeUsersFromGroup(this, actionEvent));
    }

    static /* synthetic */ void advised$removeUsersFromGroup(CompetenceCourseManagementBackingBean this_, ActionEvent event) {
        if (this_.selectedGroupMembersToDelete != null && this_.selectedGroupMembersToDelete.length > 0) {
            Department department = this_.getSelectedDepartmentUnit().getDepartment();
            Group group = department.getCompetenceCourseMembersGroup();
            for (String userExternalId : this_.selectedGroupMembersToDelete) {
                User user = (User)FenixFramework.getDomainObject((String)userExternalId);
                if (user == null) continue;
                group = group.revoke(user);
                this_.removeRoleIfNecessary(user);
            }
            department.setCompetenceCourseMembersGroup(group);
        }
    }

    public String getCompetenceCourseGroupUnitID() {
        return this.getAndHoldStringParameter("competenceCourseGroupUnitID");
    }

    public Unit getCompetenceCourseGroupUnit() {
        if (this.competenceCourseGroupUnit == null && this.getCompetenceCourseGroupUnitID() != null) {
            this.competenceCourseGroupUnit = (Unit)FenixFramework.getDomainObject((String)this.getCompetenceCourseGroupUnitID());
        }
        return this.competenceCourseGroupUnit;
    }

    public String getName() {
        if (this.name == null && this.getCompetenceCourse() != null) {
            this.name = this.getCompetenceCourse().getName(this.getAssociatedExecutionPeriod());
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        if (this.code == null && this.getCompetenceCourse() != null) {
            this.code = this.getCompetenceCourse().getCode();
        }
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getNameEn() {
        if (this.nameEn == null && this.getCompetenceCourse() != null) {
            this.nameEn = this.getCompetenceCourse().getNameEn(this.getAssociatedExecutionPeriod());
        }
        return this.nameEn;
    }

    public void setNameEn(String nameEn) {
        this.nameEn = nameEn;
    }

    public String getAcronym() {
        if (this.acronym == null && this.getCompetenceCourse() != null) {
            this.acronym = this.getCompetenceCourse().getAcronym(this.getAssociatedExecutionPeriod());
        }
        return this.acronym;
    }

    public void setAcronym(String acronym) {
        this.acronym = acronym;
    }

    public Boolean getBasic() {
        if (this.basic == null && this.getCompetenceCourse() != null) {
            this.basic = this.getCompetenceCourse().isBasic(this.getAssociatedExecutionPeriod());
        }
        return this.basic;
    }

    public void setBasic(Boolean basic) {
        this.basic = basic;
    }

    public String getRegime() {
        if (this.getViewState().getAttribute("regime") == null) {
            if (this.getCompetenceCourse() != null) {
                ExecutionYear executionYear = this.getExecutionYear();
                this.setRegime(this.getCompetenceCourse().getRegime(this.getAssociatedExecutionPeriod()).getName());
            } else {
                this.setRegime("SEMESTRIAL");
            }
        }
        return (String)this.getViewState().getAttribute("regime");
    }

    public void setRegime(String regime) {
        this.getViewState().setAttribute("regime", regime);
    }

    public String getCompetenceCourseLevel() {
        if (StringUtils.isEmpty((String)((String)this.getViewState().getAttribute("competenceCourseLevel"))) && this.getCompetenceCourse() != null && this.getCompetenceCourse().getCompetenceCourseLevel(this.getAssociatedExecutionPeriod()) != null) {
            this.setCompetenceCourseLevel(this.getCompetenceCourse().getCompetenceCourseLevel(this.getAssociatedExecutionPeriod()).getName());
        }
        return (String)this.getViewState().getAttribute("competenceCourseLevel");
    }

    public void setCompetenceCourseLevel(String competenceCourseLevel) {
        this.getViewState().setAttribute("competenceCourseLevel", competenceCourseLevel);
    }

    public String getCompetenceCourseType() {
        if (this.getViewState().getAttribute("competenceCourseType") == null && this.getCompetenceCourse() != null && this.getCompetenceCourse().getType() != null) {
            this.setCompetenceCourseType(this.getCompetenceCourse().getType().name());
        }
        return (String)this.getViewState().getAttribute("competenceCourseType");
    }

    public void setCompetenceCourseType(String competenceCourseType) {
        this.getViewState().setAttribute("competenceCourseType", competenceCourseType);
    }

    public Integer getNumberOfPeriods() {
        if (this.getViewState().getAttribute("numberOfPeriods") == null) {
            if (this.getCompetenceCourse() != null && this.getCompetenceCourse().getCompetenceCourseLoads().size() > 0) {
                this.setNumberOfPeriods(this.getCompetenceCourse().getCompetenceCourseLoads(this.getAssociatedExecutionPeriod()).size());
            } else {
                this.setNumberOfPeriods(1);
            }
        }
        return (Integer)this.getViewState().getAttribute("numberOfPeriods");
    }

    public void setNumberOfPeriods(Integer numberOfPeriods) {
        if (this.setNumberOfPeriods) {
            this.getViewState().setAttribute("numberOfPeriods", numberOfPeriods);
        }
    }

    public List<SelectItem> getPeriods() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>(2);
        result.add(new SelectItem((Object)2, BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"yes", (String[])new String[0])));
        result.add(new SelectItem((Object)1, BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"no", (String[])new String[0])));
        return result;
    }

    public List<CourseLoad> getCourseLoads() {
        if (this.getViewState().getAttribute("courseLoads") == null) {
            if (this.getAction().equals("create")) {
                this.getViewState().setAttribute("courseLoads", this.createNewCourseLoads());
            } else if (this.getAction().equals("edit") && this.getCompetenceCourse() != null) {
                this.getViewState().setAttribute("courseLoads", this.getExistingCourseLoads());
            }
        }
        return (List)this.getViewState().getAttribute("courseLoads");
    }

    private List<CourseLoad> createNewCourseLoads() {
        int numberOfPeriods = this.getNumberOfPeriods();
        ArrayList<CourseLoad> courseLoads = new ArrayList<CourseLoad>(numberOfPeriods);
        for (int i = 0; i < numberOfPeriods; ++i) {
            courseLoads.add(new CourseLoad(i + 1));
        }
        return courseLoads;
    }

    private List<CourseLoad> getExistingCourseLoads() {
        ArrayList<CourseLoad> courseLoads = new ArrayList<CourseLoad>(this.getCompetenceCourse().getCompetenceCourseLoadsCount());
        for (CompetenceCourseLoad competenceCourseLoad : this.getCompetenceCourse().getSortedCompetenceCourseLoads()) {
            courseLoads.add(new CourseLoad("edit", competenceCourseLoad));
        }
        if (courseLoads.isEmpty()) {
            courseLoads.add(new CourseLoad(1));
        }
        return courseLoads;
    }

    public void setCourseLoads(List<CourseLoad> courseLoads) {
        this.getViewState().setAttribute("courseLoads", courseLoads);
    }

    public void resetCourseLoad(ValueChangeEvent event) {
        this.calculateCourseLoad((String)event.getNewValue(), 1);
    }

    public void resetCorrespondentCourseLoad(ValueChangeEvent event) {
        this.calculateCourseLoad(this.getRegime(), (Integer)event.getNewValue());
    }

    private void calculateCourseLoad(String regime, int newNumberOfPeriods) {
        List<CourseLoad> courseLoads = this.getCourseLoads();
        if (regime.equals("ANUAL")) {
            if (newNumberOfPeriods > this.getNumberOfPeriods()) {
                this.addCourseLoad(courseLoads);
            } else {
                this.removeCourseLoad(courseLoads);
            }
        } else if (regime.equals("SEMESTRIAL")) {
            this.removeCourseLoad(courseLoads);
            this.setNumberOfPeriods(1);
            this.setNumberOfPeriods = false;
        }
        this.setCourseLoads(courseLoads);
    }

    private void addCourseLoad(List<CourseLoad> courseLoads) {
        if (this.getAction().equals("create")) {
            courseLoads.add(new CourseLoad(courseLoads.size() + 1));
        } else if (this.getAction().equals("edit")) {
            CourseLoad courseLoad = this.searchDeletedCourseLoad(courseLoads);
            if (courseLoad != null) {
                courseLoad.setAction("edit");
            } else {
                courseLoads.add(new CourseLoad(courseLoads.size() + 1));
            }
        }
    }

    private CourseLoad searchDeletedCourseLoad(List<CourseLoad> courseLoads) {
        for (CourseLoad courseLoad : courseLoads) {
            if (!courseLoad.getAction().equals("delete")) continue;
            return courseLoad;
        }
        return null;
    }

    private void removeCourseLoad(List<CourseLoad> courseLoads) {
        if (this.getAction().equals("create") && courseLoads.size() > 1) {
            courseLoads.remove(courseLoads.size() - 1);
        } else if (this.getAction().equals("edit") && courseLoads.size() > 1) {
            courseLoads.get(courseLoads.size() - 1).setAction("delete");
        }
    }

    public String getSelectedDepartmentUnitID() {
        if (this.selectedDepartmentUnitID == null) {
            if (this.getAndHoldStringParameter("selectedDepartmentUnitID") != null) {
                this.selectedDepartmentUnitID = this.getAndHoldStringParameter("selectedDepartmentUnitID");
            } else if (this.getPersonDepartment() != null) {
                this.selectedDepartmentUnitID = this.getPersonDepartment().getDepartmentUnit().getExternalId();
            }
        }
        return this.selectedDepartmentUnitID;
    }

    public void setSelectedDepartmentUnitID(String selectedDepartmentUnitID) {
        this.selectedDepartmentUnitID = selectedDepartmentUnitID;
    }

    public String getCompetenceCourseID() {
        return this.competenceCourseID == null ? (this.competenceCourseID = this.getAndHoldStringParameter("competenceCourseID")) : this.competenceCourseID;
    }

    public void setCompetenceCourseID(String competenceCourseID) {
        this.competenceCourseID = competenceCourseID;
    }

    public CompetenceCourse getCompetenceCourse() {
        if (this.competenceCourse == null && this.getCompetenceCourseID() != null) {
            this.competenceCourse = (CompetenceCourse)FenixFramework.getDomainObject((String)this.getCompetenceCourseID());
        }
        return this.competenceCourse;
    }

    public void setCompetenceCourse(CompetenceCourse competenceCourse) {
        this.competenceCourse = competenceCourse;
    }

    public ExecutionSemester getAssociatedExecutionPeriod() {
        return this.getExecutionSemester();
    }

    public String getObjectives() {
        if (this.objectives == null && this.getCompetenceCourse() != null) {
            this.objectives = this.getCompetenceCourse().getObjectives(this.getAssociatedExecutionPeriod());
        }
        return this.objectives;
    }

    public void setObjectives(String objectives) {
        this.objectives = objectives;
    }

    public String getProgram() {
        if (this.program == null && this.getCompetenceCourse() != null) {
            this.program = this.getCompetenceCourse().getProgram(this.getAssociatedExecutionPeriod());
        }
        return this.program;
    }

    public void setProgram(String program) {
        this.program = program;
    }

    public String getEvaluationMethod() {
        if (this.evaluationMethod == null && this.getCompetenceCourse() != null) {
            this.evaluationMethod = this.getCompetenceCourse().getEvaluationMethod(this.getAssociatedExecutionPeriod());
        }
        return this.evaluationMethod;
    }

    public void setEvaluationMethod(String evaluationMethod) {
        this.evaluationMethod = evaluationMethod;
    }

    public String getObjectivesEn() {
        if (this.objectivesEn == null && this.getCompetenceCourse() != null) {
            this.objectivesEn = this.getCompetenceCourse().getObjectivesEn(this.getAssociatedExecutionPeriod());
        }
        return this.objectivesEn;
    }

    public void setObjectivesEn(String objectivesEn) {
        this.objectivesEn = objectivesEn;
    }

    public String getProgramEn() {
        if (this.programEn == null && this.getCompetenceCourse() != null) {
            this.programEn = this.getCompetenceCourse().getProgramEn(this.getAssociatedExecutionPeriod());
        }
        return this.programEn;
    }

    public void setProgramEn(String programEn) {
        this.programEn = programEn;
    }

    public String getEvaluationMethodEn() {
        if (this.evaluationMethodEn == null && this.getCompetenceCourse() != null) {
            this.evaluationMethodEn = this.getCompetenceCourse().getEvaluationMethodEn(this.getAssociatedExecutionPeriod());
        }
        return this.evaluationMethodEn;
    }

    public void setEvaluationMethodEn(String evaluationMethodEn) {
        this.evaluationMethodEn = evaluationMethodEn;
    }

    public String getStage() {
        if (this.stage == null && this.getCompetenceCourse() != null) {
            this.stage = this.getCompetenceCourse().getCurricularStage().name();
        }
        return this.stage;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    public Integer getBibliographicReferenceID() {
        return this.bibliographicReferenceID == null ? (this.bibliographicReferenceID = this.getAndHoldIntegerParameter("bibliographicReferenceID")) : this.bibliographicReferenceID;
    }

    public void setBibliographicReferenceID(Integer bibliographicReferenceID) {
        this.bibliographicReferenceID = bibliographicReferenceID;
    }

    public String getYear() {
        if (this.year == null && this.getCompetenceCourse() != null && this.getBibliographicReferenceID() != null) {
            this.year = this.getCompetenceCourse().getBibliographicReference(this.getBibliographicReferenceID()).getYear();
        }
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getTitle() {
        if (this.title == null && this.getCompetenceCourse() != null && this.getBibliographicReferenceID() != null) {
            this.title = this.getCompetenceCourse().getBibliographicReference(this.getBibliographicReferenceID()).getTitle();
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAuthor() {
        if (this.author == null && this.getCompetenceCourse() != null && this.getBibliographicReferenceID() != null) {
            this.author = this.getCompetenceCourse().getBibliographicReference(this.getBibliographicReferenceID()).getAuthors();
        }
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getReference() {
        if (this.reference == null && this.getCompetenceCourse() != null && this.getBibliographicReferenceID() != null) {
            this.reference = this.getCompetenceCourse().getBibliographicReference(this.getBibliographicReferenceID()).getReference();
        }
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getType() {
        if (this.type == null && this.getCompetenceCourse() != null && this.getBibliographicReferenceID() != null) {
            this.type = this.getCompetenceCourse().getBibliographicReference(this.getBibliographicReferenceID()).getType().getName();
        }
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUrl() {
        if (this.url == null && this.getCompetenceCourse() != null && this.getBibliographicReferenceID() != null) {
            this.url = this.getCompetenceCourse().getBibliographicReference(this.getBibliographicReferenceID()).getUrl();
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<CompetenceCourseLoad> getSortedCompetenceCourseLoads() {
        return this.getCompetenceCourse().getSortedCompetenceCourseLoads(this.getAssociatedExecutionPeriod());
    }

    public List<BibliographicReferences.BibliographicReference> getMainBibliographicReferences() {
        ArrayList<BibliographicReferences.BibliographicReference> result = new ArrayList<BibliographicReferences.BibliographicReference>();
        if (this.getBibliographicReferences() == null) {
            return result;
        }
        for (BibliographicReferences.BibliographicReference bibliographicReference : this.getBibliographicReferences()) {
            if (!bibliographicReference.getType().equals((Object)BibliographicReferences.BibliographicReferenceType.MAIN)) continue;
            result.add(bibliographicReference);
        }
        return result;
    }

    public List<BibliographicReferences.BibliographicReference> getSecondaryBibliographicReferences() {
        ArrayList<BibliographicReferences.BibliographicReference> result = new ArrayList<BibliographicReferences.BibliographicReference>();
        if (this.getBibliographicReferences() == null) {
            return result;
        }
        for (BibliographicReferences.BibliographicReference bibliographicReference : this.getBibliographicReferences()) {
            if (!bibliographicReference.getType().equals((Object)BibliographicReferences.BibliographicReferenceType.SECONDARY)) continue;
            result.add(bibliographicReference);
        }
        return result;
    }

    private List<BibliographicReferences.BibliographicReference> getBibliographicReferences() {
        return this.getCompetenceCourse().getBibliographicReferences(this.getAssociatedExecutionPeriod()) == null ? null : this.getCompetenceCourse().getBibliographicReferences(this.getAssociatedExecutionPeriod()).getBibliographicReferencesList();
    }

    public int getBibliographicReferencesCount() {
        return this.getBibliographicReferences() != null ? this.getBibliographicReferences().size() : 0;
    }

    private CompetenceCourseLevel getEnumCompetenceCourseLevel() {
        return this.getCompetenceCourseLevel() == null || this.getCompetenceCourseLevel().length() == 0 ? null : CompetenceCourseLevel.valueOf(this.getCompetenceCourseLevel());
    }

    private CompetenceCourseType getEnumCompetenceCourseType() {
        String value = this.getCompetenceCourseType();
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return CompetenceCourseType.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private boolean isCompetenceCourseLevelValid() {
        return this.getEnumCompetenceCourseLevel() != null;
    }

    private boolean isCompetenceCourseTypeValid() {
        return this.getEnumCompetenceCourseType() != null;
    }

    public String createCompetenceCourse() {
        try {
            boolean valid = true;
            if (!this.isCompetenceCourseLevelValid()) {
                valid = false;
                this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.mustSetCompetenceCourseLevel", (String[])new String[0]));
            }
            if (!this.isCompetenceCourseTypeValid()) {
                valid = false;
                this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.mustSetCompetenceCourseType", (String[])new String[0]));
            }
            if (valid) {
                CompetenceCourse competenceCourse = CreateCompetenceCourse.run(this.getName(), this.getNameEn(), null, this.getBasic(), RegimeType.SEMESTRIAL, this.getEnumCompetenceCourseLevel(), this.getEnumCompetenceCourseType(), this.getCompetenceCourseGroupUnitID(), this.getExecutionSemester(), this.getCode());
                this.setCompetenceCourse(competenceCourse);
                return "setCompetenceCourseLoad";
            }
        }
        catch (IllegalDataAccessException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.creatingCompetenceCourse", (String[])new String[0]));
        }
        catch (ExistingCompetenceCourseInformationException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getKey(), (String[])e.getArgs()));
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        return "";
    }

    public String createCompetenceCourseLoad() {
        try {
            this.setCompetenceCourseLoad();
            return "setCompetenceCourseAdditionalInformation";
        }
        catch (NotAuthorizedException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.editingCompetenceCourse", (String[])new String[0]));
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        return "";
    }

    public String createCompetenceCourseAdditionalInformation() {
        try {
            this.setCompetenceCourseAdditionalInformation();
            return "competenceCoursesManagement";
        }
        catch (NotAuthorizedException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.editingCompetenceCourse", (String[])new String[0]));
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        return "";
    }

    public String editCompetenceCourse() {
        try {
            if (this.isCompetenceCourseLevelValid()) {
                EditCompetenceCourse.runEditCompetenceCourse(this.getCompetenceCourseID(), this.getName(), this.getNameEn(), this.getBasic(), this.getEnumCompetenceCourseLevel(), this.getEnumCompetenceCourseType(), CurricularStage.valueOf(this.getStage()), this.getCode());
                return "editCompetenceCourseMainPage";
            }
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.mustSetCompetenceCourseLevel", (String[])new String[0]));
        }
        catch (NotAuthorizedException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.editingCompetenceCourse", (String[])new String[0]));
        }
        catch (ExistingCompetenceCourseInformationException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getKey(), (String[])e.getArgs()));
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
        }
        return "";
    }

    public String editCompetenceCourseLoad() {
        try {
            this.setCompetenceCourseLoad();
            return "editCompetenceCourseMainPage";
        }
        catch (NotAuthorizedException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.editingCompetenceCourse", (String[])new String[0]));
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        return "";
    }

    public String editCompetenceCourseAdditionalInformation() {
        try {
            this.setCompetenceCourseAdditionalInformation();
            return "editCompetenceCourseMainPage";
        }
        catch (NotAuthorizedException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.editingCompetenceCourse", (String[])new String[0]));
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        return "";
    }

    private void setCompetenceCourseLoad() throws FenixServiceException {
        EditCompetenceCourseLoad.run(this.getCompetenceCourseID(), RegimeType.valueOf(this.getRegime()), this.getNumberOfPeriods(), this.getCourseLoads());
    }

    private void setCompetenceCourseAdditionalInformation() throws FenixServiceException {
        EditCompetenceCourse.runEditCompetenceCourse(this.getCompetenceCourseID(), this.getObjectives(), this.getProgram(), this.getEvaluationMethod(), this.getObjectivesEn(), this.getProgramEn(), this.getEvaluationMethodEn());
    }

    public String deleteCompetenceCourse() {
        try {
            DeleteCompetenceCourse.run(this.getCompetenceCourseID());
            this.addInfoMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"competenceCourseDeleted", (String[])new String[0]));
            return "competenceCoursesManagement";
        }
        catch (IllegalDataAccessException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.deletingCompetenceCourse", (String[])new String[0]));
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
        }
        return "";
    }

    public String createBibliographicReference() {
        try {
            EditCompetenceCourse.runEditCompetenceCourse(this.getCompetenceCourseID(), this.getYear(), this.getTitle(), this.getAuthor(), this.getReference(), BibliographicReferences.BibliographicReferenceType.valueOf(this.getType()), this.getUrl());
        }
        catch (NotAuthorizedException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.creatingBibliographicReference", (String[])new String[0]));
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(e.getMessage());
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
        }
        this.setBibliographicReferenceID(-1);
        return "";
    }

    public String editBibliographicReference() {
        try {
            EditCompetenceCourse.runEditCompetenceCourse(this.getCompetenceCourseID(), this.getBibliographicReferenceID(), this.getYear(), this.getTitle(), this.getAuthor(), this.getReference(), BibliographicReferences.BibliographicReferenceType.valueOf(this.getType()), this.getUrl());
        }
        catch (NotAuthorizedException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.editingBibliographicReference", (String[])new String[0]));
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(e.getMessage());
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
        }
        this.setBibliographicReferenceID(-1);
        return "";
    }

    public Integer getBibliographicReferenceIDToDelete() {
        return this.getAndHoldIntegerParameter("bibliographicReferenceIDToDelete");
    }

    public String deleteBibliographicReference() {
        try {
            EditCompetenceCourse.runEditCompetenceCourse(this.getCompetenceCourseID(), this.getBibliographicReferenceIDToDelete());
        }
        catch (NotAuthorizedException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.deletingBibliographicReference", (String[])new String[0]));
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(e.getMessage());
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
        }
        this.setBibliographicReferenceID(-1);
        return "";
    }

    public Integer getOldPosition() {
        return this.getAndHoldIntegerParameter("oldPosition");
    }

    public Integer getNewPosition() {
        return this.getAndHoldIntegerParameter("newPosition");
    }

    public String switchBibliographicReferencePosition() {
        try {
            EditCompetenceCourse.runEditCompetenceCourse(this.getCompetenceCourseID(), this.getOldPosition(), this.getNewPosition());
        }
        catch (NotAuthorizedException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.switchBibliographicReferencePositions", (String[])new String[0]));
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
        }
        this.setBibliographicReferenceID(-1);
        return "";
    }

    public String cancelBibliographicReference() {
        this.setBibliographicReferenceID(-1);
        return "";
    }

    public String changeCompetenceCourseState() {
        try {
            CurricularStage changed = this.getCompetenceCourse().getCurricularStage().equals((Object)CurricularStage.PUBLISHED) ? CurricularStage.APPROVED : CurricularStage.PUBLISHED;
            EditCompetenceCourse.runEditCompetenceCourse(this.getCompetenceCourseID(), changed);
            return "";
        }
        catch (NotAuthorizedException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.editingCompetenceCourse", (String[])new String[0]));
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
        }
        return "";
    }

    public String getDepartmentRealName() {
        return this.getCompetenceCourse().getDepartmentUnit(this.getExecutionSemester()).getDepartment().getRealName();
    }

    public String getScientificAreaUnitName() {
        return this.getCompetenceCourse().getScientificAreaUnit(this.getExecutionSemester()).getName();
    }

    public String getCompetenceCourseGroupUnitName() {
        return this.getCompetenceCourse().getCompetenceCourseGroupUnit(this.getExecutionSemester()).getName();
    }

    public UISelectItems getDepartmentUnitItems() {
        if (this.departmentUnitItems == null) {
            this.departmentUnitItems = new UISelectItems();
            this.departmentUnitItems.setValue(this.readDepartmentUnitLabels());
        }
        return this.departmentUnitItems;
    }

    public void setDepartmentUnitItems(UISelectItems departmentUnitItems) {
        this.departmentUnitItems = departmentUnitItems;
    }

    public void onChangeDepartmentUnit(ValueChangeEvent event) {
        this.setTransferToDepartmentUnitID((String)event.getNewValue());
        this.getScientificAreaUnitItems().setValue(this.readScientificAreaUnitLabels((String)event.getNewValue()));
        this.getCompetenceCourseGroupUnitItems().setValue(this.readCompetenceCourseGroupUnitLabels(null));
    }

    private List<SelectItem> readDepartmentUnitLabels() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (Department departmentObject : Bennu.getInstance().getDepartmentsSet()) {
            DepartmentUnit departmentUnit = departmentObject.getDepartmentUnit();
            if (!departmentUnit.isActive(this.getExecutionSemester().getBeginDateYearMonthDay())) continue;
            result.add(new SelectItem((Object)departmentUnit.getExternalId(), departmentUnit.getName()));
        }
        Collections.sort(result, new BeanComparator("label"));
        result.add(0, new SelectItem((Object)this.NO_SELECTION, BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"choose", (String[])new String[0])));
        return result;
    }

    public UISelectItems getScientificAreaUnitItems() {
        if (this.scientificAreaUnitItems == null) {
            this.scientificAreaUnitItems = new UISelectItems();
            this.scientificAreaUnitItems.setValue(this.readScientificAreaUnitLabels(this.getTransferToDepartmentUnitID()));
        }
        return this.scientificAreaUnitItems;
    }

    public void setScientificAreaUnitItems(UISelectItems scientificAreaUnitItems) {
        this.scientificAreaUnitItems = scientificAreaUnitItems;
    }

    public void onChangeScientificAreaUnit(ValueChangeEvent event) {
        this.setTransferToScientificAreaUnitID((String)event.getNewValue());
        this.getCompetenceCourseGroupUnitItems().setValue(this.readCompetenceCourseGroupUnitLabels((String)event.getNewValue()));
    }

    private List<SelectItem> readScientificAreaUnitLabels(String transferToDepartmentUnitID) {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        if (transferToDepartmentUnitID != null) {
            for (ScientificAreaUnit unit : this.readDepartmentUnitToTransferTo(transferToDepartmentUnitID).getScientificAreaUnits()) {
                result.add(new SelectItem((Object)unit.getExternalId(), unit.getName()));
            }
        }
        Collections.sort(result, new BeanComparator("label"));
        result.add(0, new SelectItem((Object)this.NO_SELECTION, BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"choose", (String[])new String[0])));
        return result;
    }

    public String getTransferToDepartmentUnitID() {
        if (this.getViewState().getAttribute("transferToDepartmentUnitID") != null) {
            return (String)this.getViewState().getAttribute("transferToDepartmentUnitID");
        }
        return null;
    }

    public void setTransferToDepartmentUnitID(String transferToDepartmentUnitID) {
        this.getViewState().setAttribute("transferToDepartmentUnitID", transferToDepartmentUnitID);
    }

    private DepartmentUnit readDepartmentUnitToTransferTo(String transferToDepartmentUnitID) {
        return (DepartmentUnit)FenixFramework.getDomainObject((String)transferToDepartmentUnitID);
    }

    public UISelectItems getCompetenceCourseGroupUnitItems() {
        if (this.competenceCourseGroupUnitItems == null) {
            this.competenceCourseGroupUnitItems = new UISelectItems();
            this.competenceCourseGroupUnitItems.setValue(this.readCompetenceCourseGroupUnitLabels(this.getTransferToScientificAreaUnitID()));
        }
        return this.competenceCourseGroupUnitItems;
    }

    public void setCompetenceCourseGroupUnitItems(UISelectItems competenceCourseGroupUnitItems) {
        this.competenceCourseGroupUnitItems = competenceCourseGroupUnitItems;
    }

    private List<SelectItem> readCompetenceCourseGroupUnitLabels(String transferToScientificAreaUnitID) {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        if (transferToScientificAreaUnitID != null) {
            for (Unit unit : this.readScientificAreaUnitToTransferTo(transferToScientificAreaUnitID).getCompetenceCourseGroupUnits()) {
                result.add(new SelectItem((Object)unit.getExternalId(), unit.getName()));
            }
        }
        Collections.sort(result, new BeanComparator("label"));
        result.add(0, new SelectItem((Object)this.NO_SELECTION, BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"choose", (String[])new String[0])));
        return result;
    }

    public String getTransferToScientificAreaUnitID() {
        if (this.getViewState().getAttribute("transferToScientificAreaUnitID") != null) {
            return (String)this.getViewState().getAttribute("transferToScientificAreaUnitID");
        }
        return null;
    }

    public void setTransferToScientificAreaUnitID(String transferToScientificAreaUnitID) {
        this.getViewState().setAttribute("transferToScientificAreaUnitID", transferToScientificAreaUnitID);
    }

    private ScientificAreaUnit readScientificAreaUnitToTransferTo(String transferToScientificAreaUnitID) {
        return (ScientificAreaUnit)FenixFramework.getDomainObject((String)transferToScientificAreaUnitID);
    }

    public String transferCompetenceCourse() {
        AccessControl.check(this, RolePredicates.SCIENTIFIC_COUNCIL_PREDICATE);
        try {
            if (this.getCompetenceCourse() == null || this.readCompetenceCourseGroupUnitToTransferTo() == null || this.getExecutionSemester() == null) {
                this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"error.transferingCompetenceCourse", (String[])new String[0]));
                return "competenceCoursesManagement";
            }
            FenixFramework.atomic(() -> this.getCompetenceCourse().transfer((CompetenceCourseGroupUnit)((Object)((Object)((Object)this.readCompetenceCourseGroupUnitToTransferTo()))), this.getExecutionSemester(), BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"transfer.done.by.scientific.council", (String[])new String[0]), AccessControl.getPerson()));
        }
        catch (IllegalDataAccessException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)"error.notAuthorized", (String[])new String[0]));
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])new String[0]));
        }
        return "competenceCoursesManagement";
    }

    private Unit readCompetenceCourseGroupUnitToTransferTo() {
        if (this.getTransferToCompetenceCourseGroupUnitID() != null) {
            return (Unit)FenixFramework.getDomainObject((String)this.getTransferToCompetenceCourseGroupUnitID());
        }
        return null;
    }

    public String getTransferToCompetenceCourseGroupUnitID() {
        if (this.getViewState().getAttribute("transferToCompetenceCourseGroupUnitID") != null) {
            return (String)this.getViewState().getAttribute("transferToCompetenceCourseGroupUnitID");
        }
        return null;
    }

    public void setTransferToCompetenceCourseGroupUnitID(String transferToCompetenceCourseGroupUnitID) {
        this.getViewState().setAttribute("transferToCompetenceCourseGroupUnitID", transferToCompetenceCourseGroupUnitID);
    }

    private ExecutionSemester getExecutionSemester() {
        return (ExecutionSemester)FenixFramework.getDomainObject((String)this.getExecutionSemesterID());
    }

    public String getExecutionSemesterID() {
        if (this.executionSemesterID == null) {
            this.executionSemesterID = (String)this.getViewState().getAttribute("executionSemesterID");
        }
        ExecutionSemester currentSemester = ExecutionSemester.readActualExecutionSemester();
        if (this.executionSemesterID == null && this.getCompetenceCourse() != null && this.getCompetenceCourse().getCompetenceCourseInformationsSet().size() == 1) {
            this.executionSemesterID = ((CompetenceCourseInformation)((Object)this.getCompetenceCourse().getCompetenceCourseInformationsSet().iterator().next())).getExecutionPeriod().getExternalId();
        }
        if (this.executionSemesterID == null) {
            this.executionSemesterID = currentSemester.getExternalId();
        }
        return this.executionSemesterID;
    }

    public void setExecutionSemesterID(String executionSemesterID) {
        this.executionSemesterID = executionSemesterID;
        this.reset();
    }

    public ExecutionYear getExecutionYear() {
        return (ExecutionYear)FenixFramework.getDomainObject((String)this.getExecutionYearID());
    }

    public String getExecutionYearID() {
        if (this.executionYearID == null) {
            this.executionYearID = this.getAndHoldStringParameter("executionYearID");
        }
        if (this.executionYearID == null) {
            this.executionYearID = ExecutionYear.readCurrentExecutionYear().getExternalId();
        }
        return this.executionYearID;
    }

    public void setExecutionYearID(String executionYearID) {
        this.executionYearID = executionYearID;
        this.reset();
    }

    public UISelectItems getExecutionSemesterItems() {
        if (this.executionSemesterItems == null) {
            this.executionSemesterItems = new UISelectItems();
            this.executionSemesterItems.setValue(this.readExecutionSemesterLabels());
        }
        return this.executionSemesterItems;
    }

    public void setExecutionSemesterItems(UISelectItems executionSemesterItems) {
    }

    private List<SelectItem> readExecutionSemesterLabels() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (ExecutionSemester semester : this.getOrderedCompetenceCourseExecutionSemesters()) {
            result.add(new SelectItem((Object)semester.getExternalId(), semester.getQualifiedName()));
        }
        return result;
    }

    public UISelectItems getFutureExecutionSemesterItems() {
        if (this.futureExecutionSemesterItems == null) {
            this.futureExecutionSemesterItems = new UISelectItems();
            this.futureExecutionSemesterItems.setValue(this.readFutureExecutionSemesterLabels());
        }
        return this.futureExecutionSemesterItems;
    }

    public void setFutureExecutionSemesterItems(UISelectItems futureExecutionSemesterItems) {
        this.futureExecutionSemesterItems = futureExecutionSemesterItems;
    }

    private List<SelectItem> readFutureExecutionSemesterLabels() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (ExecutionSemester semester = ExecutionSemester.readActualExecutionSemester(); semester != null; semester = semester.getNextExecutionPeriod()) {
            result.add(new SelectItem((Object)semester.getExternalId(), semester.getQualifiedName()));
        }
        return result;
    }

    public UISelectItems getCompetenceCourseExecutionSemesters() {
        if (this.competenceCourseExecutionSemesters == null) {
            this.competenceCourseExecutionSemesters = new UISelectItems();
            this.competenceCourseExecutionSemesters.setValue(this.readCompetenceCourseExecutionSemesterLabels());
        }
        return this.competenceCourseExecutionSemesters;
    }

    public void setCompetenceCourseExecutionSemesters(UISelectItems competenceCourseExecutionSemesters) {
        this.competenceCourseExecutionSemesters = competenceCourseExecutionSemesters;
    }

    private List<SelectItem> readCompetenceCourseExecutionSemesterLabels() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (ExecutionSemester semester : this.getOrderedCompetenceCourseExecutionSemesters()) {
            result.add(new SelectItem((Object)semester.getExternalId(), semester.getQualifiedName()));
        }
        return result;
    }

    private TreeSet<ExecutionSemester> getOrderedCompetenceCourseExecutionSemesters() {
        TreeSet<ExecutionSemester> result = new TreeSet<ExecutionSemester>(ExecutionSemester.COMPARATOR_BY_SEMESTER_AND_YEAR);
        ExecutionSemester semester = this.getCompetenceCourse().getStartExecutionSemester();
        result.add(semester);
        while (semester.hasNextExecutionPeriod()) {
            semester = semester.getNextExecutionPeriod();
            result.add(semester);
        }
        return result;
    }

    public String editAcronym() {
        try {
            EditCompetenceCourse.runEditCompetenceCourse(this.getCompetenceCourseID(), this.getAcronym());
            return "editCompetenceCourseMainPage";
        }
        catch (NotAuthorizedException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"error.editingCompetenceCourse", (String[])new String[0]));
        }
        catch (FenixServiceException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)e.getMessage(), (String[])new String[0]));
        }
        catch (DomainException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.DomainExceptionResources", (String)e.getMessage(), (String[])e.getArgs()));
        }
        return "";
    }

    public List<SelectItem> getExecutionYears() {
        if (this.selectedYears == null) {
            ExecutionYear year = null;
            if (this.getCompetenceCourse() != null) {
                ExecutionSemester semester = this.getCompetenceCourse().getStartExecutionSemester();
                year = semester != null ? semester.getExecutionYear() : null;
            }
            this.selectedYears = new ArrayList<SelectItem>();
            for (ExecutionYear executionYear : ExecutionYear.readNotClosedExecutionYears()) {
                if (year != null && !executionYear.isAfterOrEquals(year)) continue;
                this.selectedYears.add(new SelectItem((Object)executionYear.getExternalId(), executionYear.getYear()));
            }
            Collections.sort(this.selectedYears, new ReverseComparator((Comparator)new BeanComparator("label")));
        }
        return this.selectedYears;
    }

    private void reset() {
        this.name = null;
        this.nameEn = null;
        this.acronym = null;
        this.basic = null;
        this.objectives = null;
        this.program = null;
        this.evaluationMethod = null;
        this.objectivesEn = null;
        this.programEn = null;
        this.evaluationMethodEn = null;
        this.stage = null;
        this.bibliographicReferenceID = null;
    }
}

