/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.accounting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.events.AnnualEvent;
import org.fenixedu.academic.domain.accounting.paymentCodes.AccountingEventPaymentCode;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.degreeChange.DegreeChangeCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.degreeTransfer.DegreeTransferCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPersonProcess;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleCandidacyProcess;
import org.fenixedu.bennu.core.presentationTier.renderers.autoCompleteProvider.AutoCompleteProvider;
import pt.ist.fenixframework.FenixFramework;

public class SearchPaymentCodesByExecutionYear
implements AutoCompleteProvider<PaymentCode> {
    public Collection<PaymentCode> getSearchResults(Map<String, String> argsMap, String value, int maxCount) {
        ExecutionYear executionYear = this.getExecutionYear(argsMap.get("executionYearOid"));
        Collection<PaymentCode> result = this.findAnnualEventsPaymentCodeFor(value, executionYear);
        result.addAll(this.findIndividualCandidaciesEventPaymentCodesFor(DegreeTransferCandidacyProcess.class, value, executionYear));
        result.addAll(this.findIndividualCandidaciesEventPaymentCodesFor(DegreeChangeCandidacyProcess.class, value, executionYear));
        result.addAll(this.findIndividualCandidaciesEventPaymentCodesFor(SecondCycleCandidacyProcess.class, value, executionYear));
        result.addAll(this.findIndividualCandidaciesEventPaymentCodesFor(DegreeCandidacyForGraduatedPersonProcess.class, value, executionYear));
        result.addAll(this.findIndividualCandidaciesEventPaymentCodesFor(DegreeTransferCandidacyProcess.class, value, executionYear));
        return result;
    }

    private Collection<PaymentCode> findIndividualCandidaciesEventPaymentCodesFor(Class<? extends CandidacyProcess> candidacyProcessClazz, String paymentCodeValue, ExecutionYear executionYear) {
        CandidacyProcess candidacyProcessByExecutionInterval = CandidacyProcess.getCandidacyProcessByExecutionInterval(candidacyProcessClazz, (ExecutionInterval)((Object)executionYear));
        ArrayList<PaymentCode> result = new ArrayList<PaymentCode>();
        if (candidacyProcessByExecutionInterval == null) {
            return result;
        }
        Set childProcesses = candidacyProcessByExecutionInterval.getChildProcessesSet();
        for (IndividualCandidacyProcess individualCandidacyProcess : childProcesses) {
            if (individualCandidacyProcess.getCandidacy().getEvent() == null || individualCandidacyProcess.getCandidacy().getEvent().getAllPaymentCodes().isEmpty()) continue;
            for (PaymentCode paymentCode : individualCandidacyProcess.getCandidacy().getEvent().getAllPaymentCodes()) {
                if (!paymentCode.getCode().startsWith(paymentCodeValue)) continue;
                result.add(paymentCode);
            }
        }
        return result;
    }

    private Collection<PaymentCode> findAnnualEventsPaymentCodeFor(String paymentCodeValue, ExecutionYear executionYear) {
        ArrayList<PaymentCode> result = new ArrayList<PaymentCode>();
        for (AnnualEvent event : executionYear.getAnnualEventsSet()) {
            for (AccountingEventPaymentCode code : event.getAllPaymentCodes()) {
                if (!code.getCode().startsWith(paymentCodeValue)) continue;
                result.add((PaymentCode)((Object)code));
            }
        }
        return result;
    }

    private ExecutionYear getExecutionYear(String oid) {
        return (ExecutionYear)FenixFramework.getDomainObject((String)oid);
    }
}

