/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.filter.enrollment;

import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeCurricularPlanEquivalencePlan;
import org.fenixedu.academic.domain.EnrolmentPeriod;
import org.fenixedu.academic.domain.EnrolmentPeriodInClassesCandidate;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.bennu.core.security.Authenticate;

public class ClassEnrollmentAuthorizationFilter {
    public static final ClassEnrollmentAuthorizationFilter instance = new ClassEnrollmentAuthorizationFilter();
    private static ConcurrentLinkedQueue<ClassEnrollmentCondition> conditions = new ConcurrentLinkedQueue();

    public static void registerCondition(ClassEnrollmentCondition condition) {
        conditions.add(condition);
    }

    public void execute(Registration registration) throws FenixServiceException {
        Person person = Authenticate.getUser().getPerson();
        if (AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.STUDENT_ENROLMENTS, (AcademicProgram)((Object)registration.getDegree()), person.getUser())) {
            return;
        }
        if (RoleType.RESOURCE_ALLOCATION_MANAGER.isMember(person.getUser())) {
            person = registration.getPerson();
        }
        for (ClassEnrollmentCondition condition : conditions) {
            condition.verify(registration);
        }
        SortedSet<StudentCurricularPlan> activeStudentCurricularPlans = person.getActiveStudentCurricularPlansSortedByDegreeTypeAndDegreeName();
        if (activeStudentCurricularPlans.isEmpty()) {
            throw new NoActiveStudentCurricularPlanOfCorrectTypeException();
        }
        boolean hasOneOpen = false;
        FenixServiceException toThrow = null;
        for (StudentCurricularPlan studentCurricularPlan : activeStudentCurricularPlans) {
            FenixServiceException exception = this.verify(studentCurricularPlan, ExecutionSemester.readActualExecutionSemester());
            hasOneOpen = hasOneOpen || exception == null;
            toThrow = exception == null ? toThrow : exception;
        }
        if (!hasOneOpen) {
            throw toThrow;
        }
    }

    public void execute(Registration registration, ExecutionSemester executionSemester) throws FenixServiceException {
        Person person = Authenticate.getUser().getPerson();
        if (AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.STUDENT_ENROLMENTS, (AcademicProgram)((Object)registration.getDegree()), person.getUser())) {
            return;
        }
        if (RoleType.RESOURCE_ALLOCATION_MANAGER.isMember(person.getUser())) {
            person = registration.getPerson();
        }
        for (ClassEnrollmentCondition condition : conditions) {
            condition.verify(registration);
        }
        SortedSet<StudentCurricularPlan> activeStudentCurricularPlans = person.getActiveStudentCurricularPlansSortedByDegreeTypeAndDegreeName();
        if (activeStudentCurricularPlans.isEmpty()) {
            throw new NoActiveStudentCurricularPlanOfCorrectTypeException();
        }
        boolean hasOneOpen = false;
        FenixServiceException toThrow = null;
        for (StudentCurricularPlan studentCurricularPlan : activeStudentCurricularPlans) {
            FenixServiceException exception = this.verify(studentCurricularPlan, executionSemester);
            hasOneOpen = hasOneOpen || exception == null;
            toThrow = exception == null ? toThrow : exception;
        }
        if (!hasOneOpen) {
            throw toThrow;
        }
    }

    private FenixServiceException verify(StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester) {
        DegreeCurricularPlan degreeCurricularPlan = studentCurricularPlan.getDegreeCurricularPlan();
        Predicate<EnrolmentPeriod> predicate = null;
        predicate = !studentCurricularPlan.isInCandidateEnrolmentProcess(executionSemester.getExecutionYear()) ? ep -> ep.isForClasses() : ep -> ep instanceof EnrolmentPeriodInClassesCandidate;
        FenixServiceException result = this.verify(predicate, degreeCurricularPlan, executionSemester);
        if (result == null) {
            return null;
        }
        for (DegreeCurricularPlanEquivalencePlan equivalencePlan : degreeCurricularPlan.getTargetEquivalencePlansSet()) {
            DegreeCurricularPlan otherDegreeCurricularPlan = equivalencePlan.getDegreeCurricularPlan();
            result = this.verify(predicate, otherDegreeCurricularPlan, executionSemester);
            if (result != null) continue;
            return null;
        }
        return result;
    }

    private FenixServiceException verify(Predicate<EnrolmentPeriod> enrolmentTypePredicate, DegreeCurricularPlan degreeCurricularPlan, ExecutionSemester executionSemester) {
        Optional<EnrolmentPeriod> enrolmentPeriodInClasses = degreeCurricularPlan.getValidEnrolmentPeriod(enrolmentTypePredicate, executionSemester);
        if (!enrolmentPeriodInClasses.isPresent() || enrolmentPeriodInClasses.get().getStartDateDateTime() == null || enrolmentPeriodInClasses.get().getEndDateDateTime() == null) {
            return new CurrentClassesEnrolmentPeriodUndefinedForDegreeCurricularPlan();
        }
        if (!enrolmentPeriodInClasses.get().isValid()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(enrolmentPeriodInClasses.get().getStartDateDateTime().toString("dd/MM/yyyy HH:mm"));
            buffer.append(" - ");
            buffer.append(enrolmentPeriodInClasses.get().getEndDateDateTime().toString("dd/MM/yyyy HH:mm"));
            buffer.append(" (").append(enrolmentPeriodInClasses.get().getExecutionPeriod().getExecutionYear().getName()).append(")");
            return new OutsideOfCurrentClassesEnrolmentPeriodForDegreeCurricularPlan(buffer.toString());
        }
        return null;
    }

    public static class OutsideOfCurrentClassesEnrolmentPeriodForDegreeCurricularPlan
    extends FenixServiceException {
        public OutsideOfCurrentClassesEnrolmentPeriodForDegreeCurricularPlan() {
        }

        public OutsideOfCurrentClassesEnrolmentPeriodForDegreeCurricularPlan(String message, Throwable cause) {
            super(message, cause);
        }

        public OutsideOfCurrentClassesEnrolmentPeriodForDegreeCurricularPlan(Throwable cause) {
            super(cause);
        }

        public OutsideOfCurrentClassesEnrolmentPeriodForDegreeCurricularPlan(String message) {
            super("error.enrollment.period.closed", new String[]{message});
        }
    }

    public static class CurrentClassesEnrolmentPeriodUndefinedForDegreeCurricularPlan
    extends FenixServiceException {
        public CurrentClassesEnrolmentPeriodUndefinedForDegreeCurricularPlan() {
            super("error.enrolmentPeriodNotDefined");
        }
    }

    public static class NoActiveStudentCurricularPlanOfCorrectTypeException
    extends FenixServiceException {
    }

    @FunctionalInterface
    public static interface ClassEnrollmentCondition {
        public void verify(Registration var1) throws DomainException;
    }
}

