/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import com.google.common.base.Joiner;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.domain.serviceRequests.IRegistryDiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class RegistryDiploma
extends AdministrativeOfficeDocument {
    private static final long serialVersionUID = 7788392282506503345L;

    protected RegistryDiploma(IDocumentRequest documentRequest) {
        super(documentRequest);
    }

    @Override
    protected IRegistryDiplomaRequest getDocumentRequest() {
        return (IRegistryDiplomaRequest)super.getDocumentRequest();
    }

    @Override
    protected void fillReport() {
        super.fillReport();
        IRegistryDiplomaRequest request = this.getDocumentRequest();
        Person person = request.getPerson();
        this.setHeader();
        this.addParameter("institution", this.getInstitutionName());
        this.addParameter("university", this.getUniversity(this.getDocumentRequest().getConclusionDate().toDateTimeAtCurrentTime()).getPartyName().getContent(Locale.getDefault()));
        this.setFirstParagraph(request);
        this.setSecondParagraph(person, request);
        String thirdParagraph = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.thirdParagraph", (String[])new String[0]);
        String[] dateWord = this.getDateByWords(request.getConclusionDate());
        this.addParameter("thirdParagraph", MessageFormat.format(thirdParagraph, dateWord[0], dateWord[1], dateWord[2]));
        this.addParameter("by", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.by.university", (String[])new String[0]));
        if (this.getDocumentRequest().isRequestForRegistration()) {
            this.setFifthParagraph();
        }
        this.addParameter("studentName", person.getValidatedName());
        String graduateTitle = request.getGraduateTitle(this.getLocale());
        this.addParameter("graduateTitle", graduateTitle);
        this.setFooter();
    }

    private void setFifthParagraph() {
        String fifthParagraph = this.getUniversity(new DateTime()) != this.getUniversity(this.getDocumentRequest().getConclusionDate().toDateTimeAtCurrentTime()) ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.fifthParagraph.UTL.UL", (String[])new String[0]) : BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.fifthParagraph", (String[])new String[0]);
        this.addParameter("fifthParagraph", MessageFormat.format(fifthParagraph, BundleUtil.getString((String)"resources.EnumerationResources", (Locale)this.getLocale(), (String)this.getDocumentRequest().getFinalAverage(this.getLocale()), (String[])new String[0]), this.getDocumentRequest().getFinalAverage(this.getLocale()), BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)this.getDocumentRequest().getQualifiedAverageGrade(this.getLocale()), (String[])new String[0])));
    }

    protected void setHeader() {
        String degreeRegistrationDiploma = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.degreeRegistrationDiploma", (String[])new String[0]);
        LocalizedString graduationLevel = this.getDocumentRequest().getProgramConclusion().getGraduationLevel();
        if (!graduationLevel.isEmpty()) {
            degreeRegistrationDiploma = Joiner.on((String)" ").join((Object)degreeRegistrationDiploma, (Object)BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.of.both", (String[])new String[0]), new Object[]{graduationLevel.getContent(this.getLocale())});
        }
        this.addParameter("degreeRegistrationDiploma", degreeRegistrationDiploma);
        this.addParameter("portugueseRepublic_1", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.portugueseRepublic.part1", (String[])new String[0]));
        this.addParameter("portugueseRepublic_2", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.portugueseRepublic.part2", (String[])new String[0]));
    }

    protected void setFirstParagraph(IRegistryDiplomaRequest request) {
        String rectorGrant;
        String rectorGender;
        UniversityUnit university = this.getUniversity(new DateTime());
        String universityName = university.getPartyName().getPreferedContent();
        Person rector = university.getCurrentPrincipal();
        if (rector.isMale()) {
            rectorGender = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.rectorMale", (String[])new String[0]);
            rectorGrant = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.presidentGrantMale", (String[])new String[0]);
        } else {
            rectorGender = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.rectorFemale", (String[])new String[0]);
            rectorGrant = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.presidentGrantFemale", (String[])new String[0]);
        }
        String firstParagraph = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.firstParagraph", (String[])new String[0]);
        this.addParameter("firstParagraph", MessageFormat.format(firstParagraph, rectorGender, universityName, rectorGrant, rector.getValidatedName(), request.getRegistryCode().getCode()));
    }

    void setSecondParagraph(Person person, IRegistryDiplomaRequest request) {
        String studentGender = person.isMale() ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.studentHolderMale", (String[])new String[0]) : BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.studentHolderFemale", (String[])new String[0]);
        String secondParagraph = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.secondParagraph", (String[])new String[0]);
        if (person.getCountry() == null) {
            throw new DomainException("error.personWithoutParishOfBirth", new String[0]);
        }
        String country = person.getCountry().getCountryNationality().getContent(this.getLanguage()).toLowerCase();
        ExecutionYear year = this.getDocumentRequest().getConclusionYear();
        this.addParameter("secondParagraph", MessageFormat.format(secondParagraph, studentGender, BundleUtil.getString((String)"resources.EnumerationResources", (Locale)this.getLocale(), (String)person.getIdDocumentType().getName(), (String[])new String[0]), person.getDocumentIdNumber(), country, this.getProgramConclusionDescription(year)));
    }

    protected void setFooter() {
        String rectorGender;
        String presidentGender;
        UniversityUnit university = this.getUniversity(new DateTime());
        String institutionUnitName = this.getInstitutionName();
        Person president = university.getCurrentPresident();
        Person rector = university.getCurrentPrincipal();
        if (president.isMale()) {
            presidentGender = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.presidentMale", (String[])new String[0]);
            this.addParameter("presidentName", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.presidentGrantMale", (String[])new String[0]) + " " + president.getName());
        } else {
            presidentGender = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.presidentFemale", (String[])new String[0]);
            this.addParameter("presidentName", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.presidentGrantFemale", (String[])new String[0]) + " " + president.getName());
        }
        if (rector.isMale()) {
            rectorGender = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.rectorMale", (String[])new String[0]);
            this.addParameter("rectorName", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.presidentGrantMale", (String[])new String[0]) + " " + rector.getName());
        } else {
            rectorGender = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.rectorFemale", (String[])new String[0]);
            this.addParameter("rectorName", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.presidentGrantFemale", (String[])new String[0]) + " " + rector.getName());
        }
        String universityName = university.getPartyName().getPreferedContent();
        this.addParameter("dateParagraph", this.getFormatedCurrentDate(universityName));
        this.addParameter("rector", rectorGender);
        this.addParameter("president", MessageFormat.format(presidentGender, institutionUnitName));
    }

    private String getFormatedCurrentDate(String universityName) {
        StringBuilder result = new StringBuilder();
        LocalDate date = new LocalDate();
        String day = Integer.toString(date.getDayOfMonth());
        String month = date.toString("MMMM", this.getLocale());
        if (this.getDocumentRequest().getLanguage().getLanguage().equals(Locale.getDefault().getLanguage())) {
            month = month.toLowerCase();
        }
        result.append(universityName).append(", ");
        result.append(day + " ");
        result.append(BundleUtil.getString((String)"resources.ApplicationResources", (Locale)this.getLocale(), (String)"label.of", (String[])new String[0]));
        result.append(" " + month + " ");
        result.append(BundleUtil.getString((String)"resources.ApplicationResources", (Locale)this.getLocale(), (String)"label.of", (String[])new String[0]));
        result.append(" ").append(date.getYear()).append(".");
        return result.toString();
    }

    protected String[] getDateByWords(LocalDate date) {
        String day = Integer.toString(date.getDayOfMonth());
        String month = date.toString("MMMM", this.getLocale());
        if (this.getDocumentRequest().getLanguage().getLanguage().equals(Locale.getDefault().getLanguage())) {
            month = month.toLowerCase();
        }
        String year = Integer.toString(date.getYear());
        String[] finalDate = new String[]{day, month, year};
        return finalDate;
    }

    protected String getProgramConclusionDescription(ExecutionYear year) {
        ProgramConclusion programConclusion = this.getDocumentRequest().getProgramConclusion();
        ArrayList<String> result = new ArrayList<String>();
        result.add(programConclusion.getName().getContent(this.getLocale()));
        if (!programConclusion.getDescription().isEmpty()) {
            result.add(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.of.both", (String[])new String[0]));
            result.add(programConclusion.getDescription().getContent(this.getLocale()));
        }
        result.add(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.in", (String[])new String[0]));
        result.add(this.getDocumentRequest().getDegreeName(year));
        return Joiner.on((String)" ").join(result);
    }
}

