/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Locality;
import org.fenixedu.academic.domain.OptionalEnrolment;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.CertificateRequestPR;
import org.fenixedu.academic.domain.accounting.serviceAgreementTemplates.AdministrativeOfficeServiceAgreementTemplate;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdDocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.serviceRequests.RegistrationAcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.Under23TransportsDeclarationRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.CertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.CourseLoadRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ExternalCourseLoadRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ExternalProgramCertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ProgramCertificateRequest;
import org.fenixedu.academic.domain.student.MobilityProgram;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;
import org.fenixedu.academic.report.FenixReport;
import org.fenixedu.academic.report.academicAdministrativeOffice.ApprovementCertificate;
import org.fenixedu.academic.report.academicAdministrativeOffice.ApprovementMobilityCertificate;
import org.fenixedu.academic.report.academicAdministrativeOffice.CourseLoadRequestDocument;
import org.fenixedu.academic.report.academicAdministrativeOffice.DegreeFinalizationCertificate;
import org.fenixedu.academic.report.academicAdministrativeOffice.Diploma;
import org.fenixedu.academic.report.academicAdministrativeOffice.DiplomaSupplement;
import org.fenixedu.academic.report.academicAdministrativeOffice.EnrolmentCertificate;
import org.fenixedu.academic.report.academicAdministrativeOffice.EnrolmentDeclaration;
import org.fenixedu.academic.report.academicAdministrativeOffice.ExamDateCertificate;
import org.fenixedu.academic.report.academicAdministrativeOffice.ExternalCourseLoadRequestDocument;
import org.fenixedu.academic.report.academicAdministrativeOffice.ExternalProgramCertificateRequestDocument;
import org.fenixedu.academic.report.academicAdministrativeOffice.ExtraCurricularCertificateRequestDocument;
import org.fenixedu.academic.report.academicAdministrativeOffice.IRSDeclaration;
import org.fenixedu.academic.report.academicAdministrativeOffice.PhdDiploma;
import org.fenixedu.academic.report.academicAdministrativeOffice.PhdFinalizationCertificate;
import org.fenixedu.academic.report.academicAdministrativeOffice.PhdRegistryDiploma;
import org.fenixedu.academic.report.academicAdministrativeOffice.ProgramCertificateRequestDocument;
import org.fenixedu.academic.report.academicAdministrativeOffice.RegistrationCertificate;
import org.fenixedu.academic.report.academicAdministrativeOffice.RegistrationDeclaration;
import org.fenixedu.academic.report.academicAdministrativeOffice.RegistryDiploma;
import org.fenixedu.academic.report.academicAdministrativeOffice.StandaloneEnrolmentCertificateRequestDocument;
import org.fenixedu.academic.report.academicAdministrativeOffice.Under23TransportsDeclarationDocument;
import org.fenixedu.academic.util.FenixStringTools;
import org.fenixedu.academic.util.HtmlToTextConverterUtil;
import org.fenixedu.academic.util.Money;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.academic.util.StringFormatter;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class AdministrativeOfficeDocument
extends FenixReport {
    protected static final int LINE_LENGTH = 64;
    protected static final int SUFFIX_LENGTH = 12;
    protected static final String[] identifiers = new String[]{"i) ", "ii) ", "iii) ", "iv) ", "v) ", "vi) ", "vii) ", "viii) ", "ix) ", "x) "};
    protected static final String LINE_BREAK = "\n";
    protected static final char END_CHAR = '-';
    protected IDocumentRequest documentRequestDomainReference;

    protected AdministrativeOfficeDocument(IDocumentRequest documentRequest) {
        this(documentRequest, documentRequest.getLanguage());
    }

    public AdministrativeOfficeDocument(IDocumentRequest documentRequest, Locale locale) {
        super(locale);
        this.documentRequestDomainReference = documentRequest;
        this.fillReport();
    }

    protected IDocumentRequest getDocumentRequest() {
        return this.documentRequestDomainReference;
    }

    @Override
    public String getReportTemplateKey() {
        return this.getDocumentRequest().getDocumentTemplateKey();
    }

    protected UniversityUnit getUniversity(DateTime date) {
        return UniversityUnit.getInstitutionsUniversityUnitByDate(date);
    }

    protected String getUniversityName(DateTime date) {
        return this.getUniversity(date).getPartyName().getContent(this.getLanguage());
    }

    protected String getInstitutionName() {
        return Bennu.getInstance().getInstitutionUnit().getPartyName().getContent(this.getLanguage());
    }

    @Override
    public String getReportFileName() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDocumentRequest().getPerson().getUsername());
        result.append("-");
        result.append(new DateTime().toString("yyyyMMdd", this.getLocale()));
        result.append("-");
        result.append(this.getDocumentRequest().getDescription().replace(":", "").replace(" ", ""));
        result.append("-");
        result.append(this.getLanguage().toString());
        return result.toString();
    }

    protected AdministrativeOffice getAdministrativeOffice() {
        return this.getDocumentRequest().getAdministrativeOffice();
    }

    protected Registration getRegistration() {
        if (this.getDocumentRequest().isRequestForRegistration()) {
            return ((RegistrationAcademicServiceRequest)((Object)this.getDocumentRequest())).getRegistration();
        }
        if (this.getDocumentRequest().isRequestForPhd()) {
            return ((PhdDocumentRequest)this.getDocumentRequest()).getPhdIndividualProgramProcess().getRegistration();
        }
        throw new DomainException("error.AdministrativeOfficeDocument.registration.not.found", new String[0]);
    }

    @Override
    protected void fillReport() {
        this.addParameter("bundle", ResourceBundle.getBundle(this.getBundle(), this.getLocale()));
        this.addParameter("documentRequest", this.getDocumentRequest());
        this.addParameter("registration", (Object)this.getRegistration());
        if (this.showPriceFields() && !((AcademicServiceRequest)((Object)this.getDocumentRequest())).isFree()) {
            this.addPriceFields();
        }
        this.addIntroParameters();
        this.setDocumentTitle();
        this.setPersonFields();
        if (this.getDocumentRequest().hasExecutionYear()) {
            String situation = this.getExecutionYear().containsDate(new DateTime()) ? "label.is" : "label.was";
            this.addParameter("situation", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)situation, (String[])new String[0]));
        }
        this.addParameter("degreeDescription", this.getDegreeDescription());
        this.addParameter("day", new LocalDate().toString("dd MMMM yyyy", this.getLocale()));
        this.newFillReport();
    }

    protected String getBundle() {
        return "resources.AcademicAdminOffice";
    }

    protected void newFillReport() {
    }

    protected boolean showPriceFields() {
        return this.getDocumentRequest().isCertificate() && this.getDocumentRequest().getEventType() != null;
    }

    protected void addPriceFields() {
        CertificateRequest certificateRequest = (CertificateRequest)((Object)this.getDocumentRequest());
        CertificateRequestPR certificateRequestPR = (CertificateRequestPR)((Object)this.getPostingRule());
        Money amountPerPage = certificateRequestPR != null ? certificateRequestPR.getAmountPerPage() : Money.ZERO;
        Money baseAmountPlusAmountForUnits = certificateRequestPR != null ? certificateRequestPR.getBaseAmount().add(certificateRequestPR.getAmountPerUnit().multiply(BigDecimal.valueOf(certificateRequest.getNumberOfUnits().intValue()))) : Money.ZERO;
        Money urgencyAmount = certificateRequest.getUrgentRequest() != false && certificateRequestPR != null ? certificateRequestPR.getBaseAmount() : Money.ZERO;
        this.addParameter("printed", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.certificate.printingPriceLabel", (String[])new String[0]));
        this.addParameter("printPriceLabel", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.certificate.issuingPriceLabel", (String[])new String[0]));
        this.addParameter("urgency", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.certificate.fastDeliveryPriceLabel", (String[])new String[0]));
        this.addParameter("total", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.certificate.totalsPriceLabel", (String[])new String[0]));
        this.addParameter("amountPerPage", amountPerPage);
        this.addParameter("baseAmountPlusAmountForUnits", baseAmountPlusAmountForUnits);
        this.addParameter("urgencyAmount", urgencyAmount);
        this.addParameter("printPriceFields", this.printPriceParameters(certificateRequest));
    }

    protected final PostingRule getPostingRule() {
        AdministrativeOfficeServiceAgreementTemplate serviceAgreementTemplate = this.getDocumentRequest().getAdministrativeOffice().getServiceAgreementTemplate();
        return serviceAgreementTemplate.findPostingRuleByEventType(this.getDocumentRequest().getEventType());
    }

    protected final boolean printPriceParameters(CertificateRequest certificateRequest) {
        return certificateRequest.getAcademicServiceRequestSituationType() == AcademicServiceRequestSituationType.PROCESSING && !certificateRequest.isFree() || certificateRequest.getEvent() != null;
    }

    protected void addIntroParameters() {
        this.addParameter("administrativeOfficeCoordinator", (Object)this.getAdministrativeOffice().getCoordinator().getPerson());
        this.addParameter("administrativeOfficeName", this.getI18NText(this.getAdministrativeOffice().getName()));
        Locality locality = this.getAdministrativeOffice().getCampus().getLocality();
        this.addParameter("employeeLocation", locality != null ? locality.getName() : null);
        this.addParameter("supervisingUnit", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.direcaoAcademica", (String[])new String[0]));
        this.addParameter("institutionName", this.getInstitutionName());
        this.addParameter("universityName", this.getUniversityName(this.getDocumentRequest().getRequestDate()));
    }

    protected void setDocumentTitle() {
    }

    protected void setPersonFields() {
        Person person = this.getDocumentRequest().getPerson();
        StringBuilder builder1 = new StringBuilder();
        builder1.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.with", (String[])new String[0]));
        builder1.append(" ").append(person.getIdDocumentType().getLocalizedName(this.getLocale()));
        builder1.append(" ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.number.short", (String[])new String[0]));
        builder1.append(" ").append(person.getDocumentIdNumber());
        StringBuilder builder2 = new StringBuilder();
        builder2.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"documents.birthLocale", (String[])new String[0]));
        builder2.append(" ").append(this.getBirthLocale(person, false));
        if (this.getDocumentRequest().getDocumentRequestType().equals((Object)DocumentRequestType.APPROVEMENT_MOBILITY_CERTIFICATE)) {
            this.addParameter("name", person.getName().toUpperCase());
            this.addParameter("documentIdNumber", builder1.toString());
            this.addParameter("birthLocale", builder2.toString());
        } else {
            this.addParameter("name", FenixStringTools.multipleLineRightPad(person.getName().toUpperCase(), 64, '-'));
            this.addParameter("documentIdNumber", FenixStringTools.multipleLineRightPad(builder1.toString(), 64, '-'));
            this.addParameter("birthLocale", FenixStringTools.multipleLineRightPad(builder2.toString(), 64, '-'));
        }
        this.setNationality(person);
    }

    protected void setNationality(Person person) {
        String nationality = person.getCountry().getFilteredNationality(this.getLocale()).toUpperCase();
        String labelNationality = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"message.documents.nationality", (String[])new String[0]);
        String nationalityMessage = MessageFormat.format(labelNationality, nationality);
        if (this.getDocumentRequest().getDocumentRequestType().equals((Object)DocumentRequestType.APPROVEMENT_MOBILITY_CERTIFICATE)) {
            this.addParameter("nationality", nationalityMessage);
        } else {
            this.addParameter("nationality", FenixStringTools.multipleLineRightPad(nationalityMessage, 64, '-'));
        }
    }

    protected String getBirthLocale(Person person, boolean prettyPrint) {
        StringBuilder result = new StringBuilder();
        if (person.getParishOfBirth() == null) {
            return "";
        }
        String parishOfBirth = prettyPrint ? StringFormatter.prettyPrint(person.getParishOfBirth()) : person.getParishOfBirth();
        String districtSubdivision = prettyPrint ? StringFormatter.prettyPrint(person.getDistrictSubdivisionOfBirth()) : person.getDistrictSubdivisionOfBirth();
        result.append(parishOfBirth);
        if (!parishOfBirth.equals(districtSubdivision)) {
            result.append(",").append(" ").append(districtSubdivision);
        }
        return result.toString();
    }

    protected String getDegreeDescription() {
        Registration registration = this.getRegistration();
        DegreeType degreeType = registration.getDegreeType();
        CycleType cycleType = degreeType.hasExactlyOneCycleType() ? degreeType.getCycleType() : registration.getCycleType(this.getExecutionYear());
        return registration.getDegreeDescription(cycleType, this.getLocale());
    }

    protected ExecutionYear getExecutionYear() {
        if (this.getDocumentRequest().hasExecutionYear()) {
            return this.getDocumentRequest().getExecutionYear();
        }
        return ExecutionYear.readByDateTime(this.getDocumentRequest().getRequestDate());
    }

    protected final String getCreditsDescription() {
        if (this.getDocumentRequest().isRequestForRegistration()) {
            return ((RegistrationAcademicServiceRequest)((Object)this.getDocumentRequest())).getDegreeType().getCreditsDescription();
        }
        return null;
    }

    protected final String generateEndLine() {
        return StringUtils.rightPad((String)"", (int)64, (char)'-');
    }

    protected final String getCurriculumEntryName(Map<Unit, String> academicUnitIdentifiers, ICurriculumEntry entry) {
        StringBuilder result = new StringBuilder();
        if (entry instanceof ExternalEnrolment) {
            result.append(this.getAcademicUnitIdentifier(academicUnitIdentifiers, ((ExternalEnrolment)entry).getAcademicUnit()));
        }
        result.append(this.getPresentationNameFor(entry).toUpperCase());
        return result.toString();
    }

    protected String getPresentationNameFor(ICurriculumEntry entry) {
        MultiLanguageString result;
        if (entry instanceof OptionalEnrolment) {
            OptionalEnrolment optionalEnrolment = (OptionalEnrolment)((Object)entry);
            result = optionalEnrolment.getCurricularCourse().getNameI18N();
        } else {
            result = entry.getName();
        }
        return this.getMLSTextContent(result);
    }

    protected String getMLSTextContent(MultiLanguageString mls) {
        return this.getMLSTextContent(mls, this.getLanguage());
    }

    protected String getMLSTextContent(MultiLanguageString mls, Locale language) {
        if (mls == null) {
            return "";
        }
        String content = mls.hasContent(language) && !StringUtils.isEmpty((String)mls.getContent(language)) ? mls.getContent(language) : mls.getContent();
        return content;
    }

    protected String getI18NText(LocalizedString localized) {
        return this.getI18NText(localized, this.getLocale());
    }

    protected String getI18NText(LocalizedString localized, Locale language) {
        if (localized == null) {
            return "";
        }
        String result = localized.getContent(language);
        return !Strings.isNullOrEmpty((String)result) ? result : localized.getContent();
    }

    protected String convert(String content) {
        return HtmlToTextConverterUtil.convertToText(content).replace("\n\n", "\t").replace(LINE_BREAK, "").replace("\t", "\n\n").trim();
    }

    protected final String getAcademicUnitIdentifier(Map<Unit, String> academicUnitIdentifiers, Unit academicUnit) {
        if (!academicUnitIdentifiers.containsKey((Object)academicUnit)) {
            academicUnitIdentifiers.put(academicUnit, identifiers[academicUnitIdentifiers.size()]);
        }
        return academicUnitIdentifiers.get((Object)academicUnit);
    }

    protected final void getCreditsInfo(StringBuilder result, ICurriculumEntry entry) {
        result.append(entry.getEctsCreditsForCurriculum()).append(this.getCreditsDescription()).append(", ");
    }

    protected final String getRemainingCreditsInfo(ICurriculum curriculum) {
        BigDecimal remainingCredits = curriculum.getRemainingCredits();
        StringBuilder result = new StringBuilder();
        if (remainingCredits != BigDecimal.ZERO) {
            result.append(LINE_BREAK);
            String remainingCreditsInfo = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"documents.remainingCreditsInfo", (String[])new String[0]);
            result.append(FenixStringTools.multipleLineRightPadWithSuffix(remainingCreditsInfo + ":", 64, '-', remainingCredits + this.getCreditsDescription()));
            result.append(LINE_BREAK);
        }
        return result.toString();
    }

    protected final String getAcademicUnitInfo(Map<Unit, String> unitIDs, MobilityProgram mobilityProgram) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<Unit, String> academicUnitId : unitIDs.entrySet()) {
            StringBuilder unit = new StringBuilder();
            unit.append(academicUnitId.getValue());
            unit.append(" ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"documents.external.curricular.courses.one", (String[])new String[0]));
            unit.append(" ").append(this.getMLSTextContent(academicUnitId.getKey().getPartyName()).toUpperCase());
            if (mobilityProgram != null) {
                unit.append(" ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"documents.external.curricular.courses.two", (String[])new String[0]));
                unit.append(" ").append(mobilityProgram.getDescription(this.getLocale()).toUpperCase());
            }
            result.append(FenixStringTools.multipleLineRightPad(unit.toString(), 64, '-'));
            result.append(LINE_BREAK);
        }
        return result.toString();
    }

    protected String getCreditsAndGradeInfo(ICurriculumEntry entry, ExecutionYear executionYear) {
        StringBuilder result = new StringBuilder();
        if (this.getDocumentRequest().isToShowCredits()) {
            this.getCreditsInfo(result, entry);
        }
        result.append(entry.getGradeValue());
        result.append(StringUtils.rightPad((String)("(" + BundleUtil.getString((String)"resources.EnumerationResources", (Locale)this.getLocale(), (String)entry.getGradeValue(), (String[])new String[0]) + ")"), (int)12, (char)' '));
        result.append(" ");
        String in = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.in", (String[])new String[0]);
        if (executionYear == null) {
            result.append(StringUtils.rightPad((String)"", (int)in.length(), (char)' '));
            result.append(" ").append(StringUtils.rightPad((String)"", (int)9, (char)' '));
        } else {
            result.append(in);
            result.append(" ").append(executionYear.getYear());
        }
        return result.toString();
    }

    protected void setFooter(DocumentRequest documentRequest) {
        Registration registration = documentRequest.getRegistration();
        String student = registration.getStudent().getPerson().isMale() ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.maleStudent", (String[])new String[0]) : BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.femaleStudent", (String[])new String[0]);
        String stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.footer.studentNumber", (String[])new String[0]);
        this.addParameter("studentNumber", MessageFormat.format(stringTemplate, student, registration.getNumber().toString()));
        stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.footer.documentNumber", (String[])new String[0]);
        this.addParameter("documentNumber", MessageFormat.format(stringTemplate, documentRequest.getServiceRequestNumberYear()));
        this.addParameter("checked", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.irs.declaration.checked", (String[])new String[0]));
        this.addParameter("page", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.footer.page", (String[])new String[0]));
        this.addParameter("pageOf", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.footer.pageOf", (String[])new String[0]));
    }

    protected void fillInstitutionAndStaffFields() {
        String institutionName = this.getInstitutionName();
        Person coordinator = this.getAdministrativeOffice().getCoordinator().getPerson();
        String coordinatorTitle = this.getCoordinatorGender(coordinator);
        String stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.irs.declaration.signer", (String[])new String[0]);
        this.addParameter("signer", MessageFormat.format(stringTemplate, coordinatorTitle, this.getI18NText(this.getAdministrativeOffice().getName())));
        String departmentAndInstitute = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.signer", (String[])new String[0]);
        this.addParameter("departmentAndInstitute", MessageFormat.format(departmentAndInstitute, this.getI18NText(this.getAdministrativeOffice().getName()), institutionName));
        this.addParameter("administrativeOfficeCoordinator", (Object)coordinator);
        Locality locality = this.getAdministrativeOffice().getCampus().getLocality();
        String location = locality != null ? locality.getName() : null;
        String dateDD = new LocalDate().toString("dd", this.getLocale());
        String dateMMMM = new LocalDate().toString("MMMM", this.getLocale());
        String dateYYYY = new LocalDate().toString("yyyy", this.getLocale());
        stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.signerLocation", (String[])new String[0]);
        this.addParameter("signerLocation", MessageFormat.format(stringTemplate, institutionName, location, dateDD, dateMMMM, dateYYYY));
    }

    protected String getCoordinatorGender(Person coordinator) {
        if (coordinator.isMale()) {
            return BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.maleCoordinator", (String[])new String[0]);
        }
        return BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.femaleCoordinator", (String[])new String[0]);
    }

    public static class AdministrativeOfficeDocumentCreator {
        public static <T extends AdministrativeOfficeDocument> List<T> create(IDocumentRequest documentRequest) {
            switch (documentRequest.getDocumentRequestType()) {
                case ENROLMENT_CERTIFICATE: {
                    return Collections.singletonList(new EnrolmentCertificate(documentRequest));
                }
                case APPROVEMENT_CERTIFICATE: {
                    return Collections.singletonList(new ApprovementCertificate(documentRequest));
                }
                case APPROVEMENT_MOBILITY_CERTIFICATE: {
                    return Collections.singletonList(new ApprovementMobilityCertificate(documentRequest));
                }
                case DEGREE_FINALIZATION_CERTIFICATE: {
                    return Collections.singletonList(new DegreeFinalizationCertificate(documentRequest));
                }
                case PHD_FINALIZATION_CERTIFICATE: {
                    return Collections.singletonList(new PhdFinalizationCertificate(documentRequest));
                }
                case SCHOOL_REGISTRATION_DECLARATION: {
                    return Collections.singletonList(new RegistrationDeclaration(documentRequest));
                }
                case SCHOOL_REGISTRATION_CERTIFICATE: {
                    return Collections.singletonList(new RegistrationCertificate(documentRequest));
                }
                case ENROLMENT_DECLARATION: {
                    return Collections.singletonList(new EnrolmentDeclaration(documentRequest));
                }
                case IRS_DECLARATION: {
                    return Collections.singletonList(new IRSDeclaration(documentRequest));
                }
                case DIPLOMA_REQUEST: {
                    if (documentRequest.isRequestForRegistration()) {
                        return Collections.singletonList(new Diploma(documentRequest));
                    }
                    if (documentRequest.isRequestForPhd()) {
                        return Collections.singletonList(new PhdDiploma(documentRequest));
                    }
                }
                case REGISTRY_DIPLOMA_REQUEST: {
                    if (documentRequest.isRequestForRegistration()) {
                        return Collections.singletonList(new RegistryDiploma(documentRequest));
                    }
                    if (documentRequest.isRequestForPhd()) {
                        return Collections.singletonList(new PhdRegistryDiploma(documentRequest));
                    }
                }
                case DIPLOMA_SUPPLEMENT_REQUEST: {
                    ArrayList<DiplomaSupplement> result = new ArrayList<DiplomaSupplement>();
                    HashSet definedLocales = new HashSet(CoreConfiguration.supportedLocales());
                    definedLocales.remove(Locale.getDefault());
                    result.add(new DiplomaSupplement(documentRequest, Locale.getDefault()));
                    for (Locale locale : definedLocales) {
                        result.add(new DiplomaSupplement(documentRequest, locale));
                    }
                    return result;
                }
                case EXAM_DATE_CERTIFICATE: {
                    return Collections.singletonList(new ExamDateCertificate(documentRequest));
                }
                case COURSE_LOAD: {
                    return Collections.singletonList(new CourseLoadRequestDocument((CourseLoadRequest)((Object)documentRequest)));
                }
                case EXTERNAL_COURSE_LOAD: {
                    return Collections.singletonList(new ExternalCourseLoadRequestDocument((ExternalCourseLoadRequest)((Object)documentRequest)));
                }
                case PROGRAM_CERTIFICATE: {
                    return Collections.singletonList(new ProgramCertificateRequestDocument((ProgramCertificateRequest)((Object)documentRequest)));
                }
                case EXTERNAL_PROGRAM_CERTIFICATE: {
                    return Collections.singletonList(new ExternalProgramCertificateRequestDocument((ExternalProgramCertificateRequest)((Object)documentRequest)));
                }
                case EXTRA_CURRICULAR_CERTIFICATE: {
                    return Collections.singletonList(new ExtraCurricularCertificateRequestDocument(documentRequest));
                }
                case STANDALONE_ENROLMENT_CERTIFICATE: {
                    return Collections.singletonList(new StandaloneEnrolmentCertificateRequestDocument(documentRequest));
                }
                case UNDER_23_TRANSPORTS_REQUEST: {
                    return Collections.singletonList(new Under23TransportsDeclarationDocument((Under23TransportsDeclarationRequest)((Object)documentRequest)));
                }
            }
            return Collections.singletonList(new AdministrativeOfficeDocument(documentRequest));
        }
    }
}

