/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.student.enrollment.bolonha;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.dto.student.IStudentCurricularPlanBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.StudentCurriculumGroupBean;
import org.fenixedu.academic.ui.renderers.converters.DegreeModuleToEnrolKeyConverter;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.LocalDate;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class BolonhaStudentEnrollmentBean
implements Serializable,
IStudentCurricularPlanBean {
    private static final long serialVersionUID = -5614162187691303580L;
    private StudentCurricularPlan studentCurricularPlan;
    private ExecutionSemester executionSemester;
    private StudentCurriculumGroupBean rootStudentCurriculumGroupBean;
    private List<IDegreeModuleToEvaluate> degreeModulesToEvaluate;
    private List<CurriculumModule> curriculumModulesToRemove;
    private IDegreeModuleToEvaluate optionalDegreeModuleToEnrol;
    private CurricularRuleLevel curricularRuleLevel;
    private CycleType cycleTypeToEnrol;
    private LocalDate endStageDate;

    public BolonhaStudentEnrollmentBean(StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester, int[] curricularYears, CurricularRuleLevel curricularRuleLevel) {
        this(studentCurricularPlan, executionSemester, new StudentCurriculumGroupBean((CurriculumGroup)((Object)studentCurricularPlan.getRoot()), executionSemester, curricularYears), curricularRuleLevel);
        this.setEndStageDate(studentCurricularPlan.getEndStageDate());
    }

    protected BolonhaStudentEnrollmentBean(StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester, StudentCurriculumGroupBean rootStudentCurriculumGroupBean, CurricularRuleLevel curricularRuleLevel) {
        this.setStudentCurricularPlan(studentCurricularPlan);
        this.setExecutionPeriod(executionSemester);
        this.setRootStudentCurriculumGroupBean(rootStudentCurriculumGroupBean);
        this.setDegreeModulesToEvaluate(new ArrayList<IDegreeModuleToEvaluate>());
        this.setCurriculumModulesToRemove(new ArrayList<CurriculumModule>());
        this.setCurricularRuleLevel(curricularRuleLevel);
    }

    @Override
    public StudentCurricularPlan getStudentCurricularPlan() {
        return this.studentCurricularPlan;
    }

    private void setStudentCurricularPlan(StudentCurricularPlan studentCurricularPlan) {
        this.studentCurricularPlan = studentCurricularPlan;
    }

    public ExecutionSemester getExecutionPeriod() {
        return this.executionSemester;
    }

    public void setExecutionPeriod(ExecutionSemester executionSemester) {
        this.executionSemester = executionSemester;
    }

    public StudentCurriculumGroupBean getRootStudentCurriculumGroupBean() {
        return this.rootStudentCurriculumGroupBean;
    }

    public void setRootStudentCurriculumGroupBean(StudentCurriculumGroupBean studentCurriculumGroupBean) {
        this.rootStudentCurriculumGroupBean = studentCurriculumGroupBean;
    }

    public List<IDegreeModuleToEvaluate> getDegreeModulesToEvaluate() {
        return this.degreeModulesToEvaluate;
    }

    public void setDegreeModulesToEvaluate(List<IDegreeModuleToEvaluate> degreeModulesToEnrol) {
        this.degreeModulesToEvaluate = degreeModulesToEnrol;
    }

    public IDegreeModuleToEvaluate getOptionalDegreeModuleToEnrol() {
        return this.optionalDegreeModuleToEnrol;
    }

    public void setOptionalDegreeModuleToEnrol(IDegreeModuleToEvaluate optionalDegreeModuleToEnrol) {
        this.optionalDegreeModuleToEnrol = optionalDegreeModuleToEnrol;
    }

    public CurricularRuleLevel getCurricularRuleLevel() {
        return this.curricularRuleLevel;
    }

    public void setCurricularRuleLevel(CurricularRuleLevel curricularRuleLevel) {
        this.curricularRuleLevel = curricularRuleLevel;
    }

    public List<CurriculumModule> getCurriculumModulesToRemove() {
        ArrayList<CurriculumModule> result = new ArrayList<CurriculumModule>();
        for (CurriculumModule domainReference : this.curriculumModulesToRemove) {
            result.add(domainReference);
        }
        return result;
    }

    public void setCurriculumModulesToRemove(List<CurriculumModule> curriculumModules) {
        this.curriculumModulesToRemove = new ArrayList<CurriculumModule>();
        for (CurriculumModule curriculumModule : curriculumModules) {
            this.curriculumModulesToRemove.add(curriculumModule);
        }
    }

    public Converter getDegreeModulesToEvaluateConverter() {
        return new DegreeModuleToEnrolKeyConverter();
    }

    public String getFuncionalityTitle() {
        StringBuilder result = new StringBuilder();
        result.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.student.enrollment.courses", (String[])new String[0])).append(" ");
        switch (this.curricularRuleLevel) {
            case ENROLMENT_WITH_RULES: {
                result.append("(").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.student.enrollment.withRules", (String[])new String[0])).append(")");
                break;
            }
            case ENROLMENT_NO_RULES: {
                result.append("(").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.student.enrollment.withoutRules", (String[])new String[0])).append(")");
            }
        }
        return result.toString();
    }

    public CycleType getCycleTypeToEnrol() {
        return this.cycleTypeToEnrol;
    }

    public void setCycleTypeToEnrol(CycleType cycleTypeToEnrol) {
        this.cycleTypeToEnrol = cycleTypeToEnrol;
    }

    public LocalDate getEndStageDate() {
        return this.endStageDate;
    }

    public void setEndStageDate(LocalDate date) {
        this.endStageDate = date;
    }

    public Registration getRegistration() {
        return this.getStudentCurricularPlan().getRegistration();
    }
}

