/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.directiveCouncil;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;

public class ExecutionCourseSummaryElement
implements Serializable {
    private ExecutionCourse executionCourse;
    private BigDecimal numberOfLessonInstances;
    private BigDecimal numberOfLessonInstancesWithSummary;
    private BigDecimal percentageOfLessonsWithSummary;
    private BigDecimal numberOfLessonInstancesWithNotTaughtSummary;
    private BigDecimal percentageOfLessonsWithNotTaughtSummary;

    public ExecutionCourseSummaryElement(ExecutionCourse executionCourse, BigDecimal numberOfLessonInstance, BigDecimal numberOfLessonInstanceWithSummary, BigDecimal percentageOfLessonsWithSummary, BigDecimal numberOfLessonInstancesWithNotTaughtSummary, BigDecimal percentageOfLessonsWithNotTaughtSummary) {
        this.setExecutionCourse(executionCourse);
        this.setNumberOfLessonInstances(numberOfLessonInstance);
        this.setNumberOfLessonInstancesWithSummary(numberOfLessonInstanceWithSummary);
        this.setPercentageOfLessonsWithSummary(percentageOfLessonsWithSummary);
        this.setNumberOfLessonInstancesWithNotTaughtSummary(numberOfLessonInstancesWithNotTaughtSummary);
        this.setPercentageOfLessonsWithNotTaughtSummary(percentageOfLessonsWithNotTaughtSummary);
    }

    public Set<Person> getPersons() {
        HashSet<Person> persons = new HashSet<Person>();
        for (Professorship professorship : this.getExecutionCourse().getProfessorshipsSet()) {
            persons.add(professorship.getPerson());
        }
        return persons;
    }

    public ExecutionCourse getExecutionCourse() {
        return this.executionCourse;
    }

    public void setExecutionCourse(ExecutionCourse executionCourse) {
        this.executionCourse = executionCourse;
    }

    public BigDecimal getNumberOfLessonInstances() {
        return this.numberOfLessonInstances;
    }

    public void setNumberOfLessonInstances(BigDecimal numberOfLessonInstances) {
        this.numberOfLessonInstances = numberOfLessonInstances;
    }

    public BigDecimal getNumberOfLessonInstancesWithSummary() {
        return this.numberOfLessonInstancesWithSummary;
    }

    public void setNumberOfLessonInstancesWithSummary(BigDecimal numberOfLessonInstancesWithSummary) {
        this.numberOfLessonInstancesWithSummary = numberOfLessonInstancesWithSummary;
    }

    public BigDecimal getPercentageOfLessonsWithSummary() {
        return this.percentageOfLessonsWithSummary.setScale(2);
    }

    public void setPercentageOfLessonsWithSummary(BigDecimal percentageOfLessonsWithSummary) {
        this.percentageOfLessonsWithSummary = percentageOfLessonsWithSummary;
    }

    public void setNumberOfLessonInstancesWithNotTaughtSummary(BigDecimal numberOfLessonInstancesWithNotTaughtSummary) {
        this.numberOfLessonInstancesWithNotTaughtSummary = numberOfLessonInstancesWithNotTaughtSummary;
    }

    public BigDecimal getNumberOfLessonInstancesWithNotTaughtSummary() {
        return this.numberOfLessonInstancesWithNotTaughtSummary;
    }

    public void setPercentageOfLessonsWithNotTaughtSummary(BigDecimal percentageOfLessonsWithNotTaughtSummary) {
        this.percentageOfLessonsWithNotTaughtSummary = percentageOfLessonsWithNotTaughtSummary;
    }

    public BigDecimal getPercentageOfLessonsWithNotTaughtSummary() {
        return this.percentageOfLessonsWithNotTaughtSummary.setScale(2);
    }
}

