/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.directiveCouncil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.dto.directiveCouncil.ExecutionCourseSummaryElement;

public class DepartmentSummaryElement
implements Serializable {
    private Department department;
    private ExecutionSemester executionSemester;
    private SummaryControlCategory summaryControlCategory;
    private Map<SummaryControlCategory, List<ExecutionCourseSummaryElement>> executionCoursesResume;

    public DepartmentSummaryElement(Department department, ExecutionSemester executionSemester) {
        this.setDepartment(department);
        this.setExecutionSemester(executionSemester);
    }

    public boolean getHasResumeData() {
        return this.getExecutionCoursesResume() != null && !this.getExecutionCoursesResume().isEmpty();
    }

    public List<ExecutionCourseSummaryElement> getExecutionCourses() {
        List<ExecutionCourseSummaryElement> returnList = new ArrayList<ExecutionCourseSummaryElement>();
        if (this.getSummaryControlCategory() == null) {
            for (List<ExecutionCourseSummaryElement> ecList : this.getExecutionCoursesResume().values()) {
                returnList.addAll(ecList);
            }
        } else if (this.getExecutionCoursesResume().get((Object)this.getSummaryControlCategory()) != null) {
            returnList = this.getExecutionCoursesResume().get((Object)this.getSummaryControlCategory());
        }
        return returnList;
    }

    public int getNumberOfExecutionCoursesWithin020() {
        if (this.getExecutionCoursesResume() != null) {
            List<ExecutionCourseSummaryElement> executionCourses = this.getExecutionCoursesResume().get((Object)SummaryControlCategory.BETWEEN_0_20);
            return executionCourses != null ? executionCourses.size() : 0;
        }
        return 0;
    }

    public int getNumberOfExecutionCoursesWithin2040() {
        if (this.getExecutionCoursesResume() != null) {
            List<ExecutionCourseSummaryElement> executionCourses = this.getExecutionCoursesResume().get((Object)SummaryControlCategory.BETWEEN_20_40);
            return executionCourses != null ? executionCourses.size() : 0;
        }
        return 0;
    }

    public int getNumberOfExecutionCoursesWithin4060() {
        if (this.getExecutionCoursesResume() != null) {
            List<ExecutionCourseSummaryElement> executionCourses = this.getExecutionCoursesResume().get((Object)SummaryControlCategory.BETWEEN_40_60);
            return executionCourses != null ? executionCourses.size() : 0;
        }
        return 0;
    }

    public int getNumberOfExecutionCoursesWithin6080() {
        if (this.getExecutionCoursesResume() != null) {
            List<ExecutionCourseSummaryElement> executionCourses = this.getExecutionCoursesResume().get((Object)SummaryControlCategory.BETWEEN_60_80);
            return executionCourses != null ? executionCourses.size() : 0;
        }
        return 0;
    }

    public int getNumberOfExecutionCoursesWithin80100() {
        if (this.getExecutionCoursesResume() != null) {
            List<ExecutionCourseSummaryElement> executionCourses = this.getExecutionCoursesResume().get((Object)SummaryControlCategory.BETWEEN_80_100);
            return executionCourses != null ? executionCourses.size() : 0;
        }
        return 0;
    }

    public int getNumberOfExecutionCoursesWithin0100() {
        return this.getNumberOfExecutionCoursesWithin020() + this.getNumberOfExecutionCoursesWithin2040() + this.getNumberOfExecutionCoursesWithin4060() + this.getNumberOfExecutionCoursesWithin6080() + this.getNumberOfExecutionCoursesWithin80100();
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public Map<SummaryControlCategory, List<ExecutionCourseSummaryElement>> getExecutionCoursesResume() {
        return this.executionCoursesResume;
    }

    public void setExecutionCoursesResume(Map<SummaryControlCategory, List<ExecutionCourseSummaryElement>> executionCoursesResume) {
        this.executionCoursesResume = executionCoursesResume;
    }

    public ExecutionSemester getExecutionSemester() {
        return this.executionSemester;
    }

    public void setExecutionSemester(ExecutionSemester executionSemester) {
        this.executionSemester = executionSemester;
    }

    public String getSummaryControlCategoryString() {
        if (this.getSummaryControlCategory() != null) {
            return this.getSummaryControlCategory().toString();
        }
        return "";
    }

    public SummaryControlCategory getSummaryControlCategory() {
        return this.summaryControlCategory;
    }

    public void setSummaryControlCategory(SummaryControlCategory summaryControlCategory) {
        this.summaryControlCategory = summaryControlCategory;
    }

    public boolean isToDisplayCategoryLink020() {
        return this.getNumberOfExecutionCoursesWithin020() != 0 && this.getSummaryControlCategory() != SummaryControlCategory.BETWEEN_0_20;
    }

    public boolean isToDisplayCategoryLink2040() {
        return this.getNumberOfExecutionCoursesWithin2040() != 0 && this.getSummaryControlCategory() != SummaryControlCategory.BETWEEN_20_40;
    }

    public boolean isToDisplayCategoryLink4060() {
        return this.getNumberOfExecutionCoursesWithin4060() != 0 && this.getSummaryControlCategory() != SummaryControlCategory.BETWEEN_40_60;
    }

    public boolean isToDisplayCategoryLink6080() {
        return this.getNumberOfExecutionCoursesWithin6080() != 0 && this.getSummaryControlCategory() != SummaryControlCategory.BETWEEN_60_80;
    }

    public boolean isToDisplayCategoryLink80100() {
        return this.getNumberOfExecutionCoursesWithin80100() != 0 && this.getSummaryControlCategory() != SummaryControlCategory.BETWEEN_80_100;
    }

    public boolean isToDisplayCategoryLink0100() {
        return this.getNumberOfExecutionCoursesWithin0100() != 0 && this.getSummaryControlCategory() != null;
    }

    public static enum SummaryControlCategory {
        BETWEEN_0_20,
        BETWEEN_20_40,
        BETWEEN_40_60,
        BETWEEN_60_80,
        BETWEEN_80_100;

    }
}

