/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.contacts;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactValidation;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.contacts.PhysicalAddressData;
import org.fenixedu.academic.domain.contacts.PhysicalAddressValidation;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.dto.contacts.PartyContactBean;
import org.fenixedu.academic.dto.contacts.PhysicalAddressBean$callable$edit;
import org.fenixedu.academic.dto.contacts.PhysicalAddressValidationBean;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PhysicalAddressBean
extends PartyContactBean {
    private static final String CONTACT_NAME = "PhysicalAddress";
    private static final long serialVersionUID = 852136165195545415L;
    private String address;
    private String areaCode;
    private String areaOfAreaCode;
    private String area;
    private String parishOfResidence;
    private String districtSubdivisionOfResidence;
    private String districtOfResidence;
    private PhysicalAddressValidationBean validationBean;
    private Country countryOfResidence;
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public PhysicalAddressBean(Party party) {
        super(party);
    }

    public PhysicalAddressBean(PhysicalAddress physicalAddress) {
        super((PartyContact)((Object)physicalAddress));
        this.setValue(physicalAddress.getPresentationValue());
        this.setAddress(physicalAddress.getAddress());
        this.setAreaCode(physicalAddress.getAreaCode());
        this.setAreaOfAreaCode(physicalAddress.getAreaOfAreaCode());
        this.setArea(physicalAddress.getArea());
        this.setParishOfResidence(physicalAddress.getParishOfResidence());
        this.setDistrictSubdivisionOfResidence(physicalAddress.getDistrictSubdivisionOfResidence());
        this.setDistrictOfResidence(physicalAddress.getDistrictOfResidence());
        this.setCountryOfResidence(physicalAddress.getCountryOfResidence());
        if (physicalAddress.getPartyContactValidation() != null) {
            PartyContactValidation partyContactValidation = physicalAddress.getPartyContactValidation();
            PhysicalAddressValidationBean validationBean = new PhysicalAddressValidationBean((PhysicalAddressValidation)((Object)partyContactValidation));
            this.setValidationBean(validationBean);
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaOfAreaCode() {
        return this.areaOfAreaCode;
    }

    public void setAreaOfAreaCode(String areaOfAreaCode) {
        this.areaOfAreaCode = areaOfAreaCode;
    }

    public String getDistrictOfResidence() {
        return this.districtOfResidence;
    }

    public void setDistrictOfResidence(String districtOfResidence) {
        this.districtOfResidence = districtOfResidence;
    }

    public String getDistrictSubdivisionOfResidence() {
        return this.districtSubdivisionOfResidence;
    }

    public void setDistrictSubdivisionOfResidence(String districtSubdivisionOfResidence) {
        this.districtSubdivisionOfResidence = districtSubdivisionOfResidence;
    }

    public String getParishOfResidence() {
        return this.parishOfResidence;
    }

    public void setParishOfResidence(String parishOfResidence) {
        this.parishOfResidence = parishOfResidence;
    }

    public Country getCountryOfResidence() {
        return this.countryOfResidence;
    }

    public void setCountryOfResidence(Country countryOfResidence) {
        this.countryOfResidence = countryOfResidence;
    }

    @Override
    public String getContactName() {
        return CONTACT_NAME;
    }

    @Override
    public Boolean edit() {
        return (Boolean)advice$edit.perform((Callable)new PhysicalAddressBean$callable$edit(this));
    }

    static /* synthetic */ Boolean advised$edit(PhysicalAddressBean this_) {
        boolean isValueChanged = super.edit();
        if (isValueChanged) {
            ((PhysicalAddress)((Object)this_.getContact())).edit(new PhysicalAddressData(this_.getAddress(), this_.getAreaCode(), this_.getAreaOfAreaCode(), this_.getArea(), this_.getParishOfResidence(), this_.getDistrictSubdivisionOfResidence(), this_.getDistrictOfResidence(), this_.getCountryOfResidence()));
        }
        return isValueChanged;
    }

    @Override
    public PartyContact createNewContact() {
        return PhysicalAddress.createPhysicalAddress(this.getParty(), new PhysicalAddressData(this.getAddress(), this.getAreaCode(), this.getAreaOfAreaCode(), this.getArea(), this.getParishOfResidence(), this.getDistrictSubdivisionOfResidence(), this.getDistrictOfResidence(), this.getCountryOfResidence()), this.getType(), this.getDefaultContact());
    }

    public PhysicalAddressValidationBean getValidationBean() {
        return this.validationBean;
    }

    public void setValidationBean(PhysicalAddressValidationBean validationBean) {
        this.validationBean = validationBean;
    }

    @Override
    public boolean isValueChanged() {
        PhysicalAddress address = (PhysicalAddress)((Object)this.getContact());
        return !this.getAddress().equals(address.getAddress()) || !this.getArea().equals(address.getArea()) || !this.getAreaCode().equals(address.getAreaCode()) || !this.getAreaOfAreaCode().equals(address.getAreaOfAreaCode()) || !this.getParishOfResidence().equals(address.getParishOfResidence()) || !this.getDistrictSubdivisionOfResidence().equals(address.getDistrictSubdivisionOfResidence()) || !this.getDistrictOfResidence().equals(address.getDistrictOfResidence()) || !this.getCountryOfResidence().equals((Object)address.getCountryOfResidence());
    }

    @Override
    public String getPresentationValue() {
        return this.getAddress();
    }

    @Override
    public boolean isToBeValidated() {
        return PhysicalAddress.requiresValidation();
    }
}

