/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.time.calendarStructure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicSemesterCE;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicYearCE;
import org.fenixedu.academic.domain.time.chronologies.AcademicChronology;
import org.fenixedu.academic.domain.time.chronologies.dateTimeFields.AcademicSemesterDateTimeFieldType;
import org.fenixedu.academic.domain.time.chronologies.dateTimeFields.AcademicYearDateTimeFieldType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import org.joda.time.base.AbstractInterval;
import pt.ist.fenixframework.FenixFramework;

public class AcademicInterval
extends AbstractInterval
implements Serializable {
    private static final String RESUMED_SEPARATOR = "_";
    private static final String FULL_SEPARATOR = ":";
    private static final String NAME_SEPARATOR = " - ";
    public static final Comparator<AcademicInterval> COMPARATOR_BY_BEGIN_DATE = new Comparator<AcademicInterval>(){

        @Override
        public int compare(AcademicInterval o1, AcademicInterval o2) {
            int c = o1.getBeginYearMonthDayWithoutChronology().compareTo((ReadablePartial)o2.getBeginYearMonthDayWithoutChronology());
            return c == 0 ? o2.getEndDateTimeWithoutChronology().compareTo((ReadableInstant)o1.getEndDateTimeWithoutChronology()) : c;
        }
    };
    public static final Comparator<AcademicInterval> REVERSE_COMPARATOR_BY_BEGIN_DATE = new Comparator<AcademicInterval>(){

        @Override
        public int compare(AcademicInterval o1, AcademicInterval o2) {
            int c = o2.getBeginYearMonthDayWithoutChronology().compareTo((ReadablePartial)o1.getBeginYearMonthDayWithoutChronology());
            return c == 0 ? o1.getEndDateTimeWithoutChronology().compareTo((ReadableInstant)o2.getEndDateTimeWithoutChronology()) : c;
        }
    };
    private final AcademicCalendarEntry academicCalendarEntry;
    private final AcademicCalendarRootEntry academicCalendarRootEntry;

    private AcademicInterval(String entryExternalId, String academicCalendarExternalId) {
        this((AcademicCalendarEntry)FenixFramework.getDomainObject((String)entryExternalId), (AcademicCalendarRootEntry)FenixFramework.getDomainObject((String)academicCalendarExternalId));
    }

    public AcademicInterval(AcademicCalendarEntry entry, AcademicCalendarRootEntry rootEntry) {
        if (entry == null) {
            throw new DomainException("error.AcademicInterval.empty.entry.externalId", new String[0]);
        }
        if (rootEntry == null) {
            throw new DomainException("error.AcademicInterval.empty.academic.chronology.externalId", new String[0]);
        }
        this.academicCalendarEntry = entry;
        this.academicCalendarRootEntry = rootEntry;
    }

    public AcademicChronology getAcademicChronology() {
        return (AcademicChronology)this.getChronology();
    }

    public Chronology getChronology() {
        return this.getAcademicCalendar().getAcademicChronology();
    }

    public long getStartMillis() {
        return this.getAcademicCalendarEntry().getBegin().getMillis();
    }

    public long getEndMillis() {
        return this.getAcademicCalendarEntry().getEnd().getMillis();
    }

    public String getPresentationName() {
        return this.getAcademicCalendarEntry().getPresentationName();
    }

    public String getPathName() {
        String result = "";
        AcademicCalendarEntry academicCalendarEntry = this.getAcademicCalendarEntry();
        while (!(academicCalendarEntry instanceof AcademicCalendarRootEntry)) {
            result = result + academicCalendarEntry.getTitle() + NAME_SEPARATOR;
            academicCalendarEntry = academicCalendarEntry.getParentEntry();
        }
        if (result.endsWith(NAME_SEPARATOR)) {
            result = result.substring(0, result.length() - 3);
        }
        return result;
    }

    public AcademicCalendarEntry getAcademicCalendarEntryInIntervalChronology() {
        return this.getAcademicChronology().findSameEntry(this.getAcademicCalendarEntry());
    }

    public AcademicCalendarRootEntry getAcademicCalendar() {
        return this.academicCalendarRootEntry;
    }

    public AcademicCalendarEntry getAcademicCalendarEntry() {
        return this.academicCalendarEntry;
    }

    public YearMonthDay getBeginYearMonthDayWithoutChronology() {
        return this.getAcademicCalendarEntry().getBegin().toYearMonthDay();
    }

    public YearMonthDay getEndYearMonthDayWithoutChronology() {
        return this.getAcademicCalendarEntry().getEnd().toYearMonthDay();
    }

    public DateTime getStartDateTimeWithoutChronology() {
        return this.getAcademicCalendarEntry().getBegin();
    }

    public DateTime getEndDateTimeWithoutChronology() {
        return this.getAcademicCalendarEntry().getEnd();
    }

    public boolean isEqualOrEquivalent(AcademicInterval interval) {
        return this.getAcademicCalendarEntry().isEqualOrEquivalent(interval.getAcademicCalendarEntry());
    }

    public String getEntryExternalId() {
        return this.getAcademicCalendarEntry().getExternalId();
    }

    public String getAcademicCalendarExternalId() {
        return this.getAcademicCalendar().getExternalId();
    }

    public String getRepresentationInStringFormat() {
        return this.getEntryExternalId() + FULL_SEPARATOR + this.getAcademicCalendarExternalId();
    }

    public static AcademicInterval getAcademicIntervalFromString(String representationInStringFormat) {
        String[] split = representationInStringFormat.split(FULL_SEPARATOR);
        String entryExternalId = split[0];
        String academicCalendarExternalId = split[1];
        return new AcademicInterval(entryExternalId, academicCalendarExternalId);
    }

    public String getResumedRepresentationInStringFormat() {
        return this.getEntryExternalId() + RESUMED_SEPARATOR + this.getAcademicCalendarExternalId();
    }

    public static AcademicInterval getAcademicIntervalFromResumedString(String representationInStringFormat) {
        String[] split = representationInStringFormat.split(RESUMED_SEPARATOR);
        String entryExternalId = split[0];
        String academicCalendarExternalId = split[1];
        return new AcademicInterval(entryExternalId, academicCalendarExternalId);
    }

    public int getAcademicSemesterOfAcademicYear() {
        return this.getAcademicCalendarEntry().getAcademicSemesterOfAcademicYear(this.getAcademicChronology());
    }

    public AcademicSemesterCE plusSemester(int amount) {
        int index = this.getStart().get(AcademicSemesterDateTimeFieldType.academicSemester());
        return this.getAcademicChronology().getAcademicSemesterIn(index + amount);
    }

    public AcademicSemesterCE minusSemester(int amount) {
        int index = this.getStart().get(AcademicSemesterDateTimeFieldType.academicSemester());
        return this.getAcademicChronology().getAcademicSemesterIn(index - amount);
    }

    public AcademicYearCE plusYear(int amount) {
        int index = this.getStart().get(AcademicYearDateTimeFieldType.academicYear());
        return this.getAcademicChronology().getAcademicYearIn(index + amount);
    }

    public AcademicYearCE minusYear(int amount) {
        int index = this.getStart().get(AcademicYearDateTimeFieldType.academicYear());
        return this.getAcademicChronology().getAcademicYearIn(index - amount);
    }

    public AcademicInterval getChildAcademicInterval(AcademicPeriod period, int cardinal) {
        AcademicCalendarEntry entry = this.getAcademicCalendarEntry().getChildAcademicCalendarEntry(period, cardinal);
        return new AcademicInterval(entry, entry.getRootEntry());
    }

    public static int getCardinalityOfAcademicInterval(AcademicInterval child) {
        return child.getAcademicCalendarEntry().getParentEntry().getCardinalityOfCalendarEntry(child.getAcademicCalendarEntry());
    }

    public static AcademicInterval getDefaultAcademicInterval(List<AcademicInterval> academicIntervals) {
        DateTime now = new DateTime();
        AcademicInterval closest = null;
        for (AcademicInterval academicInterval : academicIntervals) {
            if (closest != null && Math.abs(academicInterval.getStart().getMillis() - now.getMillis()) <= Math.abs(closest.getStart().getMillis() - now.getMillis())) continue;
            closest = academicInterval;
        }
        return closest;
    }

    public static AcademicInterval readDefaultAcademicInterval(AcademicPeriod academicPeriod) {
        if (academicPeriod.equals((Object)AcademicPeriod.SEMESTER)) {
            return ExecutionSemester.readActualExecutionSemester().getAcademicInterval();
        }
        if (academicPeriod.equals((Object)AcademicPeriod.YEAR)) {
            return ExecutionYear.readCurrentExecutionYear().getAcademicInterval();
        }
        throw new UnsupportedOperationException("Unknown AcademicPeriod " + (Object)((Object)academicPeriod));
    }

    @Deprecated
    public static List<AcademicInterval> readAcademicIntervals(AcademicPeriod academicPeriod) {
        Bennu rootDomainObject = Bennu.getInstance();
        if (academicPeriod.equals((Object)AcademicPeriod.SEMESTER)) {
            ArrayList<AcademicInterval> result = new ArrayList<AcademicInterval>();
            for (ExecutionSemester semester : rootDomainObject.getExecutionPeriodsSet()) {
                result.add(semester.getAcademicInterval());
            }
            return result;
        }
        if (academicPeriod.equals((Object)AcademicPeriod.YEAR)) {
            ArrayList<AcademicInterval> result = new ArrayList<AcademicInterval>();
            for (ExecutionYear executionYear : rootDomainObject.getExecutionYearsSet()) {
                result.add(executionYear.getAcademicInterval());
            }
            return result;
        }
        throw new UnsupportedOperationException("Unknown AcademicPeriod " + (Object)((Object)academicPeriod));
    }

    @Deprecated
    public static List<AcademicInterval> readActiveAcademicIntervals(AcademicPeriod academicPeriod) {
        if (academicPeriod.equals((Object)AcademicPeriod.SEMESTER)) {
            ArrayList<AcademicInterval> result = new ArrayList<AcademicInterval>();
            for (ExecutionSemester semester : ExecutionSemester.readNotClosedExecutionPeriods()) {
                result.add(semester.getAcademicInterval());
            }
            return result;
        }
        if (academicPeriod.equals((Object)AcademicPeriod.YEAR)) {
            ArrayList<AcademicInterval> result = new ArrayList<AcademicInterval>();
            for (ExecutionYear executionYear : ExecutionYear.readNotClosedExecutionYears()) {
                result.add(executionYear.getAcademicInterval());
            }
            return result;
        }
        throw new UnsupportedOperationException("Unknown AcademicPeriod " + (Object)((Object)academicPeriod));
    }

    public static List<AcademicInterval> readFutureAcademicIntervals(AcademicPeriod academicPeriod) {
        if (academicPeriod.equals((Object)AcademicPeriod.SEMESTER)) {
            ArrayList<AcademicInterval> result = new ArrayList<AcademicInterval>();
            for (ExecutionSemester semester : ExecutionSemester.readNotOpenExecutionPeriods()) {
                result.add(semester.getAcademicInterval());
            }
            return result;
        }
        if (academicPeriod.equals((Object)AcademicPeriod.YEAR)) {
            ArrayList<AcademicInterval> result = new ArrayList<AcademicInterval>();
            for (ExecutionYear executionYear : ExecutionYear.readNotOpenExecutionYears()) {
                result.add(executionYear.getAcademicInterval());
            }
            return result;
        }
        throw new UnsupportedOperationException("Unknown AcademicPeriod " + (Object)((Object)academicPeriod));
    }

    public AcademicInterval getNextAcademicInterval() {
        AcademicCalendarEntry nextAcademicCalendarEntry = this.getAcademicCalendarEntry().getNextAcademicCalendarEntry();
        if (nextAcademicCalendarEntry != null) {
            return new AcademicInterval(nextAcademicCalendarEntry, this.getAcademicCalendarEntry().getRootEntry());
        }
        return null;
    }

    public AcademicInterval getPreviousAcademicInterval() {
        AcademicCalendarEntry previousAcademicCalendarEntry = this.getAcademicCalendarEntry().getPreviousAcademicCalendarEntry();
        if (previousAcademicCalendarEntry != null) {
            return new AcademicInterval(previousAcademicCalendarEntry, this.getAcademicCalendarEntry().getRootEntry());
        }
        return null;
    }
}

