/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.accounting.events.AccountingEventsManager;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.MaximumNumberOfEctsInStandaloneCurriculumGroup;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentResultType;
import org.fenixedu.academic.domain.curriculum.EnrollmentCondition;
import org.fenixedu.academic.domain.enrolment.EnroledCurriculumModuleWrapper;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.StandaloneCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanEnrolment;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.bennu.signals.DomainObjectEvent;
import org.fenixedu.bennu.signals.Signal;
import pt.ist.fenixframework.DomainObject;

public class StudentCurricularPlanStandaloneEnrolmentManager
extends StudentCurricularPlanEnrolment {
    public StudentCurricularPlanStandaloneEnrolmentManager(EnrolmentContext enrolmentContext) {
        super(enrolmentContext);
    }

    @Override
    protected void assertEnrolmentPreConditions() {
        if (this.isResponsiblePersonManager()) {
            return;
        }
        if (!this.isResponsiblePersonAllowedToEnrolStudents() && !this.isResponsibleInternationalRelationOffice()) {
            throw new DomainException("error.StudentCurricularPlan.cannot.enrol.in.propaeudeutics", new String[0]);
        }
        if (!AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.ENROLMENT_WITHOUT_RULES, (AcademicProgram)((Object)this.getStudentCurricularPlan().getDegree()), this.getResponsiblePerson().getUser())) {
            this.checkRegistrationRegime();
        }
        if (this.getRegistration().isRegistrationConclusionProcessed()) {
            this.checkUpdateRegistrationAfterConclusion();
        }
        this.checkEnrolingDegreeModules();
    }

    private void checkRegistrationRegime() {
        if (this.getRegistration().isPartialRegime(this.getExecutionYear())) {
            throw new DomainException("error.StudentCurricularPlan.with.part.time.regime.cannot.enrol", new String[0]);
        }
    }

    private void checkEnrolingDegreeModules() {
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : this.enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!degreeModuleToEvaluate.isEnroling()) continue;
            if (!degreeModuleToEvaluate.getDegreeModule().isCurricularCourse()) {
                throw new DomainException("error.StudentCurricularPlanPropaeudeuticsEnrolmentManager.can.only.enrol.in.curricularCourses", new String[0]);
            }
            this.checkIDegreeModuleToEvaluate((CurricularCourse)((Object)degreeModuleToEvaluate.getDegreeModule()));
        }
    }

    private void checkIDegreeModuleToEvaluate(CurricularCourse curricularCourse) {
        if (this.getStudentCurricularPlan().isApproved(curricularCourse, this.getExecutionSemester())) {
            throw new DomainException("error.already.aproved", curricularCourse.getName());
        }
        if (this.getStudentCurricularPlan().isEnroledInExecutionPeriod(curricularCourse, this.getExecutionSemester())) {
            throw new DomainException("error.already.enroled.in.executionPeriod", curricularCourse.getName(), this.getExecutionSemester().getQualifiedName());
        }
    }

    @Override
    protected void addEnroled() {
        if (!this.isEmptyDegree()) {
            this.addEnroledFromStudentCurricularPlan();
        }
        this.addEnroledFromStandaloneGroup();
        this.changeCurricularRuleLevel();
    }

    private void changeCurricularRuleLevel() {
        CurricularRuleLevel currentLevel = this.enrolmentContext.getCurricularRuleLevel();
        if (currentLevel.equals((Object)CurricularRuleLevel.STANDALONE_ENROLMENT_NO_RULES)) {
            this.enrolmentContext.setCurricularRuleLevel(CurricularRuleLevel.ENROLMENT_NO_RULES);
        } else {
            this.enrolmentContext.setCurricularRuleLevel(CurricularRuleLevel.ENROLMENT_WITH_RULES);
        }
    }

    private void addEnroledFromStudentCurricularPlan() {
        for (ExecutionSemester semester : this.enrolmentContext.getExecutionSemestersToEvaluate()) {
            for (IDegreeModuleToEvaluate degreeModuleToEvaluate : this.getStudentCurricularPlan().getDegreeModulesToEvaluate(semester)) {
                this.enrolmentContext.addDegreeModuleToEvaluate(degreeModuleToEvaluate);
            }
        }
    }

    private void addEnroledFromStandaloneGroup() {
        StandaloneCurriculumGroup group = this.getStudentCurricularPlan().getStandaloneCurriculumGroup();
        for (CurriculumLine curriculumLine : group.getChildCurriculumLines()) {
            for (ExecutionSemester semester : this.enrolmentContext.getExecutionSemestersToEvaluate()) {
                for (IDegreeModuleToEvaluate module : curriculumLine.getDegreeModulesToEvaluate(semester)) {
                    this.enrolmentContext.addDegreeModuleToEvaluate(module);
                }
            }
        }
    }

    @Override
    protected Map<IDegreeModuleToEvaluate, Set<ICurricularRule>> getRulesToEvaluate() {
        if (!this.enrolmentContext.hasDegreeModulesToEvaluate()) {
            return Collections.emptyMap();
        }
        HashMap<IDegreeModuleToEvaluate, Set<ICurricularRule>> result = new HashMap<IDegreeModuleToEvaluate, Set<ICurricularRule>>();
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : this.enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!degreeModuleToEvaluate.isEnroling() || !degreeModuleToEvaluate.getDegreeModule().isCurricularCourse()) continue;
            result.put(degreeModuleToEvaluate, Collections.emptySet());
        }
        return result;
    }

    @Override
    protected RuleResult evaluateExtraRules(RuleResult actualResult) {
        if (actualResult.isFalse()) {
            return actualResult;
        }
        if (this.isEmptyDegree()) {
            return actualResult.and(new MaximumNumberOfEctsInStandaloneCurriculumGroup(this.getStandaloneCurriculumGroup()).evaluate(this.getEnroledCurriculumGroup(), this.enrolmentContext));
        }
        return actualResult;
    }

    private boolean isEmptyDegree() {
        return this.getStudentCurricularPlan().isEmptyDegree();
    }

    private IDegreeModuleToEvaluate getEnroledCurriculumGroup() {
        return new EnroledCurriculumModuleWrapper((CurriculumModule)((Object)this.getRoot()), this.getExecutionSemester());
    }

    private StandaloneCurriculumGroup getStandaloneCurriculumGroup() {
        return this.getStudentCurricularPlan().getStandaloneCurriculumGroup();
    }

    @Override
    protected void performEnrolments(Map<EnrolmentResultType, List<IDegreeModuleToEvaluate>> degreeModulesToEnrolMap) {
        HashSet enrolmentsToNotify = Sets.newHashSet();
        for (Map.Entry<EnrolmentResultType, List<IDegreeModuleToEvaluate>> entry : degreeModulesToEnrolMap.entrySet()) {
            for (IDegreeModuleToEvaluate degreeModuleToEvaluate : entry.getValue()) {
                if (!degreeModuleToEvaluate.isEnroling() || !degreeModuleToEvaluate.getDegreeModule().isCurricularCourse()) continue;
                CurricularCourse curricularCourse = (CurricularCourse)((Object)degreeModuleToEvaluate.getDegreeModule());
                this.checkIDegreeModuleToEvaluate(curricularCourse);
                Enrolment enrolment = new Enrolment(this.getStudentCurricularPlan(), degreeModuleToEvaluate.getCurriculumGroup(), curricularCourse, this.getExecutionSemester(), EnrollmentCondition.VALIDATED, this.getResponsiblePerson().getUsername());
                enrolmentsToNotify.add(enrolment);
            }
        }
        if (this.getStudentCurricularPlan().getRegistration().getRegistrationProtocol().isToPayGratuity()) {
            new AccountingEventsManager().createStandaloneEnrolmentGratuityEvent(this.getStudentCurricularPlan(), this.getExecutionYear());
        }
        for (Enrolment enrolment : enrolmentsToNotify) {
            Signal.emit((String)"STANDALONE_ENROLMENT", (Object)new DomainObjectEvent((DomainObject)enrolment));
        }
        this.getRegistration().updateEnrolmentDate(this.getExecutionYear());
    }

    @Override
    protected void unEnrol() {
        for (CurriculumModule curriculumModule : this.enrolmentContext.getToRemove()) {
            if (!curriculumModule.isLeaf()) continue;
            TreasuryBridgeAPIFactory.implementation().standaloneUnenrolment((Enrolment)((Object)curriculumModule));
            curriculumModule.delete();
        }
        for (CurriculumModule curriculumModule : this.enrolmentContext.getToRemove()) {
            if (curriculumModule.isLeaf()) continue;
            curriculumModule.delete();
        }
    }
}

