/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student.curriculum;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.curriculum.AverageType;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;
import org.joda.time.YearMonthDay;
import org.joda.time.base.AbstractPartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Curriculum
implements Serializable,
ICurriculum {
    private static final Logger logger = LoggerFactory.getLogger(Curriculum.class);
    private static final long serialVersionUID = -8365985725904139675L;
    private static Supplier<CurricularYearCalculator> CURRICULAR_YEAR_CALCULATOR = () -> new CurricularYearCalculator(){
        private BigDecimal approvedCredits;
        private BigDecimal remainingCredits;
        private Integer curricularYear;
        private Integer totalCurricularYears;

        @Override
        public Integer curricularYear(Curriculum curriculum) {
            if (this.curricularYear == null) {
                this.doCalculus(curriculum);
            }
            return this.curricularYear;
        }

        @Override
        public Integer totalCurricularYears(Curriculum curriculum) {
            if (this.totalCurricularYears == null) {
                this.doCalculus(curriculum);
            }
            return this.totalCurricularYears;
        }

        @Override
        public BigDecimal approvedCredits(Curriculum curriculum) {
            if (this.approvedCredits == null) {
                this.doCalculus(curriculum);
            }
            return this.approvedCredits;
        }

        @Override
        public BigDecimal remainingCredits(Curriculum curriculum) {
            if (this.remainingCredits == null) {
                this.doCalculus(curriculum);
            }
            return this.remainingCredits;
        }

        private void doCalculus(Curriculum curriculum) {
            StudentCurricularPlan scp = curriculum.getStudentCurricularPlan();
            this.totalCurricularYears = scp == null ? 0 : scp.getDegreeCurricularPlan().getDurationInYears(this.getCycleType(curriculum));
            this.approvedCredits = BigDecimal.ZERO;
            for (ICurriculumEntry entry : curriculum.getCurricularYearEntries()) {
                this.approvedCredits = this.approvedCredits.add(entry.getEctsCreditsForCurriculum());
            }
            this.accountForDirectIngressions(curriculum);
            if (this.approvedCredits.compareTo(BigDecimal.ZERO) == 0) {
                this.curricularYear = 1;
            } else {
                BigDecimal ectsCreditsCurricularYear = curriculum.getSumEctsCredits().add(BigDecimal.valueOf(24L)).divide(BigDecimal.valueOf(60L), 5, RoundingMode.HALF_EVEN).add(BigDecimal.valueOf(1L));
                this.curricularYear = Math.min(ectsCreditsCurricularYear.intValue(), this.totalCurricularYears);
            }
            this.remainingCredits = BigDecimal.ZERO;
            for (ICurriculumEntry entry : curriculum.getCurricularYearEntries()) {
                Dismissal dismissal;
                if (!(entry instanceof Dismissal) || !(dismissal = (Dismissal)entry).getCredits().isCredits() && !dismissal.getCredits().isEquivalence() && (!dismissal.isCreditsDismissal() || dismissal.getCredits().isSubstitution())) continue;
                this.remainingCredits = this.remainingCredits.add(entry.getEctsCreditsForCurriculum());
            }
        }

        private void accountForDirectIngressions(Curriculum curriculum) {
            if (this.getCycleType(curriculum) != null) {
                return;
            }
            if (!curriculum.getStudentCurricularPlan().getDegreeCurricularPlan().isBolonhaDegree()) {
                return;
            }
            if (curriculum.getStudentCurricularPlan().getCycleCurriculumGroups().isEmpty()) {
                return;
            }
            CycleCurriculumGroup sgroup = Collections.min(curriculum.getStudentCurricularPlan().getCycleCurriculumGroups(), CycleCurriculumGroup.COMPARATOR_BY_CYCLE_TYPE_AND_ID);
            for (CycleType cycleIter = sgroup.getCycleType().getPrevious(); cycleIter != null; cycleIter = cycleIter.getPrevious()) {
                if (curriculum.getStudentCurricularPlan().getDegreeCurricularPlan().getCycleCourseGroup(cycleIter) == null) continue;
                this.approvedCredits = this.approvedCredits.add(new BigDecimal(cycleIter.getEctsCredits()));
            }
        }

        private CycleType getCycleType(Curriculum curriculum) {
            if (!curriculum.hasCurriculumModule() || !curriculum.isBolonha().booleanValue()) {
                return null;
            }
            CurriculumModule module = curriculum.getCurriculumModule();
            CycleType cycleType = module.isCycleCurriculumGroup() ? ((CycleCurriculumGroup)((Object)module)).getCycleType() : null;
            return cycleType;
        }
    };
    private static Supplier<CurriculumGradeCalculator> CURRICULUM_GRADE_CALCULATOR = () -> new CurriculumGradeCalculator(){
        private BigDecimal sumPiCi;
        private BigDecimal sumPi;
        private Grade rawGrade;
        private Grade finalGrade;

        private void doCalculus(Curriculum curriculum) {
            this.sumPiCi = BigDecimal.ZERO;
            this.sumPi = BigDecimal.ZERO;
            this.countAverage(curriculum.averageEnrolmentRelatedEntries, curriculum.getAverageType());
            this.countAverage(curriculum.averageDismissalRelatedEntries, curriculum.getAverageType());
            BigDecimal avg = this.calculateAverage();
            this.rawGrade = Grade.createGrade(avg.setScale(2, RoundingMode.HALF_UP).toString(), GradeScale.TYPE20);
            this.finalGrade = Grade.createGrade(avg.setScale(0, RoundingMode.HALF_UP).toString(), GradeScale.TYPE20);
        }

        private void countAverage(Set<ICurriculumEntry> entries, AverageType averageType) {
            for (ICurriculumEntry entry : entries) {
                if (!entry.getGrade().isNumeric()) continue;
                BigDecimal weigth = entry.getWeigthForCurriculum();
                if (averageType == AverageType.WEIGHTED) {
                    this.sumPi = this.sumPi.add(weigth);
                    this.sumPiCi = this.sumPiCi.add(entry.getWeigthForCurriculum().multiply(entry.getGrade().getNumericValue()));
                    continue;
                }
                if (averageType == AverageType.SIMPLE) {
                    this.sumPi = this.sumPi.add(BigDecimal.ONE);
                    this.sumPiCi = this.sumPiCi.add(entry.getGrade().getNumericValue());
                    continue;
                }
                throw new DomainException("Curriculum.average.type.not.supported", new String[0]);
            }
        }

        private BigDecimal calculateAverage() {
            return this.sumPi.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : this.sumPiCi.divide(this.sumPi, 5, RoundingMode.HALF_UP);
        }

        @Override
        public Grade rawGrade(Curriculum curriculum) {
            if (this.rawGrade == null) {
                this.doCalculus(curriculum);
            }
            return this.rawGrade;
        }

        @Override
        public Grade finalGrade(Curriculum curriculum) {
            if (this.finalGrade == null) {
                this.doCalculus(curriculum);
            }
            return this.finalGrade;
        }

        @Override
        public BigDecimal weigthedGradeSum(Curriculum curriculum) {
            if (this.sumPiCi == null) {
                this.doCalculus(curriculum);
            }
            return this.sumPiCi;
        }
    };
    private static Supplier<CurriculumEntryPredicate> CURRICULUM_ENTRY_PREDICATE = () -> new CurriculumEntryPredicate(){

        @Override
        public boolean test(ICurriculumEntry input) {
            return true;
        }
    };
    private CurriculumModule curriculumModule;
    private Boolean bolonhaDegree;
    private final ExecutionYear executionYear;
    private final Set<ICurriculumEntry> averageEnrolmentRelatedEntries = new HashSet<ICurriculumEntry>();
    private final Set<ICurriculumEntry> averageDismissalRelatedEntries = new HashSet<ICurriculumEntry>();
    private final Set<ICurriculumEntry> curricularYearEntries = new HashSet<ICurriculumEntry>();
    private AverageType averageType = AverageType.WEIGHTED;
    private CurricularYearCalculator curricularYearCalculator = CURRICULAR_YEAR_CALCULATOR.get();
    private CurriculumGradeCalculator gradeCalculator = CURRICULUM_GRADE_CALCULATOR.get();

    public static CurricularYearCalculator getCurricularYearCalculator() {
        return CURRICULAR_YEAR_CALCULATOR.get();
    }

    public static void setCurricularYearCalculator(Supplier<CurricularYearCalculator> input) {
        if (input != null && input.get() != null) {
            CURRICULAR_YEAR_CALCULATOR = input;
        } else {
            logger.error("Could not set CURRICULAR_YEAR_CALCULATOR to null");
        }
    }

    public static CurriculumGradeCalculator getCurriculumGradeCalculator() {
        return CURRICULUM_GRADE_CALCULATOR.get();
    }

    public CurriculumGradeCalculator getGradeCalculator() {
        return this.gradeCalculator;
    }

    public static void setCurriculumGradeCalculator(Supplier<CurriculumGradeCalculator> input) {
        if (input != null && input.get() != null) {
            CURRICULUM_GRADE_CALCULATOR = input;
        } else {
            logger.error("Could not set CURRICULUM_GRADE_CALCULATOR to null");
        }
    }

    public static CurriculumEntryPredicate getCurriculumEntryPredicate() {
        return CURRICULUM_ENTRY_PREDICATE.get();
    }

    public static void setCurriculumEntryPredicate(Supplier<CurriculumEntryPredicate> input) {
        if (input != null && input.get() != null) {
            CURRICULUM_ENTRY_PREDICATE = input;
        } else {
            logger.error("Could not set CURRICULUM_ENTRY_PREDICATE to null");
        }
    }

    public static Curriculum createEmpty(ExecutionYear executionYear) {
        return Curriculum.createEmpty(null, executionYear);
    }

    public static Curriculum createEmpty(CurriculumModule curriculumModule, ExecutionYear executionYear) {
        return new Curriculum(curriculumModule, executionYear);
    }

    private Curriculum(CurriculumModule curriculumModule, ExecutionYear executionYear) {
        this.curriculumModule = curriculumModule;
        this.bolonhaDegree = curriculumModule == null ? null : Boolean.valueOf(curriculumModule.getStudentCurricularPlan().isBolonhaDegree());
        this.executionYear = executionYear;
    }

    public Curriculum(CurriculumModule curriculumModule, ExecutionYear executionYear, Collection<ICurriculumEntry> averageEnrolmentRelatedEntries, Collection<ICurriculumEntry> averageDismissalRelatedEntries, Collection<ICurriculumEntry> curricularYearEntries) {
        this(curriculumModule, executionYear);
        this.addAverageEntries(this.averageEnrolmentRelatedEntries, averageEnrolmentRelatedEntries);
        this.addAverageEntries(this.averageDismissalRelatedEntries, averageDismissalRelatedEntries);
        this.addCurricularYearEntries(this.curricularYearEntries, curricularYearEntries);
    }

    public void add(Curriculum curriculum) {
        if (!this.hasCurriculumModule()) {
            this.curriculumModule = curriculum.getCurriculumModule();
            this.bolonhaDegree = curriculum.isBolonha();
        }
        this.addAverageEntries(this.averageEnrolmentRelatedEntries, curriculum.getEnrolmentRelatedEntries());
        this.addAverageEntries(this.averageDismissalRelatedEntries, curriculum.getDismissalRelatedEntries());
        this.addCurricularYearEntries(this.curricularYearEntries, curriculum.getCurricularYearEntries());
        this.curricularYearCalculator = Curriculum.getCurricularYearCalculator();
        this.gradeCalculator = Curriculum.getCurriculumGradeCalculator();
    }

    private void addAverageEntries(Set<ICurriculumEntry> entries, Collection<ICurriculumEntry> newEntries) {
        for (ICurriculumEntry newEntry : newEntries) {
            if (this.isAlreadyAverageEntry(newEntry)) continue;
            this.add(entries, newEntry);
        }
    }

    private boolean isAlreadyAverageEntry(ICurriculumEntry newEntry) {
        return this.averageEnrolmentRelatedEntries.contains(newEntry) || this.averageDismissalRelatedEntries.contains(newEntry);
    }

    private void addCurricularYearEntries(Set<ICurriculumEntry> entries, Collection<ICurriculumEntry> newEntries) {
        for (ICurriculumEntry newEntry : newEntries) {
            this.add(entries, newEntry);
        }
    }

    private void add(Set<ICurriculumEntry> entries, ICurriculumEntry newEntry) {
        if ((this.isBolonha().booleanValue() || !this.isAlreadyCurricularYearEntry(newEntry)) && Curriculum.getCurriculumEntryPredicate().test(newEntry)) {
            entries.add(newEntry);
        }
    }

    private boolean isAlreadyCurricularYearEntry(ICurriculumEntry newEntry) {
        if (newEntry instanceof IEnrolment) {
            return this.isCurricularYearEntryAsEnrolmentOrAsSourceEnrolment((IEnrolment)newEntry);
        }
        if (newEntry instanceof Dismissal) {
            return this.isCurricularYearEntryAsSimilarDismissal((Dismissal)newEntry);
        }
        return false;
    }

    private boolean isCurricularYearEntryAsEnrolmentOrAsSourceEnrolment(IEnrolment newIEnrolment) {
        for (ICurriculumEntry entry : this.curricularYearEntries) {
            if (entry instanceof Dismissal && ((Dismissal)entry).hasSourceIEnrolments(newIEnrolment)) {
                return true;
            }
            if (entry != newIEnrolment) continue;
            return true;
        }
        return false;
    }

    private boolean isCurricularYearEntryAsSimilarDismissal(Dismissal newDismissal) {
        for (ICurriculumEntry entry : this.curricularYearEntries) {
            if (!(entry instanceof Dismissal) || newDismissal.isCreditsDismissal() || !newDismissal.isSimilar((Dismissal)entry)) continue;
            return true;
        }
        return false;
    }

    public CurriculumModule getCurriculumModule() {
        return this.curriculumModule;
    }

    public boolean hasCurriculumModule() {
        return this.getCurriculumModule() != null;
    }

    public Boolean isBolonha() {
        return this.bolonhaDegree;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    @Override
    public StudentCurricularPlan getStudentCurricularPlan() {
        return this.hasCurriculumModule() ? this.getCurriculumModule().getStudentCurricularPlan() : null;
    }

    public boolean hasAverageEntry() {
        return this.hasCurriculumModule() && !this.getCurriculumEntries().isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return !this.hasCurriculumModule() || this.getCurriculumEntries().isEmpty() && this.curricularYearEntries.isEmpty();
    }

    @Override
    public Collection<ICurriculumEntry> getCurriculumEntries() {
        HashSet<ICurriculumEntry> result = new HashSet<ICurriculumEntry>();
        result.addAll(this.averageEnrolmentRelatedEntries);
        result.addAll(this.averageDismissalRelatedEntries);
        return result;
    }

    @Override
    public boolean hasAnyExternalApprovedEnrolment() {
        for (ICurriculumEntry entry : this.averageDismissalRelatedEntries) {
            if (!(entry instanceof ExternalEnrolment)) continue;
            return true;
        }
        return false;
    }

    public Set<ICurriculumEntry> getEnrolmentRelatedEntries() {
        return this.averageEnrolmentRelatedEntries;
    }

    public Set<ICurriculumEntry> getDismissalRelatedEntries() {
        return this.averageDismissalRelatedEntries;
    }

    @Override
    public Set<ICurriculumEntry> getCurricularYearEntries() {
        return this.curricularYearEntries;
    }

    @Override
    public ExecutionYear getLastExecutionYear() {
        return this.getCurricularYearEntries().stream().filter(i -> {
            if (i.getExecutionYear() == null) {
                logger.warn(String.format("Null Execution Year! %s\n", i.getExternalId()));
                return false;
            }
            return true;
        }).map(i -> i.getExecutionYear()).max(ExecutionYear::compareTo).orElse(null);
    }

    @Override
    public YearMonthDay getLastApprovementDate() {
        return this.getCurricularYearEntries().stream().filter(i -> {
            if (i.getApprovementDate() == null) {
                logger.warn(String.format("Null Approvement Date! %s\n", i.getExternalId()));
                return false;
            }
            return true;
        }).map(i -> i.getApprovementDate()).max(AbstractPartial::compareTo).orElse(null);
    }

    @Deprecated
    public BigDecimal getWeigthedGradeSum() {
        return this.getGradeCalculator().weigthedGradeSum(this);
    }

    @Override
    public Grade getRawGrade() {
        return this.getGradeCalculator().rawGrade(this);
    }

    @Override
    public Grade getFinalGrade() {
        return this.getGradeCalculator().finalGrade(this);
    }

    @Override
    public BigDecimal getSumEctsCredits() {
        return this.curricularYearCalculator.approvedCredits(this);
    }

    @Override
    public Integer getCurricularYear() {
        return this.curricularYearCalculator.curricularYear(this);
    }

    @Override
    public BigDecimal getRemainingCredits() {
        return this.curricularYearCalculator.remainingCredits(this);
    }

    @Override
    @Deprecated
    public void setAverageType(AverageType averageType) {
        this.averageType = averageType;
        this.gradeCalculator = Curriculum.getCurriculumGradeCalculator();
    }

    @Deprecated
    public AverageType getAverageType() {
        return this.averageType;
    }

    @Override
    public Integer getTotalCurricularYears() {
        return this.curricularYearCalculator.totalCurricularYears(this);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("\n[CURRICULUM]");
        if (this.hasCurriculumModule()) {
            result.append("\n[CURRICULUM_MODULE][ID] " + this.getCurriculumModule().getExternalId() + "\t[NAME]" + this.getCurriculumModule().getName().getContent());
            result.append("\n[BOLONHA] " + this.isBolonha().toString());
        } else {
            result.append("\n[NO CURRICULUM_MODULE]");
        }
        result.append("\n[SUM ENTRIES] " + (this.averageEnrolmentRelatedEntries.size() + this.averageDismissalRelatedEntries.size()));
        result.append("\n[RAW GRADE] " + this.getRawGrade().getValue());
        result.append("\n[FINAL GRADE] " + this.getFinalGrade().getValue());
        result.append("\n[SUM ECTS CREDITS] " + this.getSumEctsCredits().toString());
        result.append("\n[CURRICULAR YEAR] " + this.getCurricularYear());
        result.append("\n[REMAINING CREDITS] " + this.getRemainingCredits().toString());
        result.append("\n[TOTAL CURRICULAR YEARS] " + this.getTotalCurricularYears());
        result.append("\n[AVERAGE ENROLMENT ENTRIES]");
        for (ICurriculumEntry entry : this.averageEnrolmentRelatedEntries) {
            result.append("\n[ENTRY] [NAME]" + entry.getName().getContent() + "\t[CREATION_DATE]" + entry.getCreationDateDateTime() + "\t[GRADE] " + entry.getGrade().toString() + "\t[WEIGHT] " + entry.getWeigthForCurriculum() + "\t[ECTS] " + entry.getEctsCreditsForCurriculum() + "\t[CLASS_NAME] " + entry.getClass().getSimpleName());
        }
        result.append("\n[AVERAGE DISMISSAL RELATED ENTRIES]");
        for (ICurriculumEntry entry : this.averageDismissalRelatedEntries) {
            result.append("\n[ENTRY] [NAME]" + entry.getName().getContent() + "\t[CREATION_DATE]" + entry.getCreationDateDateTime() + "\t[GRADE] " + entry.getGrade().toString() + "\t[WEIGHT] " + entry.getWeigthForCurriculum() + "\t[ECTS] " + entry.getEctsCreditsForCurriculum() + "\t[CLASS_NAME] " + entry.getClass().getSimpleName());
        }
        result.append("\n[CURRICULAR YEAR ENTRIES]");
        for (ICurriculumEntry entry : this.curricularYearEntries) {
            result.append("\n[ENTRY] [NAME]" + entry.getName().getContent() + "\t[CREATION_DATE]" + entry.getCreationDateDateTime() + "\t[ECTS] " + entry.getEctsCreditsForCurriculum() + "\t[CLASS_NAME] " + entry.getClass().getSimpleName());
        }
        return result.toString();
    }

    public void removeFromAllCurriculumEntries(ICurriculumEntry entryToRemove) {
        this.averageEnrolmentRelatedEntries.remove(entryToRemove);
        this.averageDismissalRelatedEntries.remove(entryToRemove);
        this.curricularYearEntries.remove(entryToRemove);
    }

    public static abstract class CurriculumEntryPredicate
    implements Predicate<ICurriculumEntry> {
    }

    public static interface CurriculumGradeCalculator {
        public Grade rawGrade(Curriculum var1);

        public Grade finalGrade(Curriculum var1);

        @Deprecated
        public BigDecimal weigthedGradeSum(Curriculum var1);
    }

    public static interface CurricularYearCalculator {
        public Integer curricularYear(Curriculum var1);

        public Integer totalCurricularYears(Curriculum var1);

        public BigDecimal approvedCredits(Curriculum var1);

        public BigDecimal remainingCredits(Curriculum var1);
    }
}

