/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;

public class SearchStudentsWithEnrolmentsByDepartment
implements Serializable {
    private Department departmentDomainReference;
    private Set<Degree> degreeDomainReferences;
    private ExecutionYear executionYearDomainReference;

    public SearchStudentsWithEnrolmentsByDepartment(Department department) {
        this.departmentDomainReference = department;
    }

    public Department getDepartment() {
        return this.departmentDomainReference;
    }

    public List<Degree> getDegrees() {
        ArrayList<Degree> degrees = new ArrayList<Degree>();
        if (this.degreeDomainReferences != null) {
            for (Degree degreeDomainReference : this.degreeDomainReferences) {
                degrees.add(degreeDomainReference);
            }
        }
        Collections.sort(degrees, Degree.COMPARATOR_BY_DEGREE_TYPE_AND_NAME_AND_ID);
        return degrees;
    }

    public void setDegrees(List<Degree> degrees) {
        if (degrees != null) {
            this.degreeDomainReferences = new HashSet<Degree>();
            for (Degree degree : degrees) {
                this.degreeDomainReferences.add(degree);
            }
        } else {
            this.degreeDomainReferences = null;
        }
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYearDomainReference;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYearDomainReference = executionYear;
    }

    public Set<StudentCurricularPlan> search() {
        ExecutionYear executionYear = this.getExecutionYear();
        HashSet<StudentCurricularPlan> studentCurricularPlans = new HashSet<StudentCurricularPlan>();
        if (this.degreeDomainReferences != null) {
            Iterator<Degree> iterator = this.degreeDomainReferences.iterator();
            while (iterator.hasNext()) {
                Degree degreeDomainReference;
                Degree degree = degreeDomainReference = iterator.next();
                for (DegreeCurricularPlan degreeCurricularPlan : degree.getDegreeCurricularPlansSet()) {
                    if (!degreeCurricularPlan.isActive()) continue;
                    for (StudentCurricularPlan studentCurricularPlan : degreeCurricularPlan.getStudentCurricularPlansSet()) {
                        if (!studentCurricularPlan.hasEnrolments(executionYear)) continue;
                        studentCurricularPlans.add(studentCurricularPlan);
                    }
                }
            }
        }
        return studentCurricularPlans;
    }

    public Set<StudentCurricularPlan> getSearch() {
        return this.search();
    }
}

