/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.StudentGroup;
import org.fenixedu.academic.domain.student.GroupEnrolment$callable$run;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.InvalidArgumentsServiceException;
import org.fenixedu.academic.service.services.exceptions.InvalidSituationServiceException;
import org.fenixedu.academic.service.services.exceptions.InvalidStudentNumberServiceException;
import org.fenixedu.academic.service.services.exceptions.NoChangeMadeServiceException;
import org.fenixedu.academic.service.services.exceptions.NonExistingServiceException;
import org.fenixedu.academic.service.services.exceptions.NonValidChangeServiceException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.strategy.groupEnrolment.strategys.GroupEnrolmentStrategyFactory;
import org.fenixedu.academic.service.strategy.groupEnrolment.strategys.IGroupEnrolmentStrategy;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class GroupEnrolment {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static Boolean run(String string, String string2, Integer n, List<String> list, String string3) throws FenixServiceException {
        return (Boolean)advice$run.perform((Callable)new GroupEnrolment$callable$run(string, string2, n, list, string3));
    }

    static /* synthetic */ Boolean advised$run(String groupingID, String shiftID, Integer groupNumber, List<String> studentUsernames, String studentUsername) throws FenixServiceException {
        AccessControl.check(RolePredicates.STUDENT_AND_TEACHER_PREDICATE);
        return GroupEnrolment.enrole(groupingID, shiftID, groupNumber, studentUsernames, studentUsername);
    }

    public static Boolean enrole(String groupingID, String shiftID, Integer groupNumber, List<String> studentUsernames, String studentUsername) throws FenixServiceException {
        Bennu rootDomainObject = Bennu.getInstance();
        Grouping grouping = (Grouping)FenixFramework.getDomainObject((String)groupingID);
        if (grouping == null) {
            throw new NonExistingServiceException();
        }
        Registration userStudent = Registration.readByUsername(studentUsername);
        GroupEnrolmentStrategyFactory enrolmentGroupPolicyStrategyFactory = GroupEnrolmentStrategyFactory.getInstance();
        IGroupEnrolmentStrategy strategy = enrolmentGroupPolicyStrategyFactory.getGroupEnrolmentStrategyInstance(grouping);
        if (grouping.getStudentAttend(studentUsername) == null) {
            throw new NoChangeMadeServiceException();
        }
        Shift shift = null;
        if (shiftID != null) {
            shift = (Shift)FenixFramework.getDomainObject((String)shiftID);
        }
        HashSet<String> allStudentsUsernames = new HashSet<String>(studentUsernames);
        allStudentsUsernames.add(studentUsername);
        Integer result = strategy.enrolmentPolicyNewGroup(grouping, allStudentsUsernames.size(), shift);
        if (result.equals(-1)) {
            throw new InvalidArgumentsServiceException();
        }
        if (result.equals(-2)) {
            throw new NonValidChangeServiceException();
        }
        if (result.equals(-3)) {
            throw new NotAuthorizedException();
        }
        Attends userAttend = grouping.getStudentAttend(userStudent);
        if (userAttend == null) {
            throw new InvalidStudentNumberServiceException();
        }
        if (strategy.checkAlreadyEnroled(grouping, studentUsername)) {
            throw new InvalidSituationServiceException();
        }
        StudentGroup newStudentGroup = grouping.readStudentGroupBy(groupNumber);
        if (newStudentGroup != null) {
            throw new FenixServiceException();
        }
        if (!strategy.checkStudentsUserNamesInGrouping(studentUsernames, grouping)) {
            throw new InvalidStudentNumberServiceException();
        }
        GroupEnrolment.checkStudentUsernamesAlreadyEnroledInStudentGroup(strategy, studentUsernames, grouping);
        newStudentGroup = new StudentGroup(groupNumber, grouping, shift);
        for (String studentUsernameIter : studentUsernames) {
            Attends attend = grouping.getStudentAttend(studentUsernameIter);
            attend.addStudentGroups(newStudentGroup);
        }
        userAttend.addStudentGroups(newStudentGroup);
        grouping.addStudentGroups(newStudentGroup);
        return true;
    }

    private static void checkStudentUsernamesAlreadyEnroledInStudentGroup(IGroupEnrolmentStrategy strategy, List<String> studentUsernames, Grouping grouping) throws FenixServiceException {
        for (String studentUsername : studentUsernames) {
            if (!strategy.checkAlreadyEnroled(grouping, studentUsername)) continue;
            throw new InvalidSituationServiceException();
        }
    }
}

