/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.candidacy;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.alert.PhdCandidacyRefereeAlert;
import org.fenixedu.academic.domain.phd.candidacy.InstitutionPhdCandidacyPeriod;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyReferee$callable$sendEmail;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeBean;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyReferee_Base;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PhdCandidacyReferee
extends PhdCandidacyReferee_Base {
    public static final Advice advice$sendEmail = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    private PhdCandidacyReferee() {
    }

    public PhdCandidacyReferee(PhdProgramCandidacyProcess process2, PhdCandidacyRefereeBean bean) {
        this();
        String[] args = new String[]{};
        if (process2 == null) {
            throw new DomainException("error.PhdCandidacyReferee.invalid.process", args);
        }
        String obj = bean.getName();
        String[] args1 = new String[]{};
        if (obj == null || obj.isEmpty()) {
            throw new DomainException("error.PhdCandidacyReferee.invalid.name", args1);
        }
        String obj1 = bean.getEmail();
        String[] args2 = new String[]{};
        if (obj1 == null || obj1.isEmpty()) {
            throw new DomainException("error.PhdCandidacyReferee.invalid.email", args2);
        }
        if (process2.getCandidacyRefereeByEmail(bean.getEmail()) != null) {
            throw new DomainException("error.PhdCandidacyReferee.for.email.exists", new String[0]);
        }
        this.setPhdProgramCandidacyProcess(process2);
        this.setName(bean.getName());
        this.setEmail(bean.getEmail());
        this.setInstitution(bean.getInstitution());
        this.setValue(UUID.randomUUID().toString());
        this.sendEmail();
    }

    public boolean hasCandidacyProcess() {
        return this.getPhdProgramCandidacyProcess() != null;
    }

    public boolean isLetterAvailable() {
        return this.getLetter() != null;
    }

    public PhdIndividualProgramProcess getIndividualProgramProcess() {
        return this.getPhdProgramCandidacyProcess().getIndividualProgramProcess();
    }

    public void sendEmail() {
        Object object = advice$sendEmail.perform((Callable)new PhdCandidacyReferee$callable$sendEmail(this));
    }

    static /* synthetic */ void advised$sendEmail(PhdCandidacyReferee this_) {
        this_.sendEmail(this_.createSubject(), this_.createBody());
    }

    private String createSubject() {
        return String.format(BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.email.subject.referee", (String[])new String[0]), this.getCandidatePerson().getName(), this.getCandidatePerson().getName());
    }

    public Person getCandidatePerson() {
        return this.getPhdProgramCandidacyProcess().getPerson();
    }

    private String createBody() {
        return this.getPhdProgramCandidacyProcess().getPublicPhdCandidacyPeriod().getEmailMessageBodyForRefereeForm(this);
    }

    public void delete() {
        this.disconnect();
        this.deleteDomainObject();
    }

    private void disconnect() {
        if (this.getLetter() != null) {
            throw new DomainException("error.PhdCandidacyReferee.has.letter", new String[0]);
        }
        this.setPhdProgramCandidacyProcess(null);
        this.setRootDomainObject(null);
        ArrayList alerts = new ArrayList();
        alerts.addAll(this.getAlertsSet());
        for (PhdCandidacyRefereeAlert phdCandidacyRefereeAlert : alerts) {
            this.removeAlerts(phdCandidacyRefereeAlert);
        }
    }

    public String getRefereeSubmissionFormLinkPt() {
        if (this.getPhdProgramCandidacyProcess().getPublicPhdCandidacyPeriod().isInstitutionCandidacyPeriod()) {
            InstitutionPhdCandidacyPeriod publicPhdCandidacyPeriod = (InstitutionPhdCandidacyPeriod)((Object)this.getPhdProgramCandidacyProcess().getPublicPhdCandidacyPeriod());
            return publicPhdCandidacyPeriod.getRefereeSubmissionFormLinkPt(this);
        }
        return null;
    }

    public String getRefereeSubmissionFormLinkEn() {
        if (this.getPhdProgramCandidacyProcess().getPublicPhdCandidacyPeriod().isInstitutionCandidacyPeriod()) {
            InstitutionPhdCandidacyPeriod publicPhdCandidacyPeriod = (InstitutionPhdCandidacyPeriod)((Object)this.getPhdProgramCandidacyProcess().getPublicPhdCandidacyPeriod());
            return publicPhdCandidacyPeriod.getRefereeSubmissionFormLinkEn(this);
        }
        return null;
    }
}

