/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.phd.PhdProgramContextPeriod$callable$closePeriod;
import org.fenixedu.academic.domain.phd.PhdProgramContextPeriod$callable$create;
import org.fenixedu.academic.domain.phd.PhdProgramContextPeriod$callable$create$1;
import org.fenixedu.academic.domain.phd.PhdProgramContextPeriod$callable$deletePeriod;
import org.fenixedu.academic.domain.phd.PhdProgramContextPeriod$callable$edit;
import org.fenixedu.academic.domain.phd.PhdProgramContextPeriodBean;
import org.fenixedu.academic.domain.phd.PhdProgramContextPeriod_Base;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PhdProgramContextPeriod
extends PhdProgramContextPeriod_Base {
    public static final Comparator<PhdProgramContextPeriod> COMPARATOR_BY_BEGIN_DATE;
    public static final Advice advice$edit;
    public static final Advice advice$closePeriod;
    public static final Advice advice$create;
    public static final Advice advice$create$1;
    public static final Advice advice$deletePeriod;

    protected PhdProgramContextPeriod() {
        this.setRootDomainObject(this.getRootDomainObject());
    }

    protected PhdProgramContextPeriod(PhdProgram phdProgram, DateTime beginPeriod, DateTime endPeriod) {
        this.init(phdProgram, beginPeriod, endPeriod);
    }

    protected void init(PhdProgram phdProgram, DateTime beginPeriod, DateTime endPeriod) {
        this.checkParameters(phdProgram, beginPeriod, endPeriod);
        this.setPhdProgram(phdProgram);
        this.setBeginDate(beginPeriod);
        this.setEndDate(endPeriod);
    }

    protected void checkParameters(PhdProgram phdProgram, DateTime beginPeriod, DateTime endPeriod) {
        if (phdProgram == null) {
            throw new DomainException("phd.PhdProgramContextPeriod.phdProgram.cannot.be.null", new String[0]);
        }
        if (beginPeriod == null) {
            throw new DomainException("phd.PhdProgramContextPeriod.beginPeriod.cannot.be.null", new String[0]);
        }
        if (endPeriod != null && !endPeriod.isAfter((ReadableInstant)beginPeriod)) {
            throw new PhdDomainOperationException("error.org.fenixedu.academic.domain.phd.PhdProgramContextPeriod.endPeriod.is.after.of.beginPeriod", new String[0]);
        }
        this.checkOverlaps(phdProgram, beginPeriod, endPeriod);
    }

    private void checkOverlaps(PhdProgram phdProgram, DateTime beginPeriod, DateTime endPeriod) {
        for (PhdProgramContextPeriod period : phdProgram.getPhdProgramContextPeriodsSet()) {
            if (period == this || !period.overlaps(beginPeriod, endPeriod)) continue;
            throw new PhdDomainOperationException("error.org.fenixedu.academic.domain.phd.PhdProgramContextPeriod.period.is.overlaping.another", new String[0]);
        }
    }

    private boolean overlaps(DateTime beginPeriod, DateTime endPeriod) {
        return this.getInterval().overlaps((ReadableInterval)new Interval((ReadableInstant)beginPeriod, (ReadableInstant)endPeriod));
    }

    public boolean contains(DateTime dateTime) {
        return this.getInterval().contains((ReadableInstant)dateTime);
    }

    public Interval getInterval() {
        return new Interval((ReadableInstant)this.getBeginDate(), (ReadableInstant)this.getEndDate());
    }

    public void edit(DateTime dateTime, DateTime dateTime2) {
        Object object = advice$edit.perform((Callable)new PhdProgramContextPeriod$callable$edit(this, dateTime, dateTime2));
    }

    static /* synthetic */ void advised$edit(PhdProgramContextPeriod this_, DateTime beginDate, DateTime endDate) {
        this_.checkParameters(this_.getPhdProgram(), beginDate, endDate);
    }

    public void closePeriod(DateTime dateTime) {
        Object object = advice$closePeriod.perform((Callable)new PhdProgramContextPeriod$callable$closePeriod(this, dateTime));
    }

    static /* synthetic */ void advised$closePeriod(PhdProgramContextPeriod this_, DateTime endPeriod) {
        if (endPeriod == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.phd.PhdProgramContextPeriod.endPeriod.cannot.be.null", new String[0]);
        }
        this_.setEndDate(endPeriod);
    }

    public static PhdProgramContextPeriod create(PhdProgram phdProgram, DateTime dateTime, DateTime dateTime2) {
        return (PhdProgramContextPeriod)((Object)advice$create.perform((Callable)new PhdProgramContextPeriod$callable$create(phdProgram, dateTime, dateTime2)));
    }

    static /* synthetic */ PhdProgramContextPeriod advised$create(PhdProgram phdProgram, DateTime beginPeriod, DateTime endPeriod) {
        return new PhdProgramContextPeriod(phdProgram, beginPeriod, endPeriod);
    }

    public static PhdProgramContextPeriod create(PhdProgramContextPeriodBean phdProgramContextPeriodBean) {
        return (PhdProgramContextPeriod)((Object)advice$create$1.perform((Callable)new PhdProgramContextPeriod$callable$create$1(phdProgramContextPeriodBean)));
    }

    static /* synthetic */ PhdProgramContextPeriod advised$create(PhdProgramContextPeriodBean bean) {
        return PhdProgramContextPeriod.create(bean.getPhdProgram(), bean.getBeginDateAtMidnight(), bean.getEndDateBeforeMidnight());
    }

    public void deletePeriod() {
        Object object = advice$deletePeriod.perform((Callable)new PhdProgramContextPeriod$callable$deletePeriod(this));
    }

    static /* synthetic */ void advised$deletePeriod(PhdProgramContextPeriod this_) {
        this_.delete();
    }

    private void delete() {
        this.setPhdProgram(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$closePeriod = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$deletePeriod = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_BEGIN_DATE = new Comparator<PhdProgramContextPeriod>(){

            @Override
            public int compare(PhdProgramContextPeriod o1, PhdProgramContextPeriod o2) {
                return o1.getBeginDate().compareTo((ReadableInstant)o2.getBeginDate());
            }
        };
    }
}

