/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degreeStructure;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.degreeStructure.BibliographicReferences;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformation;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformationChangeRequest$callable$approve;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformationChangeRequest$callable$reject;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformationChangeRequest_Base;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLevel;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLoad;
import org.fenixedu.academic.domain.degreeStructure.RegimeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.CompetenceCourseGroupUnit;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.domain.organizationalStructure.ScientificAreaUnit;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicPeriod;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.services.bolonhaManager.CompetenceCourseManagementAccessControl;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CompetenceCourseInformationChangeRequest
extends CompetenceCourseInformationChangeRequest_Base {
    public static final Advice advice$reject = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$approve = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public CompetenceCourseInformationChangeRequest() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public CompetenceCourseInformationChangeRequest(CompetenceCourseInformation information, String justification, Person requester) {
        this(information.getName(), information.getNameEn(), justification, information.getRegime(), information.getObjectives(), information.getObjectivesEn(), information.getProgram(), information.getProgramEn(), information.getEvaluationMethod(), information.getEvaluationMethodEn(), information.getCompetenceCourse(), information.getCompetenceCourseLevel(), information.getExecutionPeriod(), requester, information.getTheoreticalHours(1), information.getProblemsHours(1), information.getLaboratorialHours(1), information.getSeminaryHours(1), information.getFieldWorkHours(1), information.getTrainingPeriodHours(1), information.getTutorialOrientationHours(1), information.getOtherHours(1), information.getAutonomousWorkHours(1), information.getEctsCredits(1), information.getTheoreticalHours(2), information.getProblemsHours(2), information.getLaboratorialHours(2), information.getSeminaryHours(2), information.getFieldWorkHours(2), information.getTrainingPeriodHours(2), information.getTutorialOrientationHours(2), information.getOtherHours(2), information.getAutonomousWorkHours(2), information.getEctsCredits(2), information.getBibliographicReferences(), information.getCompetenceCourseGroupUnit());
    }

    public CompetenceCourseInformationChangeRequest(String name, String nameEn, String justification, RegimeType regime, String objectives, String objectivesEn, String program, String programEn, String evaluationMethod, String evaluationMethodEn, CompetenceCourse course, CompetenceCourseLevel level, ExecutionSemester period, Person requester, Double theoreticalHours, Double problemsHours, Double laboratorialHours, Double seminaryHours, Double fieldWorkHours, Double trainingPeriodHours, Double tutorialOrientationHours, Double otherHours, Double autonomousWorkHours, Double ectsCredits, Double secondTheoreticalHours, Double secondProblemsHours, Double secondLaboratorialHours, Double secondSeminaryHours, Double secondFieldWorkHours, Double secondTrainingPeriodHours, Double secondTutorialOrientationHours, Double secondOtherHours, Double secondAutonomousWorkHours, Double secondEctsCredits, BibliographicReferences references, CompetenceCourseGroupUnit group) {
        this();
        if (course.isRequestDraftAvailable(period)) {
            throw new DomainException("error.can.only.exist.one.request.draft.per.execution.period", new String[0]);
        }
        if (course == null || period == null) {
            throw new DomainException("error.fields.are.required", new String[0]);
        }
        this.setCompetenceCourse(course);
        this.setExecutionPeriod(period);
        this.edit(name, nameEn, justification, regime, objectives, objectivesEn, program, programEn, evaluationMethod, evaluationMethodEn, level, requester, theoreticalHours, problemsHours, laboratorialHours, seminaryHours, fieldWorkHours, trainingPeriodHours, tutorialOrientationHours, otherHours, autonomousWorkHours, ectsCredits, secondTheoreticalHours, secondProblemsHours, secondLaboratorialHours, secondSeminaryHours, secondFieldWorkHours, secondTrainingPeriodHours, secondTutorialOrientationHours, secondOtherHours, secondAutonomousWorkHours, secondEctsCredits, references, group);
    }

    public void edit(String name, String nameEn, String justification, RegimeType regime, String objectives, String objectivesEn, String program, String programEn, String evaluationMethod, String evaluationMethodEn, CompetenceCourseLevel level, Person requester, Double theoreticalHours, Double problemsHours, Double laboratorialHours, Double seminaryHours, Double fieldWorkHours, Double trainingPeriodHours, Double tutorialOrientationHours, Double otherHours, Double autonomousWorkHours, Double ectsCredits, Double secondTheoreticalHours, Double secondProblemsHours, Double secondLaboratorialHours, Double secondSeminaryHours, Double secondFieldWorkHours, Double secondTrainingPeriodHours, Double secondTutorialOrientationHours, Double secondOtherHours, Double secondAutonomousWorkHours, Double secondEctsCredits, BibliographicReferences references, CompetenceCourseGroupUnit group) {
        if (name == null || nameEn == null || justification == null || regime == null || objectives == null || objectivesEn == null || program == null || programEn == null || evaluationMethod == null || evaluationMethodEn == null || requester == null || theoreticalHours == null || problemsHours == null || laboratorialHours == null || seminaryHours == null || fieldWorkHours == null || trainingPeriodHours == null || tutorialOrientationHours == null || otherHours == null || autonomousWorkHours == null || ectsCredits == null) {
            throw new DomainException("error.fields.are.required", new String[0]);
        }
        if (level == null) {
            level = CompetenceCourseLevel.UNKNOWN;
        }
        this.setName(name);
        this.setNameEn(nameEn);
        this.setJustification(justification);
        this.setRegime(regime);
        this.setObjectives(objectives);
        this.setObjectivesEn(objectivesEn);
        this.setProgram(program);
        this.setProgramEn(programEn);
        this.setEvaluationMethod(evaluationMethod);
        this.setEvaluationMethodEn(evaluationMethodEn);
        this.setRequester(requester);
        this.setApproved(null);
        this.setCompetenceCourseLevel(level);
        this.setTheoreticalHours(theoreticalHours);
        this.setProblemsHours(problemsHours);
        this.setLaboratorialHours(laboratorialHours);
        this.setSeminaryHours(seminaryHours);
        this.setFieldWorkHours(fieldWorkHours);
        this.setTrainingPeriodHours(trainingPeriodHours);
        this.setTutorialOrientationHours(tutorialOrientationHours);
        this.setOtherHours(otherHours);
        this.setAutonomousWorkHours(autonomousWorkHours);
        this.setEctsCredits(ectsCredits);
        this.setSecondTheoreticalHours(secondTheoreticalHours);
        this.setSecondProblemsHours(secondProblemsHours);
        this.setSecondLaboratorialHours(secondLaboratorialHours);
        this.setSecondSeminaryHours(secondSeminaryHours);
        this.setSecondFieldWorkHours(secondFieldWorkHours);
        this.setSecondTrainingPeriodHours(secondTrainingPeriodHours);
        this.setSecondTutorialOrientationHours(secondTutorialOrientationHours);
        this.setSecondOtherHours(secondOtherHours);
        this.setSecondAutonomousWorkHours(secondAutonomousWorkHours);
        this.setSecondEctsCredits(secondEctsCredits);
        this.setBibliographicReferences(references);
        this.setCompetenceCourseGroupUnit(group == null ? this.getCompetenceCourse().getCompetenceCourseGroupUnit() : group);
    }

    public RequestStatus getStatus() {
        if (this.getApproved() == null) {
            return RequestStatus.ON_HOLD;
        }
        return this.getApproved() != false ? RequestStatus.APPROVED : RequestStatus.REJECTED;
    }

    public ScientificAreaUnit getScientificAreaUnit() {
        return this.getCompetenceCourseGroupUnit().getScientificAreaUnit();
    }

    public DepartmentUnit getDepartmentUnit() {
        return this.getCompetenceCourseGroupUnit().getDepartmentUnit();
    }

    public void delete() {
        this.setCompetenceCourse(null);
        this.setAnalizedBy(null);
        this.setRequester(null);
        this.setExecutionPeriod(null);
        this.setRootDomainObject(null);
        this.setCompetenceCourseGroupUnit(null);
        super.deleteDomainObject();
    }

    public void reject(Person person) {
        Object object = advice$reject.perform((Callable)new CompetenceCourseInformationChangeRequest$callable$reject(this, person));
    }

    static /* synthetic */ void advised$reject(CompetenceCourseInformationChangeRequest this_, Person analisedBy) {
        if (!CompetenceCourseManagementAccessControl.isLoggedPersonAllowedToApproveChangeRequestsPredicate(this_)) {
            AccessControl.check(null);
        }
        if (this_.getApproved() != null) {
            throw new DomainException("error.request.already.processed", new String[0]);
        }
        this_.setApproved(false);
        this_.setAnalizedBy(analisedBy);
    }

    public void approve(Person person) {
        Object object = advice$approve.perform((Callable)new CompetenceCourseInformationChangeRequest$callable$approve(this, person));
    }

    static /* synthetic */ void advised$approve(CompetenceCourseInformationChangeRequest this_, Person analisedBy) {
        if (!CompetenceCourseManagementAccessControl.isLoggedPersonAllowedToApproveChangeRequestsPredicate(this_)) {
            AccessControl.check(null);
        }
        if (this_.getApproved() != null) {
            throw new DomainException("error.request.already.processed", new String[0]);
        }
        this_.setApproved(true);
        this_.setAnalizedBy(analisedBy);
        CompetenceCourse course = this_.getCompetenceCourse();
        ExecutionSemester executionSemester = this_.getExecutionPeriod();
        CompetenceCourseInformation information = null;
        if (course.isCompetenceCourseInformationDefinedAtExecutionPeriod(executionSemester)) {
            information = course.findCompetenceCourseInformationForExecutionPeriod(executionSemester);
            information.edit(this_.getName(), this_.getNameEn(), information.getBasic(), this_.getCompetenceCourseLevel(), this_.getCompetenceCourseGroupUnit());
            information.setRegime(this_.getRegime());
            information.edit(this_.getObjectives(), this_.getProgram(), this_.getEvaluationMethod(), this_.getObjectivesEn(), this_.getProgramEn(), this_.getEvaluationMethodEn());
            information.setBibliographicReferences(this_.getBibliographicReferences());
            while (!information.getCompetenceCourseLoadsSet().isEmpty()) {
                ((CompetenceCourseLoad)information.getCompetenceCourseLoadsSet().iterator().next()).delete();
            }
            this_.createLoads(information);
        } else {
            information = new CompetenceCourseInformation(this_.getName(), this_.getNameEn(), course.isBasic(), this_.getRegime(), this_.getCompetenceCourseLevel(), this_.getExecutionPeriod(), this_.getCompetenceCourseGroupUnit());
            information.edit(this_.getObjectives(), this_.getProgram(), this_.getEvaluationMethod(), this_.getObjectivesEn(), this_.getProgramEn(), this_.getEvaluationMethodEn());
            information.setAcronym(course.getAcronym());
            information.setBibliographicReferences(this_.getBibliographicReferences());
            course.addCompetenceCourseInformations(information);
            this_.createLoads(information);
        }
    }

    private void createLoads(CompetenceCourseInformation information) {
        CompetenceCourseLoad courseLoad = new CompetenceCourseLoad(this.getTheoreticalHours(), this.getProblemsHours(), this.getLaboratorialHours(), this.getSeminaryHours(), this.getFieldWorkHours(), this.getTrainingPeriodHours(), this.getTutorialOrientationHours(), this.getOtherHours(), this.getAutonomousWorkHours(), this.getEctsCredits(), 1, this.getRegime() == RegimeType.SEMESTRIAL ? AcademicPeriod.SEMESTER : AcademicPeriod.YEAR);
        information.addCompetenceCourseLoads(courseLoad);
        if (this.getRegime() == RegimeType.ANUAL) {
            CompetenceCourseLoad secondCourseLoad = new CompetenceCourseLoad(this.getSecondTheoreticalHours(), this.getSecondProblemsHours(), this.getSecondLaboratorialHours(), this.getSecondSeminaryHours(), this.getSecondFieldWorkHours(), this.getSecondTrainingPeriodHours(), this.getSecondTutorialOrientationHours(), this.getSecondOtherHours(), this.getSecondAutonomousWorkHours(), this.getSecondEctsCredits(), 2, AcademicPeriod.YEAR);
            information.addCompetenceCourseLoads(secondCourseLoad);
        }
    }

    public boolean isLoggedPersonAllowedToEdit() {
        return CompetenceCourseManagementAccessControl.isLoggedPersonAllowedToManageChangeRequests(this.getCompetenceCourse(), (ExecutionInterval)((Object)this.getExecutionPeriod()));
    }

    public static enum RequestStatus {
        APPROVED,
        REJECTED,
        ON_HOLD;

    }
}

