/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import java.util.Collection;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.RestrictionDoneDegreeModule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentResultType;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;

public class RestrictionDoneDegreeModuleExecutor
extends CurricularRuleExecutor {
    @Override
    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        RestrictionDoneDegreeModule rule = (RestrictionDoneDegreeModule)((Object)curricularRule);
        if (!this.canApplyRule(enrolmentContext, (ICurricularRule)((Object)rule))) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        CurricularCourse curricularCourse = rule.getPrecedenceDegreeModule();
        if (this.isApproved(enrolmentContext, curricularCourse)) {
            return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        if (this.isEnrolledOrEnrollingInSameSemester(enrolmentContext, rule)) {
            return this.createFalseOrImpossibleResult(enrolmentContext, rule, sourceDegreeModuleToEvaluate, "curricularRules.ruleExecutors.RestrictionDoneDegreeModuleExecutor.cannot.enrol.simultaneously.to.degreeModule.and.precedenceDegreeModule");
        }
        return enrolmentContext.isToEvaluateRulesByYear() ? this.evaluateByYear(sourceDegreeModuleToEvaluate, enrolmentContext, rule, curricularCourse) : this.evaluateBySemester(sourceDegreeModuleToEvaluate, enrolmentContext, rule, curricularCourse);
    }

    private RuleResult evaluateByYear(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext, RestrictionDoneDegreeModule rule, CurricularCourse curricularCourse) {
        if (this.isEnroled(enrolmentContext, (DegreeModule)((Object)curricularCourse)) && !this.hasEnrolmentWithEnroledState(enrolmentContext, curricularCourse, enrolmentContext.getExecutionYear())) {
            return this.createFalseOrImpossibleResult(enrolmentContext, rule, sourceDegreeModuleToEvaluate, "curricularRules.ruleExecutors.RestrictionDoneDegreeModuleExecutor.student.is.not.approved.to.precendenceDegreeModule");
        }
        if (this.isEnrolledOrEnrolling(enrolmentContext, (DegreeModule)((Object)curricularCourse), enrolmentContext.getExecutionYear().getFirstExecutionPeriod()) && this.isEnrolledOrEnrolling(enrolmentContext, (DegreeModule)((Object)rule.getDegreeModuleToApplyRule()), enrolmentContext.getExecutionYear().getLastExecutionPeriod())) {
            return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        return this.createFalseOrImpossibleResult(enrolmentContext, rule, sourceDegreeModuleToEvaluate, "curricularRules.ruleExecutors.RestrictionDoneDegreeModuleExecutor.student.is.not.approved.to.precendenceDegreeModule");
    }

    private boolean isEnrolledOrEnrollingInSameSemester(EnrolmentContext enrolmentContext, RestrictionDoneDegreeModule rule) {
        for (ExecutionSemester executionPeriod : enrolmentContext.getExecutionYear().getExecutionPeriodsSet()) {
            if (!this.isEnrolledOrEnrolling(enrolmentContext, (DegreeModule)((Object)rule.getDegreeModuleToApplyRule()), executionPeriod) || !this.isEnrolledOrEnrolling(enrolmentContext, (DegreeModule)((Object)rule.getPrecedenceDegreeModule()), executionPeriod)) continue;
            return true;
        }
        return false;
    }

    private boolean isEnrolledOrEnrolling(EnrolmentContext enrolmentContext, DegreeModule degreeModule, ExecutionSemester period) {
        CurricularCourse curricularCourse = (CurricularCourse)((Object)degreeModule);
        return this.hasEnrolmentWithEnroledState(enrolmentContext, curricularCourse, period) || this.isEnrolling(enrolmentContext, (DegreeModule)((Object)curricularCourse), period);
    }

    private RuleResult evaluateBySemester(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext, RestrictionDoneDegreeModule rule, CurricularCourse curricularCourse) {
        return this.createFalseOrImpossibleResult(enrolmentContext, rule, sourceDegreeModuleToEvaluate, "curricularRules.ruleExecutors.RestrictionDoneDegreeModuleExecutor.student.is.not.approved.to.precendenceDegreeModule");
    }

    private RuleResult createFalseOrImpossibleResult(EnrolmentContext enrolmentContext, RestrictionDoneDegreeModule rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, String message) {
        if (this.isEnroled(enrolmentContext, (DegreeModule)((Object)rule.getDegreeModuleToApplyRule()))) {
            return this.createImpossibleRuleResult(rule, sourceDegreeModuleToEvaluate, message);
        }
        return this.createFalseRuleResult(rule, sourceDegreeModuleToEvaluate, message);
    }

    @Override
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        RestrictionDoneDegreeModule rule = (RestrictionDoneDegreeModule)((Object)curricularRule);
        RuleResult ruleResult = this.executeEnrolmentVerificationWithRules(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
        if ((ruleResult.isFalse() || ruleResult.isImpossibleEnrolmentResultType(sourceDegreeModuleToEvaluate.getDegreeModule())) && this.hasPreviousPeriodEnrolmentWithEnroledState(enrolmentContext, rule.getPrecedenceDegreeModule())) {
            return RuleResult.createTrue(EnrolmentResultType.TEMPORARY, sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        return ruleResult;
    }

    private boolean hasPreviousPeriodEnrolmentWithEnroledState(EnrolmentContext enrolmentContext, CurricularCourse curricularCourse) {
        if (enrolmentContext.isToEvaluateRulesByYear()) {
            return this.hasEnrolmentWithEnroledState(enrolmentContext, curricularCourse, enrolmentContext.getExecutionYear().getPreviousExecutionYear());
        }
        return this.hasEnrolmentWithEnroledState(enrolmentContext, curricularCourse, enrolmentContext.getExecutionPeriod().getPreviousExecutionPeriod());
    }

    private RuleResult createFalseRuleResult(RestrictionDoneDegreeModule rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, String message) {
        return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), message, rule.getDegreeModuleToApplyRule().getName(), rule.getPrecedenceDegreeModule().getName());
    }

    private RuleResult createImpossibleRuleResult(RestrictionDoneDegreeModule rule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, String message) {
        return RuleResult.createImpossible(sourceDegreeModuleToEvaluate.getDegreeModule(), message, rule.getDegreeModuleToApplyRule().getName(), rule.getPrecedenceDegreeModule().getName());
    }

    @Override
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        RestrictionDoneDegreeModule restrictionDoneDegreeModule = (RestrictionDoneDegreeModule)((Object)curricularRule);
        Collection cycleCourseGroups = restrictionDoneDegreeModule.getPrecedenceDegreeModule().getParentCycleCourseGroups();
        for (CycleCourseGroup cycleCourseGroup : cycleCourseGroups) {
            CycleCurriculumGroup cycleCurriculumGroup = (CycleCurriculumGroup)((Object)enrolmentContext.getStudentCurricularPlan().findCurriculumGroupFor((CourseGroup)((Object)cycleCourseGroup)));
            if (cycleCurriculumGroup == null) continue;
            return true;
        }
        return false;
    }
}

