/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.AnyCurricularCourse;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnroledOptionalEnrolment;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.enrolment.OptionalDegreeModuleToEnrol;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.util.CurricularRuleLabelFormatter;

public class AnyCurricularCourseExecutor
extends CurricularRuleExecutor {
    @Override
    protected RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return this.executeEnrolmentVerificationWithRules(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
    }

    @Override
    protected RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    @Override
    protected RuleResult executeEnrolmentVerificationWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        CurricularCourse curricularCourseToEnrol;
        AnyCurricularCourse rule = (AnyCurricularCourse)((Object)curricularRule);
        if (!rule.appliesToContext(sourceDegreeModuleToEvaluate.getContext())) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        if (sourceDegreeModuleToEvaluate.isEnroling()) {
            OptionalDegreeModuleToEnrol optionalDegreeModuleToEnrol = (OptionalDegreeModuleToEnrol)sourceDegreeModuleToEvaluate;
            curricularCourseToEnrol = optionalDegreeModuleToEnrol.getCurricularCourse();
            if (this.isApproved(enrolmentContext, curricularCourseToEnrol) || this.isEnroled(enrolmentContext, (DegreeModule)((Object)curricularCourseToEnrol)) || this.isApproved(enrolmentContext, optionalDegreeModuleToEnrol.getCurricularCourse()) || this.isEnroled(enrolmentContext, (DegreeModule)((Object)optionalDegreeModuleToEnrol.getCurricularCourse()))) {
                return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule(), "curricularRules.ruleExecutors.AnyCurricularCourseExecutor.already.approved.or.enroled", curricularCourseToEnrol.getName(), rule.getDegreeModuleToApplyRule().getName());
            }
        } else if (sourceDegreeModuleToEvaluate.isEnroled()) {
            curricularCourseToEnrol = (CurricularCourse)((Object)((EnroledOptionalEnrolment)sourceDegreeModuleToEvaluate).getCurriculumModule().getDegreeModule());
        } else {
            throw new DomainException("error.curricularRules.executors.ruleExecutors.AnyCurricularCourseExecutor.unexpected.degree.module.to.evaluate", new String[0]);
        }
        ExecutionSemester executionSemester = enrolmentContext.getExecutionPeriod();
        Degree degree = curricularCourseToEnrol.getDegree();
        boolean result = true;
        result &= rule.hasMinimumCredits() ? rule.getMinimumCredits() <= curricularCourseToEnrol.getEctsCredits(executionSemester) : true;
        result &= rule.hasMaximumCredits() ? rule.getMaximumCredits() >= curricularCourseToEnrol.getEctsCredits(executionSemester) : true;
        result &= rule.getDegree() != null ? rule.getDegree() == degree : (rule.hasBolonhaDegreeType() ? degree.getDegreeType() == rule.getBolonhaDegreeType() : true);
        if (rule.getDepartmentUnit() != null) {
            DepartmentUnit departmentUnit = curricularCourseToEnrol.getCompetenceCourse().getDepartmentUnit(executionSemester);
            result &= departmentUnit != null && departmentUnit.equals((Object)rule.getDepartmentUnit());
        }
        if (result) {
            return RuleResult.createTrue(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        if (sourceDegreeModuleToEvaluate.isEnroled()) {
            return RuleResult.createImpossibleWithLiteralMessage(sourceDegreeModuleToEvaluate.getDegreeModule(), CurricularRuleLabelFormatter.getLabel((ICurricularRule)((Object)rule)));
        }
        return RuleResult.createFalseWithLiteralMessage(sourceDegreeModuleToEvaluate.getDegreeModule(), CurricularRuleLabelFormatter.getLabel((ICurricularRule)((Object)rule)));
    }

    @Override
    protected boolean canBeEvaluated(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        return true;
    }
}

