/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.CompositeRule;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleNotPersistent;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.GenericPair;

public class EnrolmentInSpecialSeasonEvaluation
extends CurricularRuleNotPersistent {
    private Enrolment toApply;
    private EvaluationSeason evaluationSeason;

    public EnrolmentInSpecialSeasonEvaluation(Enrolment enrolment, EvaluationSeason evaluationSeason) {
        if (enrolment == null || evaluationSeason == null) {
            throw new DomainException("curricular.rule.invalid.parameters", new String[0]);
        }
        this.toApply = enrolment;
        this.evaluationSeason = evaluationSeason;
    }

    @Override
    public List<GenericPair<Object, Boolean>> getLabel() {
        return Collections.singletonList(new GenericPair<String, Boolean>("label.enrolmentInSpecialSeasonEvaluation", true));
    }

    public Enrolment getEnrolment() {
        return this.toApply;
    }

    public EvaluationSeason getEvaluationSeason() {
        return this.evaluationSeason;
    }

    @Override
    public DegreeModule getDegreeModuleToApplyRule() {
        return this.getEnrolment().getDegreeModule();
    }

    @Override
    public CourseGroup getContextCourseGroup() {
        return null;
    }

    @Override
    public CompositeRule getParentCompositeRule() {
        return null;
    }

    @Override
    public CurricularRuleType getCurricularRuleType() {
        return CurricularRuleType.ENROLMENT_IN_SPECIAL_SEASON_EVALUATION;
    }

    @Override
    public ExecutionSemester getBegin() {
        return ExecutionSemester.readActualExecutionSemester();
    }

    @Override
    public ExecutionSemester getEnd() {
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof EnrolmentInSpecialSeasonEvaluation) {
            EnrolmentInSpecialSeasonEvaluation enrolmentInSpecialSeasonEvaluation = (EnrolmentInSpecialSeasonEvaluation)obj;
            return this.toApply == enrolmentInSpecialSeasonEvaluation.getEnrolment();
        }
        return false;
    }

    @Override
    public VerifyRuleExecutor createVerifyRuleExecutor() {
        return VerifyRuleExecutor.NULL_VERIFY_EXECUTOR;
    }
}

